// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// i18n.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "i18n.h"
#include <afxtempl.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


template <> BOOL AFXAPI CompareElements<LPCTSTR, LPCTSTR>( const LPCTSTR* pElement1, const LPCTSTR* pElement2);

CMap<LPCTSTR, LPCTSTR, LPCTSTR, LPCTSTR>  m_LangMap(100);

LPTSTR  m_pData = NULL;
LPCTSTR m_pLastInputStr  = NULL;
LPCTSTR m_pLastOutputStr = NULL;
TCHAR	m_CurrentLangFile[MAX_PATH] = _T("");


BOOL GetNextItem(LPTSTR& pNext, LPTSTR& pEn, LPTSTR& pTrans);
void Expand(LPTSTR pData);


BOOL LoadLanguageFile(LPCTSTR szFile)
{
	m_LangMap.RemoveAll();
	m_LangMap.InitHashTable(601);

	if(m_pData != NULL)
	{
		delete [] m_pData;
		m_pData = NULL;
	}

	if(szFile == NULL || *szFile == _T('\0'))
	{
		m_CurrentLangFile[0] = _T('\0');
		return TRUE;
	}
	
	LPSTR pData = NULL;
	try 
	{
		CFile File(szFile, CFile::modeRead);
        unsigned int nFileLen = static_cast<unsigned int>(File.GetLength());
		pData = new char[nFileLen + 1];
		File.Read(pData, nFileLen);
		pData[nFileLen] = 0;
		File.Close();
		_tcsncpy(m_CurrentLangFile, szFile, sizeof(m_CurrentLangFile)/sizeof(TCHAR));
	}
	catch(CFileException* e)
	{
		m_CurrentLangFile[0] = _T('\0');
		e->ReportError();
		e->Delete();
		if(pData) delete [] pData;
		return FALSE;
	}

#ifdef UNICODE
	int nSize = ::MultiByteToWideChar(CP_ACP, 0, pData, -1, 0, 0);
	m_pData = new WCHAR[nSize+1];
	BOOL bRes = (BOOL)::MultiByteToWideChar(CP_ACP, 0, pData, -1, m_pData, nSize);
	m_pData[nSize] = 0;
	delete [] pData;
	if(bRes == FALSE)
		return FALSE;
#else
	m_pData = pData;
#endif

	LPTSTR pNext = m_pData;
	LPTSTR pEn = NULL;
	LPTSTR pTrans = NULL;

	while(GetNextItem(pNext, pEn, pTrans))
		m_LangMap[pEn] = pTrans;
	
	return TRUE;
}

BOOL GetNextItem(LPTSTR& pNext, LPTSTR& pEn, LPTSTR& pTrans)
{
	while(1)
	{
		pEn = pNext;
		
		if(pEn == NULL || *pEn == 0) 
			return FALSE;
	
		pNext = _tcschr(pNext, _T('\n'));
		if(pNext != NULL)
			++pNext;

		if(*pEn == '#') 
			continue;

		LPTSTR pEnd = _tcschr(pEn, _T('\r'));
		if(pEnd != NULL)
			*pEnd = 0;

		pTrans = _tcsstr(pEn, _T("<=>"));
		if(pTrans != NULL) 
		{
			*pTrans = 0;
			pTrans += 3;
			break;
		}
	}

	Expand(pEn);
	Expand(pTrans);
	
	return TRUE;
}

void Expand(LPTSTR pData)
{
	LPTSTR pTrg, pSrc;

	while(NULL != (pTrg = _tcsstr(pData, _T("{TAB}"))))
	{
		pSrc = pTrg + 5;
		*pTrg++ = _T('\t');
		
		while(*pSrc)
			*pTrg++ = *pSrc++;

		*pTrg = 0;
	}

	while(NULL != (pTrg = _tcsstr(pData, _T("{BR}"))))
	{
		pSrc = pTrg + 4;
		*pTrg++ = _T('\r');
		*pTrg++ = _T('\n');
		
		while(*pSrc)
			*pTrg++ = *pSrc++;

		*pTrg = 0;
	}
}

LPCTSTR Internationalization(LPCTSTR szEn)
{
	m_pLastInputStr = szEn;
	if(!m_LangMap.Lookup(szEn, m_pLastOutputStr))
		m_pLastOutputStr = szEn;
	else
		if(*m_pLastOutputStr == _T('\0'))
			m_pLastOutputStr = szEn;
	
	return m_pLastOutputStr;
}

void FreeI18nBuffer()
{
	if(m_pData != NULL) 
	{
		delete [] m_pData;
		m_pData = NULL;
	}
}

template <> BOOL AFXAPI CompareElements<LPCTSTR, LPCTSTR>(const LPCTSTR* pElement1, const LPCTSTR* pElement2)
{
	return (_tcscmp(*pElement1, *pElement2) == 0);
}

LPCTSTR GetLastOutputStr()
{
	return m_pLastOutputStr;
}

LPCTSTR GetLastInputStr()
{
	return m_pLastInputStr;
}

LPCTSTR GetCurrentLangFile()
{
	return m_CurrentLangFile;
}