// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// Version.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_VERSION_H_)
#define AFX_VERSION_H_

#if _MSC_VER > 1000
#pragma once
#endif 


class CVersion  
{

public:
	CVersion() :
	  			m_dwMajor(0),
				m_dwMinor(0),
				m_dwSub(0),
				m_bBeta(FALSE)
	{}

	CVersion(DWORD dwMajor, DWORD dwMinor, DWORD dwSub, BOOL bBeta) :
				m_dwMajor(dwMajor),
				m_dwMinor(dwMinor),
				m_dwSub(dwSub),
				m_bBeta(bBeta)
	{}
	
	~CVersion() {}

	void SetMajor(DWORD dwMajor) {	m_dwMajor = dwMajor; }
	void SetMinor(DWORD dwMinor) {	m_dwMinor = dwMinor; }
	void SetSub(DWORD dwSub)	 {	m_dwSub = dwSub;	 }
	void SetBeta(DWORD bBeta)	 {	m_bBeta = bBeta;	 }

	DWORD GetMajor() const {  return m_dwMajor; }
	DWORD GetMinor() const {  return m_dwMinor; }
	DWORD GetSub()	 const {  return m_dwSub;   }
	BOOL  IsBeta()	 const {  return m_bBeta;   }

	BOOL ReadFromString(LPCTSTR szSt);
	CString GetString()   const;

	bool operator==(const CVersion&);
	bool operator!=(const CVersion&);
	bool operator<(const CVersion&);
	bool operator>(const CVersion&);
	bool operator<=(const CVersion&);
	bool operator>=(const CVersion&);

	static BOOL ParseVersionInfo(CString stInfo, CVersion& Release, CString& stReleaseInfoLink, CVersion& Beta, CString& stBetaInfoLink);

private:
	DWORD m_dwMajor;
	DWORD m_dwMinor;
	DWORD m_dwSub;
	BOOL  m_bBeta;

};

#endif // !defined(AFX_VERSION_H_)
