// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// Version.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "Version.h"
#include "StrFunctions.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


bool CVersion::operator==(const CVersion& V2) 
{
	return  m_dwMajor == V2.m_dwMajor && 
			m_dwMinor == V2.m_dwMinor && 
			m_dwSub == V2.m_dwSub &&
			m_bBeta == V2.m_bBeta;
}

bool CVersion::operator!=(const CVersion& V2) 
{
	return !(*this == V2);
}


bool CVersion::operator<(const CVersion& V2) 
{
	if(m_dwMajor < V2.m_dwMajor)
		return true;
	else if(m_dwMajor > V2.m_dwMajor)
		return false;

	if(m_dwMinor < V2.m_dwMinor)
		return true;
	else if(m_dwMinor > V2.m_dwMinor)
		return false;

	if(m_bBeta == V2.m_bBeta) {

		if(m_dwSub < V2.m_dwSub)
			return true;
		else
			return false;
	}
	
	if(m_bBeta) 
		return true;
	
	return false;
}

bool CVersion::operator>(const CVersion& V2)
{
	if(*this == V2)
		return false;

	return !(*this < V2);
}

bool CVersion::operator>=(const CVersion& V2) 
{
	if(*this == V2)
		return true;

	return !(*this < V2);
}

bool CVersion::operator<=(const CVersion& V2) 
{
	if(*this == V2)
		return true;

	return (*this < V2);
}


bool GetNextNumber(LPTSTR pWrite, LPCTSTR& pRead, int nMaxWrite) 
{
	int i = 0;
	while(*pRead != _T('\0') && ((unsigned)*pRead) >= _T('0') && ((unsigned)*pRead) <= _T('9') && i+1 < nMaxWrite) {
		*pWrite++ = *pRead++;
		++i;
	}

	*pWrite = _T('\0');
	return *pRead == _T('.');
}

BOOL CVersion::ReadFromString(LPCTSTR szSt) 
{
	if(szSt == NULL || szSt[0] == _T('\0')) 
		return FALSE;

	LPCTSTR pR = szSt;
	while(*pR != _T('\0') && ((unsigned)*pR) <= _T(' ')) 
		++pR;
		
	TCHAR szBuf[8] = _T("");

	if(!GetNextNumber(szBuf, pR, sizeof(szBuf)/sizeof(TCHAR)))
		return FALSE;

	m_dwMajor = _ttoi(szBuf);
	++pR;

	if(!GetNextNumber(szBuf, pR, sizeof(szBuf)/sizeof(TCHAR)))
		return FALSE;

	m_dwMinor = _ttoi(szBuf);
	++pR;

	GetNextNumber(szBuf, pR, sizeof(szBuf)/sizeof(TCHAR));
	m_dwSub = _ttoi(szBuf);

	return TRUE;
}

CString CVersion::GetString() const 
{	
	CString stFormat;
	stFormat.Format(_T("%d.%d.%d"), m_dwMajor, m_dwMinor, m_dwSub);
	return stFormat;
}

BOOL CVersion::ParseVersionInfo(CString stData, CVersion& Release, CString& stReleaseInfoLink, CVersion& Beta, CString& stBetaInfoLink)
{
	if(!Release.ReadFromString(stData))
		return FALSE;

	stReleaseInfoLink = Parse(stData, _T("\n"));
	Parse(stReleaseInfoLink, _T(" "));
	stReleaseInfoLink = Parse(stReleaseInfoLink, _T(" "));
	stReleaseInfoLink.TrimLeft();
	stReleaseInfoLink.TrimRight();

	if(!Beta.ReadFromString(stData))
		return FALSE;

	
	stBetaInfoLink = Parse(stData, _T("\n"));
	Parse(stBetaInfoLink, _T(" "));
	stBetaInfoLink = Parse(stBetaInfoLink, _T(" "));
	stBetaInfoLink.TrimLeft();
	stBetaInfoLink.TrimRight();

	Release.SetBeta(FALSE);
	Beta.SetBeta(TRUE);

	return TRUE;
}