// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// TrayIcon.h
//
////////////////////////////////////////////////////////////////////////////////


#ifndef _TRAYICON_H
#define _TRAYICON_H

#include <afxtempl.h>


typedef struct _NOTIFYICONDATA_IE5 { 
    DWORD cbSize; 
    HWND hWnd; 
    UINT uID; 
    UINT uFlags; 
    UINT uCallbackMessage; 
    HICON hIcon; 
    TCHAR szTip[128];
    DWORD dwState; 
    DWORD dwStateMask; 
    TCHAR szInfo[256]; 
    union {
        UINT  uTimeout; 
        UINT  uVersion; 
    } DUMMYUNIONNAME;
    TCHAR szInfoTitle[64]; 
    DWORD dwInfoFlags; 
} NOTIFYICONDATA_IE5; 

#define NIF_INFO        0x00000010
#define NIIF_INFO       0x00000001



typedef void (*CallbackFunc)(int);


struct TIPICON
{
	HICON hIcon;
	CString stTip;
	BOOL bDestroy;
};


typedef CArray<TIPICON, TIPICON&> CIcons;



class CTrayIcon : protected CWnd 
{
protected:
   NOTIFYICONDATA_IE5	m_nid;
   
public:
	CTrayIcon(UINT uID);
	~CTrayIcon();

	BOOL EnableHighColorTray();

	BOOL SetIcon(UINT uIconID, LPCTSTR lpTip); 
	BOOL SetIcon(HICON hIcon, LPCTSTR lpTip, BOOL bDisposeIcon);
	void RemoveIcon();

	BOOL BallonsEnabled() const { return m_bBallonsEnabled; }
	BOOL HighColorTrayEnabled() const { return m_bHighColorTrayEnabled; }
		
	BOOL ShowBalloonTip(LPCTSTR szMsg, LPCTSTR szTitle, UINT uTimeout = 6000, DWORD dwInfoFlags = NIIF_INFO);

	CallbackFunc m_fnCallback;

	void SetIcons(const CIcons& Icons, UINT nInterval);

	BOOL  m_bDoubleClickDelay;
	
private:
	LRESULT OnTrayNotification(WPARAM uID, LPARAM lEvent);

protected:
	void UnloadTrayDLL();
	void OnNextIcon();
	BOOL DoSetIcon(HICON hIcon, LPCTSTR lpTip);

	BOOL m_bBallonsEnabled;
	BOOL CheckBallonsEnabled();

	BOOL m_bHighColorTrayEnabled;
	BOOL CheckHighColorTrayEnabled();

	CString m_stCurrentTip;

	BOOL m_bDelayTimer;
	BOOL m_bIconTimer;
	int  m_nIconIdx;
	
	CIcons m_Icons;

	BOOL m_bDisposeIcon;
	
	HINSTANCE m_hTrayDLL;

	BOOL m_bEatDelayedClick;
	POINT m_ptLeftClick;

	//{{AFX_MSG(CTrayIcon)
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnDestroy();
	//}}AFX_MSG
	afx_msg LRESULT OnTaskBarCreated(WPARAM wp, LPARAM lp);
    afx_msg LRESULT OnPopmanTrayMsg(WPARAM, LPARAM);

	DECLARE_MESSAGE_MAP()
};

#endif

