// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// TrayIcon.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "TrayIcon.h"
#include <shlwapi.h>

#define WM_MY_TRAY_NOTIFICATION  WM_USER + 0

#define TIMER_ID_DELAY 1
#define TIMER_ID_ICONS 2
#define TIMER_ID_HIGHCOLORTRAY 3

const UINT WM_TASKBARCREATED = ::RegisterWindowMessage(_T("TaskbarCreated"));


#define POPMAN_TRAYICON_MSG_0167348 _T("Popman-TrayIcon-Msg-0167348")
static const UINT UWM_AM_I_TRAYICON = ::RegisterWindowMessage(POPMAN_TRAYICON_MSG_0167348);


// CALLBACK should be CDECL !!!
typedef void (CALLBACK* DLLHOOKPROC)(void);


BEGIN_MESSAGE_MAP(CTrayIcon, CWnd)
	//{{AFX_MSG_MAP(CTrayIcon)
	ON_WM_TIMER()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_MY_TRAY_NOTIFICATION, OnTrayNotification)
	ON_REGISTERED_MESSAGE(WM_TASKBARCREATED, OnTaskBarCreated)
    ON_REGISTERED_MESSAGE(UWM_AM_I_TRAYICON, OnPopmanTrayMsg)
END_MESSAGE_MAP()



/*
CFile m_LogFile;
bool m_bLoggingEnabled = true;


void Log(const void* pData, int nDataLen)
{
	if (!m_bLoggingEnabled) return;

	try
	{
		if(m_LogFile.m_hFile == CFile::hFileNull)
		{
			CString stFileName;
			stFileName = CPopManApp::GetAppPath();
			if(stFileName.Right(1) != _T("\\")) stFileName += _T('\\');
			stFileName += _T("TrayIcon.log");

			if(!m_LogFile.Open(stFileName, CFile::shareDenyNone | CFile::modeWrite | CFile::modeCreate )  )
			{
				m_bLoggingEnabled = false;

				CString stErr = "The TrayIcon log file could not be opened.\r\nLogging disabled!";
				AfxMessageBox(stErr);
				return;
			}

		}

		m_LogFile.Write(pData, nDataLen); 

	}
	catch(CFileException* e)
	{			
		TCHAR buffer[512];
		e->GetErrorMessage(buffer, 512, NULL);
		CString stErr = i18n("Error while writing to the log file:");
		stErr += _T("\r\n\"");
		stErr += buffer;
		stErr += _T("\"\r\n\r\n");
		stErr += i18n("Logging disabled!");

		AfxMessageBox(stErr);

		m_bLoggingEnabled = FALSE;

		e->Delete();
	}
}

void Log(LPCTSTR szStr) 
{	
	if(szStr != NULL) {
		int len = _tcslen(szStr);
		Log(szStr, len);
	}
}

*/

CTrayIcon::CTrayIcon(UINT uID)
{
	m_fnCallback = NULL;
	m_bDelayTimer = FALSE;
	m_bIconTimer = FALSE;
	m_nIconIdx = 0;
	m_bDisposeIcon = FALSE;
	m_hTrayDLL = NULL;
	m_bDoubleClickDelay = TRUE;
	m_bEatDelayedClick = FALSE;

	CWnd::CreateEx(0, AfxRegisterWndClass(0), _T("PopManTrayIcon"), WS_POPUP, 0,0,0,0, NULL, 0);
		
	m_bBallonsEnabled = CheckBallonsEnabled();
	m_bHighColorTrayEnabled = CheckHighColorTrayEnabled();
	
	// Initialize NOTIFYICONDATA
	memset(&m_nid, 0 , sizeof(m_nid));

#ifndef  NOTIFYICONDATAA_V1_SIZE
	m_nid.cbSize = m_bBallonsEnabled ? sizeof(NOTIFYICONDATA_IE5) : sizeof(NOTIFYICONDATA);
#else
	m_nid.cbSize = m_bBallonsEnabled ? sizeof(NOTIFYICONDATA_IE5) : NOTIFYICONDATAA_V1_SIZE;
#endif

	m_nid.uID = uID;  
	m_nid.hWnd = m_hWnd;
	m_nid.uCallbackMessage = WM_MY_TRAY_NOTIFICATION;

//	Log("CONS");
//	Log(&m_nid, sizeof(m_nid));

}

CTrayIcon::~CTrayIcon()
{
//	Log("DESTRUKTOR\n\n\n\n\n\n");
//	Log(&m_nid, sizeof(m_nid));

	if(m_hWnd != NULL)
		DestroyWindow();
	
	RemoveIcon();

	UnloadTrayDLL();
}

LRESULT CTrayIcon::OnTaskBarCreated(WPARAM wp, LPARAM lp)
{
	CString stTip = m_nid.szTip;
	HICON hIcon = m_nid.hIcon;

	m_nid.hIcon = 0;

	DoSetIcon(hIcon, stTip);

	return 0;
}


BOOL CTrayIcon::SetIcon(UINT uIconID, LPCTSTR lpTip)
{ 
   HICON hIcon = NULL;
   if (uIconID)
   {
	   hIcon = (HICON)::LoadImage(AfxGetResourceHandle(), MAKEINTRESOURCE(uIconID), IMAGE_ICON, 0, 0, LR_SHARED);
   }
   return SetIcon(hIcon, lpTip, FALSE);
}


BOOL CTrayIcon::SetIcon(HICON hIcon, LPCTSTR lpTip, BOOL bDisposeIcon) 
{
	if(m_bIconTimer)
	{
		KillTimer(TIMER_ID_ICONS);
		m_bIconTimer = FALSE;
		m_nIconIdx = 0;
	}

	if(m_bDisposeIcon && m_nid.hIcon != NULL)
		::DestroyIcon(m_nid.hIcon);
	
	
	for(int n = 0; n < m_Icons.GetSize(); n++) 
	{
		if(m_Icons[n].bDestroy)
			::DestroyIcon(m_Icons[n].hIcon);
	}
	m_Icons.RemoveAll();

	m_bDisposeIcon = bDisposeIcon;

	return DoSetIcon(hIcon, lpTip);
}

BOOL CTrayIcon::DoSetIcon(HICON hIcon, LPCTSTR lpTip) 
{
	m_nid.uFlags = 0;

	if(hIcon == 0)
		return FALSE;


	UINT msg = m_nid.hIcon ? NIM_MODIFY : NIM_ADD;
	m_nid.hIcon = hIcon;
	m_nid.uFlags |= NIF_ICON;

	
	if(lpTip)  
	{
		CString stTip = lpTip;
		stTip.Replace(_T("&"), _T("&&&"));
		ZeroMemory(m_nid.szTip, sizeof(m_nid.szTip));
		_tcsncpy(m_nid.szTip, (LPCTSTR)stTip, sizeof(m_nid.szTip)/sizeof(TCHAR)-1);
		m_nid.uFlags |= NIF_TIP;
	}
     
	// Use callback if any
	if (m_nid.uCallbackMessage && m_nid.hWnd)
		m_nid.uFlags |= NIF_MESSAGE;

	BOOL bRet = Shell_NotifyIcon(msg, (NOTIFYICONDATA*)&m_nid);
	if (!bRet) {
		// hope this solves the tray icon freeze issue!
		bRet = Shell_NotifyIcon(msg == NIM_ADD ? NIM_MODIFY : NIM_ADD, (NOTIFYICONDATA*)&m_nid);
		if (!bRet) 
			m_nid.hIcon = NULL;  // failed
	}

	return bRet;
}

BOOL CTrayIcon::ShowBalloonTip(LPCTSTR szMsg, LPCTSTR szTitle, UINT uTimeout, DWORD dwInfoFlags)
{
	m_nid.uFlags = NIF_INFO;
	m_nid.uTimeout = uTimeout;
	m_nid.dwInfoFlags = dwInfoFlags;
	ZeroMemory(m_nid.szInfo, sizeof(m_nid.szInfo));
	ZeroMemory(m_nid.szInfoTitle, sizeof(m_nid.szInfoTitle));
	_tcsncpy(m_nid.szInfo, szMsg ? szMsg : _T(""), sizeof(m_nid.szInfo)/sizeof(TCHAR)-1);
	_tcsncpy(m_nid.szInfoTitle, szTitle ? szTitle : _T(""), sizeof(m_nid.szInfoTitle)/sizeof(TCHAR)-1);
	return Shell_NotifyIcon(NIM_MODIFY, (NOTIFYICONDATA*)&m_nid);
}


BOOL CTrayIcon::CheckBallonsEnabled()
{
	BOOL bEnabled = FALSE;

	HINSTANCE hInstDll = LoadLibrary(_T("Shell32.dll"));
	
	if(hInstDll)
	{
		DLLGETVERSIONPROC pDllGetVersion;
   		pDllGetVersion = (DLLGETVERSIONPROC)GetProcAddress(hInstDll, "DllGetVersion");

		if(pDllGetVersion)
		{
			DLLVERSIONINFO    dvi;
			HRESULT           hr;

			ZeroMemory(&dvi, sizeof(dvi));
			dvi.cbSize = sizeof(dvi);

			hr = (*pDllGetVersion)(&dvi);

			if(SUCCEEDED(hr))
			{
				bEnabled = (dvi.dwMajorVersion >= 5);
			}
		}
		FreeLibrary(hInstDll);
	}
	
	return bEnabled;
}


BOOL CTrayIcon::CheckHighColorTrayEnabled()
{
	/*OSVERSIONINFO os;
	os.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	::GetVersionEx(&os);
	switch(os.dwPlatformId)
	{
	case VER_PLATFORM_WIN32_NT:

		if(os.dwMajorVersion == 5 && os.dwMinorVersion >= 1)
			return TRUE;
		if(os.dwMajorVersion > 5)
			return TRUE;
		break;

	case VER_PLATFORM_WIN32_WINDOWS:
		
		if(os.dwMajorVersion == 4 && os.dwMinorVersion >= 90)
			return TRUE;
		if(os.dwMajorVersion > 4)
			return TRUE;
		break;

	}

	return FALSE;*/
	return TRUE;
}

void CTrayIcon::OnTimer(UINT nIDEvent) 
{
	CWnd::OnTimer(nIDEvent);

	switch(nIDEvent)
	{
	case TIMER_ID_DELAY:
		
		KillTimer(TIMER_ID_DELAY);
		m_bDelayTimer = FALSE;
		if(m_fnCallback != NULL && m_bDoubleClickDelay && !m_bEatDelayedClick)
		{
			CPoint point;
			::GetCursorPos(&point);
			point -= m_ptLeftClick;
			if(abs(point.x) < 14 && abs(point.y) < 14)
				m_fnCallback(WM_LBUTTONUP);
		}

		m_bEatDelayedClick = FALSE;
		break;

	case TIMER_ID_ICONS:
		
		OnNextIcon();
		break;

	case TIMER_ID_HIGHCOLORTRAY:

		KillTimer(TIMER_ID_HIGHCOLORTRAY);
		UnloadTrayDLL();
		break;
	}
}


LRESULT CTrayIcon::OnTrayNotification(WPARAM wID, LPARAM lEvent)
{
	if(wID != m_nid.uID || m_fnCallback == NULL)
		return 0;

	//if(lEvent != 512)
	//	TRACE(_T("  OnTrayNotification := %x \n"), lEvent);

	if(lEvent == WM_LBUTTONDBLCLK && m_bDelayTimer)
		m_bEatDelayedClick = TRUE;

	switch(lEvent)
	{
	case WM_LBUTTONUP:
		if(m_bDelayTimer)
		{
			KillTimer(TIMER_ID_DELAY);
			m_bDelayTimer = FALSE;
			m_bEatDelayedClick = FALSE;
			return 0;
		}

		if(SetTimer(TIMER_ID_DELAY, ::GetDoubleClickTime(), NULL))
		{
			::GetCursorPos(&m_ptLeftClick);
			m_bDelayTimer = TRUE;
			if(m_bDoubleClickDelay)
				return 0;
			/* fall through */
		}

	case WM_RBUTTONUP:
	case WM_MBUTTONUP:
	case WM_LBUTTONDBLCLK:
		m_fnCallback(lEvent);	
		return 1;
	}

	return 0;
}


void CTrayIcon::RemoveIcon()
{
	if (m_nid.hIcon == NULL)
         return;
    
	Shell_NotifyIcon(NIM_DELETE, (NOTIFYICONDATA*)&m_nid);
    m_nid.hIcon = NULL;
}


void CTrayIcon::SetIcons(const CIcons& Icons, UINT nInterval)
{
	if(m_bDisposeIcon && m_nid.hIcon != NULL) {
		::DestroyIcon(m_nid.hIcon);
		m_bDisposeIcon = FALSE;
	}

	for(int n = 0; n < m_Icons.GetSize(); n++) 
	{
		if(m_Icons[n].bDestroy)
			::DestroyIcon(m_Icons[n].hIcon);
	}

	m_Icons.RemoveAll();


	for(int i = 0; i < Icons.GetSize(); i++)
	{
		TIPICON TipIcon = Icons[i]; 
		m_Icons.Add(TipIcon);
	}

	if(m_bIconTimer)
	{
		KillTimer(TIMER_ID_ICONS);
		m_bIconTimer = FALSE;
	}

	if(m_Icons.GetSize() == 0)
		return;

	if(m_Icons.GetSize() > 1)
	{
		if(SetTimer(TIMER_ID_ICONS, nInterval, NULL))
			m_bIconTimer = TRUE;
	}

	OnNextIcon();
}

void CTrayIcon::OnNextIcon()
{
	if(m_nIconIdx >= m_Icons.GetSize()) 
		m_nIconIdx = 0;

	HICON Icon = m_Icons[m_nIconIdx].hIcon;

	DoSetIcon(Icon, m_Icons[m_nIconIdx].stTip);

	m_nIconIdx++;
}

void CTrayIcon::OnDestroy() 
{
	CWnd::OnDestroy();
	
	if(m_bIconTimer)
	{
		KillTimer(TIMER_ID_ICONS);
		m_bIconTimer = FALSE;
	}
}

BOOL CTrayIcon::EnableHighColorTray()
{
	if(m_hTrayDLL != NULL)
		return FALSE;

	m_hTrayDLL = ::LoadLibrary(_T("HighColorTray.dll"));
	
	if(m_hTrayDLL)
	{
		DLLHOOKPROC pfSetHook = (DLLHOOKPROC)::GetProcAddress(m_hTrayDLL, "setHook");

		if(pfSetHook)
		{
			pfSetHook();
			SetTimer(TIMER_ID_HIGHCOLORTRAY, 3000, NULL);
			return TRUE;
		}
		::FreeLibrary(m_hTrayDLL);
	}

	m_hTrayDLL = NULL;
	return FALSE;
}


void CTrayIcon::UnloadTrayDLL()
{
	if(m_hTrayDLL == NULL)
		return;

	DLLHOOKPROC pfRemoveHook = (DLLHOOKPROC)::GetProcAddress(m_hTrayDLL, "removeHook");

	if(pfRemoveHook)
		pfRemoveHook();

	::FreeLibrary(m_hTrayDLL);

	m_hTrayDLL = NULL;
}


LRESULT CTrayIcon::OnPopmanTrayMsg(WPARAM, LPARAM)
{
	return UWM_AM_I_TRAYICON; // Return the unique message on receiving the unique message
}