// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ToolTip.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_TOOLTIP_H_)
#define AFX_TOOLTIP_H_

#if _MSC_VER > 1000
#pragma once
#endif 



class CToolTip : public CWnd
{
public:
	CToolTip();
	virtual ~CToolTip();

public:
	BOOL Show(LPCTSTR szTip, CFont* pFont, COLORREF TextColor, POINT pos, CWnd* pParentWnd);
	void Hide();


protected:
	CString  m_stTip;
	COLORREF m_TextColor;

	CString  m_stClassName;
	CFont	 m_Font;
	POINT	 m_initialPos;

public:
	void	  SetTextColor(COLORREF TextColor);
	COLORREF  GetTextColor() const { return m_TextColor; }

	void	  SetTip(LPCTSTR szTip);
	CString   GetTip() const { return m_stTip; }

// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CToolTip)
	//}}AFX_VIRTUAL


	// Generierte Nachrichtenzuordnungsfunktionen
protected:
	CRect GetToolTipRect(POINT pos);
	//{{AFX_MSG(CToolTip)
	afx_msg void OnPaint();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};



//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ fgt unmittelbar vor der vorhergehenden Zeile zustzliche Deklarationen ein.

#endif // AFX_TOOLTIP_H_
