// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ToolTip.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "ToolTip.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



/////////////////////////////////////////////////////////////////////////////
// CToolTip

CToolTip::CToolTip()
{
	m_TextColor = ::GetSysColor(COLOR_INFOTEXT);
}

CToolTip::~CToolTip()
{
}


BEGIN_MESSAGE_MAP(CToolTip, CWnd)
	//{{AFX_MSG_MAP(CToolTip)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CToolTip::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	RECT rect;
	GetClientRect(&rect);
	dc.FillSolidRect(&rect, ::GetSysColor(COLOR_INFOBK));
	COLORREF oldColor = dc.SetTextColor(m_TextColor);
	int oldBkMode = dc.SetBkMode(TRANSPARENT);
	CFont* poldFont = dc.SelectObject(&m_Font);
	dc.DrawText(m_stTip, m_stTip.GetLength(), &rect, DT_CENTER | DT_NOPREFIX | DT_VCENTER | DT_SINGLELINE);
	dc.SelectObject(poldFont);
	dc.SetBkMode(oldBkMode);
	dc.SetTextColor(oldColor);
}

BOOL CToolTip::Show(LPCTSTR szTip, CFont* pFont, COLORREF TextColor, POINT pos, CWnd* pParentWnd)
{
	ASSERT(pFont != NULL);

	if(szTip != NULL)
		m_stTip = szTip;

	m_TextColor = TextColor;
	m_initialPos = pos;
	
	LOGFONT logFont;
	pFont->GetLogFont(&logFont);
	m_Font.DeleteObject();
	m_Font.CreateFontIndirect(&logFont);

	if (m_stClassName.IsEmpty())
		m_stClassName = AfxRegisterWndClass(CS_SAVEBITS | CS_HREDRAW | CS_VREDRAW);
	
	if(m_hWnd != NULL)
		DestroyWindow();

	BOOL bRet = CreateEx(0, m_stClassName, NULL, WS_POPUP | WS_BORDER, 0, 0, 0, 0, pParentWnd->GetSafeHwnd(), NULL, NULL);
	SetFont(&m_Font);

	CRect rect = GetToolTipRect(pos);
	::SetWindowPos(m_hWnd, HWND_TOP, rect.left, rect.top, rect.Width(), rect.Height(), SWP_SHOWWINDOW | SWP_NOACTIVATE);

	UpdateWindow();

	return bRet;
}

void CToolTip::Hide()
{
	DestroyWindow();
}

void CToolTip::SetTextColor(COLORREF TextColor)
{
	m_TextColor = TextColor;
	if(m_hWnd)
	{
		Invalidate();
		UpdateWindow();
	}
}

void CToolTip::SetTip(LPCTSTR szTip)
{
	m_stTip = szTip;
	if(m_hWnd)
	{
		CRect rect = GetToolTipRect(m_initialPos);
		::SetWindowPos(m_hWnd, HWND_TOP, rect.left, rect.top, rect.Width(), rect.Height(), SWP_SHOWWINDOW | SWP_NOACTIVATE);
		Invalidate();
		UpdateWindow();
	}
}
	


CRect CToolTip::GetToolTipRect(POINT pos)
{
	HDC hDC = ::GetDC(GetSafeHwnd());
	SIZE Size;
	HFONT oldFont = (HFONT)::SelectObject(hDC, m_Font.m_hObject);
	::GetTextExtentPoint32(hDC, m_stTip, m_stTip.GetLength(), &Size);
	::SelectObject(hDC, oldFont);
	::ReleaseDC(GetSafeHwnd(), hDC);

	Size.cx += 4;
	Size.cy += 4;

	int ScreenWidth = ::GetSystemMetrics(SM_CXSCREEN);

	if(pos.x + Size.cx > ScreenWidth)
		pos.x = ScreenWidth - Size.cx;
	
	return CRect(pos.x, pos.y, pos.x + Size.cx, pos.y + Size.cy);
}
