// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// Tokenizer.h
//
////////////////////////////////////////////////////////////////////////////////

#if !defined(TOKENIZER_H_)
#define TOKENIZER_H_

#if _MSC_VER > 1000
#pragma once
#endif 

#include "stdafx.h"


class Tokenizer {

public:

    Tokenizer( LPCTSTR szStr, 
               LPCTSTR delimiters, 
               LPCTSTR delimiters_preserve,
               const TCHAR    esc = '\\',
               const TCHAR    comment = 0 ) : 
          m_pszStr(szStr),
          m_Delimiters(delimiters),
          m_Delimiters_preserve(delimiters_preserve),
          m_Esc(esc),
          m_Comment(comment),
          m_IsDoubleQuoted(false), m_IsSingleQuoted(false),
          m_State(stPlain), m_IsEscaped(false), m_Pos(0) 
    {
        if(szStr) 
            m_strLength = _tcslen(szStr);
        else
            m_strLength = 0;
    }

    bool ReadNext();

    CString Token()          const { return m_Token; }
    bool    IsDoubleQuoted() const { return m_IsDoubleQuoted; }
    bool    IsSingleQuoted() const { return m_IsSingleQuoted; }

private:
    
    enum STATE {
        stPlain = 0,
        stDoubleQuoted,
        stSingleQuoted,
        stComment
    };

    enum QUOTED {
        NotQuoted = 0,
        DoubleQuoted,
        SingleQuoted
    };

    //const CString& m_Str;
    LPCTSTR        m_pszStr;
    int            m_strLength;

    const CString  m_Delimiters;
    const CString  m_Delimiters_preserve;
    const TCHAR    m_Esc;
    const TCHAR    m_Comment;

    CString m_Token;		  // string buffer for the token
    CString m_NextToken;
    bool    m_IsDoubleQuoted;
    bool    m_IsSingleQuoted;

    STATE   m_State;
    bool    m_IsEscaped;
    int     m_Pos;
};


#endif // TOKENIZER_H_