// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// SyncTlsSocket.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_SYNCTLSSOCKET_H_)
#define AFX_SYNCTLSSOCKET_H_

#if _MSC_VER > 1000
#pragma once
#endif 

#include "SyncSocket.h"
#include "TLS\SSLClient.h"
#include "UniquePtr.h"

class CSyncTlsSocket
{
public:	

	~CSyncTlsSocket();
	CSyncTlsSocket() : m_bUseTLS(true) { }

	BOOL Create() { return m_Socket.Create(); };

	BOOL Connect(LPCTSTR lpszHostAddress, UINT nHostPort);
	// BOOL Connect(const SOCKADDR* lpSockAddr, int nSockAddrLen);
	void Close();
	
	BOOL ReceiveStr(CString& stBuf, DWORD nHowManyChars);
	BOOL SendStr(const CString& stSend);
	int  Receive(void* lpBuf, int nBufLen, int nFlags = 0);
	int  Send(const void* lpBuf, int nBufLen, int nFlags = 0);
	void Cancel();

	void SetUseTLS(bool useTLS) {
		m_bUseTLS = useTLS;
	}
	
	void SetTimeOut(UINT nTimeOutVal) {
		m_Socket.SetTimeOut(nTimeOutVal);
	}

	UINT GetTimeOut() const { return m_Socket.GetTimeOut(); }

	CString& GetLastReceived() {
		return m_Socket.GetLastReceived();
	}

	void SetEventSink(CSyncSocket::EventSink* sink) {
		m_pEventSink = sink;
	}

	BOOL IsTimedOut()  const { return m_Socket.IsTimedOut(); }
	BOOL IsCanceled()  const { return m_Socket.IsCanceled(); }
	BOOL IsConnected() const { return m_Socket.IsConnected(); }
	BOOL IsBlocking()  const { return m_Socket.IsBlocking(); }

private:
	CSyncSocket::EventSink* m_pEventSink;
	bool m_bUseTLS;
	CSyncSocket m_Socket;
	UniquePtr<CSSLClient> m_pTLS;
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}

#endif // AFX_SYNCTLSSOCKET_H_
