// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// SyncSocket.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_SYNCSOCKET_H_)
#define AFX_SYNCSOCKET_H_

#if _MSC_VER > 1000
#pragma once
#endif 


class CSyncSocket : public CSocket
{
public:
	CSyncSocket();
	virtual ~CSyncSocket();

	BOOL Connect(LPCTSTR lpszHostAddress, UINT nHostPort);
	// BOOL Connect(const SOCKADDR* lpSockAddr, int nSockAddrLen);
	void Close();
	
	BOOL ReceiveStr(CString& stBuf, DWORD nHowManyChars);
	BOOL SendStr(const CString& stSend);
	int  Receive(void* lpBuf, int nBufLen, int nFlags = 0);
	int  Send(const void* lpBuf, int nBufLen, int nFlags = 0);
	void Cancel();

	void SetTimeOut(UINT nTimeOutVal) {
		m_nTimeOut = nTimeOutVal;
	}

	UINT GetTimeOut() const { return m_nTimeOut; }
	
	CString& GetLastReceived() {
		return m_stLastReceived;
	}

	BOOL IsTimedOut()  const { return m_bTimedOut;  }
	BOOL IsCanceled()  const { return m_bCanceled;  }
	BOOL IsConnected() const { return m_bConnected; }
	BOOL IsBlocking()  const { return m_bBlocking;  }

public:

	class EventSink {
	public: 
		virtual void OnReceivedData(const void* pData, int nDataLen) = 0;
		virtual void OnSentData(const void* pData, int nDataLen) = 0;
	};

	void SetEventSink(EventSink* sink) {
		m_pEventSink = sink;
	}

protected:

	virtual void OnReceivedData(const void* pData, int nDataLen) {
		if(m_pEventSink) m_pEventSink->OnReceivedData(pData, nDataLen);
	}

	virtual void OnSentData(const void* pData, int nDataLen) {
		if(m_pEventSink) m_pEventSink->OnSentData(pData, nDataLen);
	}	

private:

	EventSink* m_pEventSink;
	UINT	m_nTimeOutVal;  // in secs
	CString m_stLastReceived;

	BOOL	m_bConnected;
	BOOL	m_bTimedOut;
	BOOL	m_bCanceled;
	BOOL	m_bBlocking;
	UINT	m_nEllapse;

	void BeginBlocking();
	void EndBlocking();


	static void CALLBACK TimerProc(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime);
	static UINT nTimerID;
	static UINT nInstances;


public:
	//{{AFX_VIRTUAL(CSyncSocket)
	public:
	virtual BOOL OnMessagePending();
	virtual void OnClose(int nErrorCode);
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CSyncSocket)
	//}}AFX_MSG
};



template<class SINK>
class CSyncSocketEventSink : public CSyncSocket::EventSink  {
public:

	typedef void (SINK::*FnData)(const void* pData, int nDataLen);

	CSyncSocketEventSink(SINK* sink, FnData ReceivedData, FnData SentData) : 
	  m_Sink(sink), fnReceivedData(ReceivedData), fnSentData(SentData) {}

	FnData fnReceivedData;
	FnData fnSentData;

private:

	SINK* m_Sink;

	virtual void OnReceivedData(const void* pData, int nDataLen) {
		if(m_Sink && fnReceivedData) (m_Sink->*fnReceivedData)(pData, nDataLen); 
	}
	virtual void OnSentData(const void* pData, int nDataLen) {
		if(m_Sink && fnSentData) (m_Sink->*fnSentData)(pData, nDataLen);		
	}
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}

#endif // AFX_SYNCSOCKET_H_
