// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// SyncSocket.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "SyncSocket.h"
#include <malloc.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSyncSocket

UINT CSyncSocket::nTimerID    = 0;
UINT CSyncSocket::nInstances  = 0;


CSyncSocket::CSyncSocket()
{
	m_pEventSink = NULL;

	m_bBlocking = FALSE;
	m_bConnected = FALSE;

	m_nEllapse  = 0;
	m_nTimeOutVal = 30;

	if(nInstances == 0)
		nTimerID = ::SetTimer(0, 46552, 2000, TimerProc);

	nInstances++;

}


CSyncSocket::~CSyncSocket()
{
	if(m_pEventSink)
		delete m_pEventSink;

	nInstances--;

	if(nInstances == 0)
		::KillTimer(0, nTimerID);
}


void CSyncSocket::Cancel()
{
	m_bCanceled = TRUE;
	CancelBlockingCall();
	Close();
}


void CSyncSocket::BeginBlocking()
{
	m_bBlocking = TRUE;
	m_bTimedOut = FALSE;
	m_bCanceled = FALSE;

	if(m_nTimeOutVal == 0)
		m_nEllapse = 0;
	else
		m_nEllapse = GetTickCount() + m_nTimeOutVal * 1000;
}

void CSyncSocket::EndBlocking()
{
	m_bBlocking = FALSE;
	m_nEllapse = 0;
}


void CSyncSocket::TimerProc(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime)
{
}


BOOL CSyncSocket::OnMessagePending() 
{
	if(m_nEllapse != 0 && m_nEllapse < GetTickCount())
	{
		m_nEllapse = 0;
		if(CSocket::IsBlocking())
		{
			m_bTimedOut = TRUE;
			CancelBlockingCall();
			Close();
		}
	}                                

	MSG msg;
    while(::PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE)) 
    { 
		AfxGetApp()->OnIdle(0);
        if(!AfxGetApp()->PumpMessage()) 
        { 
			AfxPostQuitMessage(0); 
			return TRUE; 
        } 
    } 	
	return CSocket::OnMessagePending();
}


BOOL CSyncSocket::Connect(LPCTSTR lpszHostAddress, UINT nHostPort)
{
	BOOL ret;

	if(IsBlocking())
	{
		::WSASetLastError(WSAEINPROGRESS);
		return FALSE;
	}

	BeginBlocking();
	OnMessagePending();
	m_bConnected = ret = CSocket::Connect(lpszHostAddress, nHostPort);
	OnMessagePending();
	EndBlocking();
	return ret;
}
/*
BOOL CSyncSocket::Connect(const SOCKADDR* lpSockAddr, int nSockAddrLen)
{
	BOOL ret;
	
	if(IsBlocking())
	{
		::WSASetLastError(WSAEINPROGRESS);
		return FALSE;
	}
	
	BeginBlocking();
	OnMessagePending();
	m_bConnected = ret = CSocket::Connect(lpSockAddr, nSockAddrLen);
	OnMessagePending();
	EndBlocking();
	return ret;
}
*/
void CSyncSocket::Close()
{
	CSocket::Close();
	m_bConnected = FALSE;
}

int CSyncSocket::Receive(void* lpBuf, int nBufLen, int nFlags)
{
	BeginBlocking();
	int ret = CSocket::Receive(lpBuf, nBufLen, nFlags);
	EndBlocking();

	if(ret > 0)
		OnReceivedData(lpBuf, ret);
	
	return ret;
}

int CSyncSocket::Send(const void* lpBuf, int nBufLen, int nFlags )
{
	BeginBlocking();
	int ret = CSocket::Send(lpBuf, nBufLen, nFlags);
	EndBlocking();

	if(ret > 0)
		OnSentData(lpBuf, nBufLen);

	return ret;
}

void CSyncSocket::OnClose(int nErrorCode) 
{
	m_bConnected = FALSE;	
	CSocket::OnClose(nErrorCode);
}



BOOL CSyncSocket::ReceiveStr(CString& stBuf, DWORD nHowManyChars)
{
	if(nHowManyChars == 0)
		return FALSE;

#ifndef _UNICODE

	char* pBuf = stBuf.GetBuffer(nHowManyChars+1);

	int iBytesReceived = Receive(pBuf, nHowManyChars);
	
	if(iBytesReceived <= 0)
	{
		stBuf.ReleaseBuffer(0);	
		return FALSE;
	}

	stBuf.ReleaseBuffer(iBytesReceived);
	return TRUE;

#else

	char* pBuf = (char*)alloca(nHowManyChars);

	int iBytesReceived = Receive(pBuf, nHowManyChars);
	
	if(iBytesReceived <= 0)
		return FALSE;
	
	WCHAR* pwBuf = stBuf.GetBuffer(iBytesReceived+1);
	//MultiByteToWideChar(CP_ACP, 0, pBuf, iBytesReceived, pwBuf, iBytesReceived);
	for(int n = 0; n < iBytesReceived; ++n)
		pwBuf[n] = (WCHAR)(unsigned char)pBuf[n];

	stBuf.ReleaseBuffer(iBytesReceived);
	return TRUE;

#endif
	
}

BOOL CSyncSocket::SendStr(const CString &stSend)
{
	if(stSend.IsEmpty())
		return FALSE;

#ifndef _UNICODE
	
	return (SOCKET_ERROR != Send(stSend, stSend.GetLength()));

#else

	int nBufLen = stSend.GetLength();
	char* szBuf = (char*)alloca(nBufLen);
	//WideCharToMultiByte(CP_ACP, 0, (LPCWSTR)stSend, nBufLen, szBuf, nBufLen, NULL, NULL);
	for(int n = 0; n < nBufLen; ++n)
		szBuf[n] = (char)(stSend[n] & 0xFF);
	
	return (SOCKET_ERROR != Send(szBuf, nBufLen));
	
#endif

}

#if 0
BEGIN_MESSAGE_MAP(CSyncSocket, CSocket)
	//{{AFX_MSG_MAP(CSyncSocket)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#endif	// 0

