// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// StrFunctions.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_STRFUNCTIONS_H_)
#define AFX_STRFUNCTIONS_H_

#if _MSC_VER > 1000
#pragma once
#endif 

 int FindInStrArray(CStringArray& StrArray, const CString& stFind, int nPos = 0);

 CString ConvertLineBreaks(const CString& stSrc);
 CString Parse(CString& Src, LPCTSTR St);
 CString ParseNoCase(CString& Src, CString St);
 CString ParseReverse(CString& Src, LPCTSTR St);
 CString ParseConst(const CString& Src, LPCTSTR St, int& nStartPos);
 int     FindNoCase(LPCTSTR szSrc, LPCTSTR szFind, int nStart = 0);
 CString QPDecode(LPCTSTR szData, BOOL bReplaceUnderscoreWithSpace = FALSE);
 CString QPDecode2(LPCTSTR szData, BOOL bReplaceUnderscoreWithSpace = FALSE);
 CString Base64Encode(const CString& Src);
 CString Base64Encode(const unsigned char * pData, size_t len);
 CString Base64Decode(const CString& Src);
 int     mimedecode(const CString& Src);
 
 int AdvancedSearch(BOOL bSearchDown, LPCTSTR szString, LPCTSTR szSearch, int iStartPos, BOOL bMatchCase = TRUE, BOOL bWholeWord = FALSE);
 CString Crypt(CString stData, BOOL bEncode = TRUE);

 TCHAR lcase(TCHAR c);
 BOOL SplitExeCmdParam(LPCTSTR szPath, CString& stExe, CString& stCmdParam);

 void ConvertEncodedText(CString& text, CString strContainingEncoding);
 //BOOL DecodeUTF8(LPCTSTR szSrc, CString& stDest);
 CString DecodeUTF8(LPCTSTR szSrc);

 CString StrFormat(LPCTSTR szFormat, ...);

 bool IsWordBoundary(const CString& str, int idx);

#endif // AFX_STRFUNCTIONS_H_