////////////////////////////////////////////////////////////////// 
// CStaticLink 1997 Microsoft Systems Journal. 
// If this program works, it was written by Paul DiLascia.
// If not, I don't know who wrote it.
// CStaticLink implements a static control that's a hyperlink
// to any file on your desktop or web. You can use it in dialog boxes
// to create hyperlinks to web sites. When clicked, opens the file/URL
//
// 

#include "StdAfx.h"
#include "StaticLink.h"
#include "PopMan.h"	// we need this for "CPopManApp::GetCursor(IDC_HOVER_LINK)"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNAMIC(CStaticLink, CStatic)

BEGIN_MESSAGE_MAP(CStaticLink, CStatic)
    ON_WM_CTLCOLOR_REFLECT()
    ON_CONTROL_REFLECT(STN_CLICKED, OnClicked)
	//{{AFX_MSG_MAP(CStaticLink)
	ON_WM_SETCURSOR()
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_SETTEXT, OnSetText)
END_MESSAGE_MAP()


CStaticLink::CStaticLink()
{
    m_colorUnvisited = RGB(0,0,255);       // blue
    m_colorVisited   = RGB(128,0,128);     // purple
    m_bVisited       = FALSE;              // not visited yet
}


LRESULT CStaticLink::OnSetText(WPARAM wParam, LPARAM lParam)
{
	LRESULT res = DefWindowProc(WM_SETTEXT, wParam, lParam);

	CWnd* pWnd = GetParent();
	if(pWnd) 
	{
		RECT rect;
		GetWindowRect(&rect);
		pWnd->ScreenToClient(&rect);
		pWnd->InvalidateRect(&rect);
		pWnd->UpdateWindow();
	}

	return res;
}
//////////////////// Handle reflected WM_CTLCOLOR to set custom control color.
// For a text control, use visited/unvisited colors and underline font.
// For non-text controls, do nothing. Also ensures SS_NOTIFY is on.
//
HBRUSH CStaticLink::CtlColor(CDC* pDC, UINT nCtlColor)
{
    ASSERT(nCtlColor == CTLCOLOR_STATIC);
    DWORD dwStyle = GetStyle();
    if (!(dwStyle & SS_NOTIFY)) {
        // Turn on notify flag to get mouse messages and STN_CLICKED.
        // Otherwise, I'll never get any mouse clicks!
        ::SetWindowLong(m_hWnd, GWL_STYLE, dwStyle | SS_NOTIFY);
    }
    
    HBRUSH hbr = NULL;
    if (((dwStyle & 0xFF) & ~SS_NOPREFIX) <= SS_RIGHT) {

        // this is a text control: set up font and colors
        if (!(HFONT)m_Font) {
            // first time init: create font
            LOGFONT lf;
            GetFont()->GetObject(sizeof(lf), &lf);
            lf.lfUnderline = TRUE;
            m_Font.CreateFontIndirect(&lf);
        }

        // use underline font and visited/unvisited colors
        pDC->SelectObject(&m_Font);
        pDC->SetTextColor(m_bVisited ? m_colorVisited : m_colorUnvisited);
        pDC->SetBkMode(TRANSPARENT);

	    // return hollow brush to preserve parent background color
      	hbr = (HBRUSH)GetStockObject(NULL_BRUSH);
    }
    return hbr;
}


void CStaticLink::OnClicked()
{
	CString stText;
	GetWindowText(stText);

    if (m_stLink.IsEmpty())         // if URL/filename not set..
        m_stLink = stText;			// ..get it from window text

	
	int nWidth = GetTextWidth(stText);

	POINT pos;
	::GetCursorPos(&pos);
	ScreenToClient(&pos);

	if(pos.x > nWidth)
		return;	
	

    // Call ShellExecute to run the file.
    // For an URL, this means opening it in the browser.
    //
    HINSTANCE h = ShellExecute(NULL, _T("open"), m_stLink, NULL, NULL, SW_SHOWNORMAL);
    if ((UINT)h > 32) {
        m_bVisited = TRUE;       // (not really--might not have found link)
        Invalidate();            // repaint to show visited color
    } else {
        MessageBeep(0);          // unable to execute file!
        TRACE(_T("*** WARNING: CStaticLink: unable to execute file %s\n"),
              (LPCTSTR)m_stLink);
    }
}

BOOL CStaticLink::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	CString stText;
	GetWindowText(stText);
	int nWidth = GetTextWidth(stText);

	POINT pos;
	::GetCursorPos(&pos);
	ScreenToClient(&pos);

	if(pos.x <= nWidth)
		//::SetCursor(::LoadCursor(::GetModuleHandle(NULL), MAKEINTRESOURCE(IDC_HOVER_LINK)));
		::SetCursor(CPopManApp::GetCursor(IDC_HOVER_LINK));
	else
		::SetCursor(::LoadCursor(NULL, IDC_ARROW));

	return TRUE;
}

int CStaticLink::GetTextWidth(LPCTSTR szText)
{
	if(szText == NULL)
		return 0;

	HDC screenDC = ::GetDC(0);
	HDC hDC = ::CreateCompatibleDC(screenDC);
	::ReleaseDC(0, screenDC);

	HFONT oldFont = (HFONT)::SelectObject(hDC, m_Font.m_hObject);
	
	int nWidth = LOWORD(::GetTabbedTextExtent(hDC, szText, _tcslen(szText), 0, NULL)); 

	::SelectObject(hDC, oldFont);
	::DeleteDC(hDC);

	return nWidth;
}
