// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// SortedHeaderCtrl.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_SORTEDHEADERCTRL_H_)
#define AFX_SORTEDHEADERCTRL_H_

#if _MSC_VER > 1000
#pragma once
#endif 

#include <afxtempl.h>


class CSortedHeaderCtrl : public CHeaderCtrl
{
public:
	CSortedHeaderCtrl();

protected:
	int	  m_nSortCol;
	BOOL  m_bSortAsc;
	
//	void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);

public:
	//{{AFX_VIRTUAL(CSortedHeaderCtrl)
	//}}AFX_VIRTUAL

public:
	void SetColumnIcon(int nCol, HICON hIcon);
	void RemoveColumnIcon(int nColn);
	int  SetSortColumn(int nCol, BOOL bAsc);
	void SetSortIcons(HICON hAsc, HICON hDesc);

	virtual ~CSortedHeaderCtrl();

protected:	
	//{{AFX_MSG(CSortedHeaderCtrl)
	//}}AFX_MSG
	afx_msg void OnCustomDraw(NMHDR* pNMHDR, LRESULT* pResult);

	CImageList m_SortImg;
	BOOL	   m_bImgListSet;

	CMap<int, int, HICON, HICON> m_IconMap;

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}

#endif // AFX_SORTEDHEADERCTRL_H_
