// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// SortedHeaderCtrl.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "SortedHeaderCtrl.h"
#include "resource.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSortedHeaderCtrl

CSortedHeaderCtrl::CSortedHeaderCtrl()
{
	m_nSortCol = -1;

	m_SortImg.Create(8, 8, ILC_MASK, 3, 3);

	m_bImgListSet = FALSE;
}


void CSortedHeaderCtrl::SetSortIcons(HICON hAsc, HICON hDesc)
{
	m_SortImg.SetImageCount(2);
	m_SortImg.Replace(0, hAsc);
	m_SortImg.Replace(1, hDesc);
	m_SortImg.SetBkColor(CLR_NONE);
}


CSortedHeaderCtrl::~CSortedHeaderCtrl()
{
}


BEGIN_MESSAGE_MAP(CSortedHeaderCtrl, CHeaderCtrl)
	//{{AFX_MSG_MAP(CSortedHeaderCtrl)
	//}}AFX_MSG_MAP
	ON_NOTIFY_REFLECT(NM_CUSTOMDRAW, OnCustomDraw)
END_MESSAGE_MAP()


int CSortedHeaderCtrl::SetSortColumn(int nCol, BOOL bAsc)
{		
	if(!m_bImgListSet)
		SetImageList(&m_SortImg);

	m_bImgListSet = TRUE;


	int nPrevCol = m_nSortCol;

	
	if(m_nSortCol > -1)
	{
		HDITEM HeaderItem; 
		HeaderItem.mask = HDI_FORMAT; 
		GetItem(m_nSortCol, &HeaderItem); 
		HeaderItem.fmt &= ~(HDF_BITMAP_ON_RIGHT | HDF_IMAGE); 
		SetItem(m_nSortCol, &HeaderItem); 
	}

	m_nSortCol = nCol;
	
	HICON hIcon = NULL;
	if(!m_IconMap.Lookup(m_nSortCol, hIcon) && m_SortImg.GetImageCount() > 0)
	{
		HDITEM HeaderItem; 
		HeaderItem.mask = HDI_IMAGE | HDI_FORMAT; 
		GetItem(m_nSortCol, &HeaderItem); 
		HeaderItem.fmt |= HDF_BITMAP_ON_RIGHT |  HDF_IMAGE; 
		HeaderItem.iImage = bAsc ? 0 : 1; 
		SetItem(m_nSortCol, &HeaderItem); 
	}
	return nPrevCol;

}


void CSortedHeaderCtrl::SetColumnIcon(int nCol, HICON hIcon)
{
	m_IconMap.SetAt(nCol, hIcon);
	if(m_hWnd) Invalidate();
}

void CSortedHeaderCtrl::RemoveColumnIcon(int nCol)
{
	m_IconMap.RemoveKey(nCol);
	Invalidate();
}


void CSortedHeaderCtrl::OnCustomDraw(NMHDR* pNMHDR, LRESULT* pResult)
{
	LPNMCUSTOMDRAW lpcd = (LPNMCUSTOMDRAW)pNMHDR;

	switch(lpcd->dwDrawStage)
	{
	case CDDS_PREPAINT:
		*pResult = CDRF_NOTIFYITEMDRAW;  // ask for item notifications.
		break;

	case CDDS_ITEMPREPAINT:
	{
		*pResult = CDRF_NOTIFYPOSTPAINT;
		break;
	}
	case CDDS_ITEMPOSTPAINT:
	{
		*pResult = CDRF_DODEFAULT;
		int nItem = (int)lpcd->dwItemSpec;

		CRect rcLabel(lpcd->rc);

		if(lpcd->uItemState & CDIS_SELECTED)
		{
			rcLabel.left++;
			rcLabel.top += 2;
			rcLabel.right++;
		}

		const int IconSize = 16;
		HICON hIcon = NULL;
		if(m_IconMap.Lookup(nItem, hIcon))
		{
			int x = rcLabel.left + (rcLabel.Width() - IconSize) / 2;
			int y = rcLabel.top + (rcLabel.Height() - IconSize) / 2;

			::DrawIconEx(lpcd->hdc, x, y, hIcon, IconSize, IconSize, 0, 0, DI_NORMAL);
		}
	
		break;
	}
	default:
		*pResult = CDRF_DODEFAULT;
	}
}

