// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// Settings.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_SETTINGS_H_)
#define AFX_SETTINGS_H_

#if _MSC_VER > 1000
#pragma once
#endif 

#include <afxtempl.h>
#include "RegKey.h"


class CFileKey
{
public:	
	
	CFileKey(LPCTSTR szName) : m_stName(szName) {}
	virtual ~CFileKey()
	{
		Reset();
	}

	void Reset()
	{
		m_stName.Empty();
		m_Values.RemoveAll();

		POSITION pos = m_SubKeys.GetHeadPosition();
		while(pos != NULL)
			delete m_SubKeys.GetNext(pos);

		m_SubKeys.RemoveAll();
	}

	CString					     m_stName;
	CList<CFileKey*, CFileKey*>  m_SubKeys;
	CMapStringToString		     m_Values;

};


class CSettingsKey
{
public:
	CSettingsKey();
	virtual ~CSettingsKey();

	BOOL Close();

	BOOL OpenSubKey(LPCTSTR szSubKey);
	BOOL CreateSubKey(LPCTSTR szSubKey);
	BOOL OpenSubKey(LPCTSTR szSubKey, CSettingsKey& SubKey);
	BOOL CreateSubKey(LPCTSTR szSubKey, CSettingsKey& SubKey);

	BOOL DeleteSubKey(LPCTSTR szSubKey);
	BOOL DeleteValue(LPCTSTR szValueName);

	BOOL QueryValue(LPCTSTR szValueName, CString& stValue) const; 
	BOOL QueryValue(LPCTSTR szValueName, DWORD&   dwValue) const;
	BOOL QueryValue(LPCTSTR szValueName, UINT&    nValue)  const;
	BOOL QueryValue(LPCTSTR szValueName, int&     nValue)  const;
    BOOL QueryValue(LPCTSTR szValueName, bool&    bValue)  const;
	BOOL QueryValue(LPCTSTR szValueName, long&    lValue)  const;

	BOOL SetValue(LPCTSTR szValueName, const CString& stValue); 

	BOOL SetValue(LPCTSTR szValueName, DWORD	dwValue);
	BOOL SetValue(LPCTSTR szValueName, UINT		nValue);
	BOOL SetValue(LPCTSTR szValueName, int		nValue);
    BOOL SetValue(LPCTSTR szValueName, bool		bValue);
	BOOL SetValue(LPCTSTR szValueName, long		lValue);
	

	BOOL EnumKey(DWORD dwIndex, CString& stName);
	BOOL EnumValue(DWORD dwIndex, CString& stName);

	int	CountSubKeys();

	friend class CSettings;

protected:	
	BOOL		m_bOpen;
	BOOL		m_bRegistry;

	CRegistryKey		m_RegKey;
	CFileKey*	m_pFileKey;

	static CFileKey* GetSubKeyByName(CFileKey* pFileKey, LPCTSTR szName, BOOL bCreate = FALSE, CFileKey** pParentKey = NULL);
};



class CSettings
{
public:
	CSettings();  
	~CSettings();

	BOOL InitRegistry(LPCTSTR szRootKey);
	BOOL InitIniFile(LPCTSTR szFileName);

	BOOL Flush();
	BOOL Close();

	BOOL GetRootKey(CSettingsKey& Key);
	BOOL OpenSubKey(CSettingsKey& Key, LPCTSTR szSubKey);
	BOOL CreateSubKey(CSettingsKey& Key, LPCTSTR szSubKey);

protected:
	
	BOOL		m_bOpen;
	BOOL		m_bRegistry;
	CString		m_stRootKey;
	CString		m_stIniFile;

	CFileKey	m_RootKey;

	BOOL ReadIniFile(LPCTSTR szFileName);
	BOOL SaveIniFile(LPCTSTR szFileName);

	static void NormalizeKey(CFileKey* pFileKey);
	static void SaveKey(CFileKey* pKey, CString& stOut, LPCTSTR szParentTree);
};


#endif // !defined(AFX_SETTINGS_H_)
