// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// RegKey.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_REGKEY_H_)
#define AFX_REGKEY_H_

#if _MSC_VER > 1000
#pragma once
#endif 


class CRegistryKey  
{
public:
	CRegistryKey();
	virtual ~CRegistryKey();
	
	BOOL Create (HKEY hKey, LPCTSTR szSubKey);
	BOOL Open   (HKEY hKey, LPCTSTR szSubKey, REGSAM samDesired = KEY_ALL_ACCESS);
	BOOL Close();
	
	BOOL QueryValue(LPCTSTR szValueName, CString& stValue) const; 
	BOOL QueryValue(LPCTSTR szValueName, DWORD&   dwValue) const;
	BOOL QueryValue(LPCTSTR szValueName, UINT&    nValue) const;
	BOOL QueryValue(LPCTSTR szValueName, int&     nValue) const;
	BOOL QueryValue(LPCTSTR szValueName, long&    lValue) const;

	BOOL QueryValueType(LPCTSTR szValueName, DWORD& dwType) const;

	BOOL SetValue(LPCTSTR szValueName, const CString& stValue); 
	BOOL SetValue(LPCTSTR szValueName, DWORD          dwValue);

	BOOL EnumKey(DWORD dwIndex, CString& stName);
	BOOL EnumValue(DWORD dwIndex, CString& stName);
	
	BOOL CountSubKeys(DWORD& nNum);

	BOOL DeleteValue(LPCTSTR szValueName);
	BOOL DeleteSubKey(LPCTSTR szSubKey);
	BOOL RecurseDeleteKey(LPCTSTR szSubKey);

	operator HKEY() const
	{ return m_hKey; }

protected:
	HKEY m_hKey;

};

#endif // !defined(AFX_REGKEY_H_)
