// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// RegKey.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "RegKey.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

CRegistryKey::CRegistryKey()
{
	m_hKey = 0;
}

CRegistryKey::~CRegistryKey()
{
	Close();
}


BOOL CRegistryKey::Create(HKEY hKeyParent, LPCTSTR szSubKey)
{
	HKEY hKey = NULL;
	BOOL bRes = (ERROR_SUCCESS == ::RegCreateKey(hKeyParent, szSubKey, &hKey));
	if(bRes)
	{
		bRes = Close();
		m_hKey = hKey;
	}
	return bRes;
}


BOOL CRegistryKey::Open(HKEY hKeyParent, LPCTSTR szSubKey, REGSAM samDesired)
{
	HKEY hKey = NULL;
	BOOL bRes = (ERROR_SUCCESS == ::RegOpenKeyEx(hKeyParent, szSubKey, 0, samDesired, &hKey));
	if(bRes)
	{
		bRes = Close();
		m_hKey = hKey;
	}
	return bRes;
}


BOOL CRegistryKey::Close()
{
	if(m_hKey == 0)
		return TRUE;
	
	BOOL bRes = (ERROR_SUCCESS == ::RegCloseKey(m_hKey));
	m_hKey = 0;
	
	return bRes;
}


BOOL CRegistryKey::QueryValue(LPCTSTR szValueName, CString& stValue) const
{
	if(m_hKey == 0)
		return FALSE;

	TCHAR Buf[300] = _T("");
	DWORD dwDatasize = sizeof(Buf);
			
	if(ERROR_SUCCESS != ::RegQueryValueEx(m_hKey, szValueName, NULL, 0, (BYTE*)Buf, &dwDatasize))
		return FALSE;
	
	stValue = Buf;

	return TRUE;
}

BOOL CRegistryKey::QueryValue(LPCTSTR szValueName, DWORD& dwValue) const
{
	if(m_hKey == 0)
		return FALSE;

	DWORD dwDatasize = sizeof(dwValue);
			
	return (ERROR_SUCCESS == ::RegQueryValueEx(m_hKey, szValueName, NULL, 0, (BYTE*)&dwValue, &dwDatasize));
}

BOOL CRegistryKey::QueryValue(LPCTSTR szValueName, UINT& nValue) const
{
	DWORD dwValue = 0;
	if(!QueryValue(szValueName, dwValue))
		return FALSE;
	nValue = dwValue;
	return TRUE;
}

BOOL CRegistryKey::QueryValue(LPCTSTR szValueName, int& nValue) const
{
	DWORD dwValue = 0;
	if(!QueryValue(szValueName, dwValue))
		return FALSE;
	nValue = dwValue;
	return TRUE;
}

BOOL CRegistryKey::QueryValue(LPCTSTR szValueName, long& lValue) const
{
	DWORD dwValue = 0;
	if(!QueryValue(szValueName, dwValue))
		return FALSE;
	lValue = dwValue;
	return TRUE;
}

BOOL CRegistryKey::QueryValueType(LPCTSTR szValueName, DWORD& dwType) const
{
	if(m_hKey == 0)
		return FALSE;

	return (ERROR_SUCCESS == ::RegQueryValueEx(m_hKey, szValueName, NULL, &dwType, NULL, NULL));
}


BOOL CRegistryKey::SetValue(LPCTSTR szValueName, const CString& stValue)
{
	if(m_hKey == 0)
		return FALSE;

	LPCTSTR szData = stValue;

	return (ERROR_SUCCESS == ::RegSetValueEx(m_hKey, szValueName, 0, REG_SZ, (CONST BYTE*)szData, (lstrlen(szData)+1)*sizeof(TCHAR)));
}

BOOL CRegistryKey::SetValue(LPCTSTR szValueName, DWORD dwValue)
{
	if(m_hKey == 0)
		return FALSE;

	return (ERROR_SUCCESS == ::RegSetValueEx(m_hKey, szValueName, 0, REG_DWORD, (CONST BYTE*)&dwValue, sizeof(dwValue)));
}

BOOL CRegistryKey::EnumKey(DWORD dwIndex, CString& stName)
{
	if(m_hKey == 0)
		return FALSE;
	
	TCHAR szBuf[MAX_PATH+1] = _T("");
	DWORD dwCount = MAX_PATH;

	LONG res = ::RegEnumKeyEx(m_hKey, dwIndex, szBuf, &dwCount, 0, NULL, NULL, NULL);

	stName = szBuf;
	return (res == ERROR_SUCCESS);
}

BOOL CRegistryKey::EnumValue(DWORD dwIndex, CString &stName)
{
	if(m_hKey == 0)
		return FALSE;
	
	TCHAR szBuf[MAX_PATH+1] = _T("");
	DWORD dwCount = MAX_PATH;

	LONG res = ::RegEnumValue(m_hKey, dwIndex, szBuf, &dwCount, 0, NULL, NULL, NULL);

	stName = szBuf;
	return (res == ERROR_SUCCESS);
}

BOOL CRegistryKey::DeleteValue(LPCTSTR szValueName)
{
	if(m_hKey == 0)
		return FALSE;

	return (ERROR_SUCCESS == ::RegDeleteValue(m_hKey, szValueName));
}


BOOL CRegistryKey::DeleteSubKey(LPCTSTR szSubKey)
{
	if(m_hKey == 0)
		return FALSE;
	
	return (ERROR_SUCCESS == ::RegDeleteKey(m_hKey, szSubKey));
}

BOOL CRegistryKey::RecurseDeleteKey(LPCTSTR szSubKey)
{
	CRegistryKey Key;
	if(!Key.Open(m_hKey, szSubKey, KEY_READ | KEY_WRITE))
		return FALSE;

	CString stName;
	while(Key.EnumKey(0, stName))
	{
		if(!Key.RecurseDeleteKey(stName))
			return FALSE;
	}
	Key.Close();
	return DeleteSubKey(szSubKey);
}

BOOL CRegistryKey::CountSubKeys(DWORD& dwNum)
{
	if(m_hKey == 0)
		return FALSE;

	return (ERROR_SUCCESS == ::RegQueryInfoKey(m_hKey, 0, 0, 0, &dwNum, 0, 0, 0, 0, 0, 0, 0));
}