#include "stdafx.h"
#include "PrintMail.h"
#include "StrFunctions.h"
#include "Mail.h"
#include <Winspool.h>

void DoPrintMessage(HDC hDC, CString stHeader, CString stText, RECT& Rect, HFONT hFontHead, HFONT hFontBody);

void OnPrintMail(CMail* pMail, BOOL showDialog, CFont * pFont, CWnd* pParentWnd)
{
	CPrintDialog PrintDlg(FALSE,
		PD_ALLPAGES | PD_USEDEVMODECOPIES | PD_NOPAGENUMS | PD_HIDEPRINTTOFILE | PD_NOSELECTION,
		pParentWnd);

	HDC PrinterDC = NULL;

	if (showDialog) {
		if (IDOK != PrintDlg.DoModal()) {
			return;
		}
		PrinterDC = PrintDlg.GetPrinterDC();
	}
	else {

		if (!PrintDlg.GetDefaults()) {
			return;
		}
		PrinterDC = PrintDlg.m_pd.hDC;
	}	

	ASSERT(PrinterDC);

	// DOCINFO-Struktur initialisieren:
	CString stDocName = pMail->GetSubject();
	stDocName = _T("PopMan: ") + stDocName;

	DOCINFO docinfo;
	memset(&docinfo, 0, sizeof(DOCINFO));
	docinfo.cbSize = sizeof(DOCINFO);
	docinfo.lpszDocName = stDocName;


	// Seitenrnder festlegen:
	RECT rcMargins;

	const int xPixelPerInch = GetDeviceCaps(PrinterDC, LOGPIXELSX);
	const int yPixelPerInch = GetDeviceCaps(PrinterDC, LOGPIXELSY);

	const int OffsetLeft = GetDeviceCaps(PrinterDC, PHYSICALOFFSETX);
	const int OffsetTop = GetDeviceCaps(PrinterDC, PHYSICALOFFSETY);
	const int OffsetRight = OffsetLeft; // Voraussetzung: der nicht bedruckbare Rand ist links und rechts gleich breit!
	const int OffsetBottom = 1 * yPixelPerInch; // der untere nicht bedruckbare Rand lsst sich nicht ermitteln
												// Annahme: 1 Zoll

												//        Pixel               Zoll
	const int marginLeft = int(0.7 * xPixelPerInch);
	const int marginRight = int(0.7 * xPixelPerInch);
	const int marginTop = int(0.7 * yPixelPerInch);
	const int marginBottom = int(1.0 * yPixelPerInch);

	rcMargins.left = marginLeft - OffsetLeft;
	if (rcMargins.left < 0) rcMargins.left = 0;

	rcMargins.top = marginTop - OffsetTop;
	if (rcMargins.top < 0) rcMargins.top = 0;

	rcMargins.right = GetDeviceCaps(PrinterDC, PHYSICALWIDTH) - (marginRight < OffsetRight ? OffsetRight : marginRight) - OffsetLeft;
	if (rcMargins.right < rcMargins.left) rcMargins.right = rcMargins.left;

	rcMargins.bottom = GetDeviceCaps(PrinterDC, PHYSICALHEIGHT) - (marginBottom < OffsetBottom ? OffsetBottom : marginBottom) - OffsetTop;
	if (rcMargins.bottom < rcMargins.top) rcMargins.bottom = rcMargins.top;


	// Schriftgre anpassen:
	LOGFONT lf;
	pFont->GetLogFont(&lf);

	HDC hDC = ::GetDC(NULL);
	lf.lfHeight = ::MulDiv(lf.lfHeight, yPixelPerInch, GetDeviceCaps(hDC, LOGPIXELSY));
	::ReleaseDC(NULL, hDC);

	CFont fontPrint;
	fontPrint.CreateFontIndirect(&lf);

	// den zu druckenden Text ermitteln:
	CString stHeader, stMessage;
	CString stFromCaption, stFrom;
	CString stDateCaption, stDate;
	CString stToCaption, stTo;
	CString stSubjectCaption, stSubject;

	stMessage = pMail->GetExtractedMsg();

	stFromCaption = i18n("From:");
	stDateCaption = i18n("Date:");
	stToCaption = i18n("To:");
	stSubjectCaption = i18n("Subject:");
	//GetDlgItemText(IDC_MESSAGE_STATIC_FROM, stFromCaption);
	//GetDlgItemText(IDC_MESSAGE_STATIC_DATE, stDateCaption);
	// GetDlgItemText(IDC_MESSAGE_STATIC_TO, stToCaption);
	//GetDlgItemText(IDC_MESSAGE_STATIC_SUBJECT, stSubjectCaption);

	stFrom = pMail->GetFromComplete();
	COleDateTime DateTime(pMail->GetDate());
	stDate = DateTime.Format();
	stTo = pMail->GetTo();
	stSubject = pMail->GetSubject();
	//GetDlgItemText(IDC_MESSAGE_FROM, stFrom);
	//GetDlgItemText(IDC_MESSAGE_DATE, stDate);
	// GetDlgItemText(IDC_MESSAGE_TO, stTo);
	// GetDlgItemText(IDC_MESSAGE_SUBJECT, stSubject);

	stHeader = stFromCaption + _T(" ") + stFrom + _T("\r\n");
	stHeader += stDateCaption + _T(" ") + stDate + _T("\r\n");
	stHeader += stToCaption + _T(" ") + stTo + _T("\r\n");
	stHeader += stSubjectCaption + _T(" ") + stSubject + _T("\r\n");


	CFont fontHeader;
	CDC PrinterDCObj;
	PrinterDCObj.Attach(PrinterDC);
	fontHeader.CreatePointFont(100, _T("Arial"), &PrinterDCObj);
	PrinterDCObj.Detach();

	::StartDoc(PrinterDC, &docinfo);

	DoPrintMessage(PrinterDC, stHeader, stMessage, rcMargins, fontHeader, fontPrint);

	::EndDoc(PrinterDC);

	fontPrint.DeleteObject();
	fontHeader.DeleteObject();
	::DeleteDC(PrinterDC);
}

void DoPrintMessage(HDC hDC, CString stHeader, CString stText, RECT& Rect, HFONT hFontHead, HFONT hFontBody)
{
	LONG		yStart = Rect.top;
	LONG		PageWdt = Rect.right - Rect.left;
	LONG		RowHeight = 0;
	BOOL		bAbsatz = TRUE;							 //1. Zeile gleichbedeutend mit erstem Absatz
	LPTSTR		pBegin = NULL, pEnd = NULL, pText = NULL;
	SIZE		size = { 0, 0 };
	TEXTMETRIC	tm;

	if (hDC == NULL || stText.IsEmpty() || hFontBody == NULL || hFontHead == NULL)
		return;

	stText.Replace(_T("\t"), _T("    "));
	pText = stText.GetBuffer(stText.GetLength());

	::StartPage(hDC);

	// Header drucken:
	::SelectObject(hDC, hFontHead);
	::GetTextMetrics(hDC, &tm);
	RowHeight = tm.tmHeight + tm.tmExternalLeading;

	LOGFONT lf;
	::GetObject(hFontHead, sizeof(LOGFONT), &lf);
	lf.lfWeight = FW_BOLD;
	HFONT hFontItem = ::CreateFontIndirect(&lf);

	CString stLine = Parse(stHeader, _T("\r\n"));
	while (!stLine.IsEmpty())
	{
		CString stItem = Parse(stLine, _T(" "));
		stItem += _T(' ');

		::SelectObject(hDC, hFontItem);
		::TextOut(hDC, Rect.left, yStart, stItem, stItem.GetLength());

		::GetTextExtentPoint32(hDC, stItem, stItem.GetLength(), &size);

		::SelectObject(hDC, hFontHead);

		const int x = Rect.left + size.cx;

		for (int i = stLine.GetLength(); i > 0; --i) {
			::GetTextExtentPoint32(hDC, stLine, i, &size);
			if (x + size.cx < Rect.right) {
				::TextOut(hDC, x, yStart, stLine, i);
				if (i < stLine.GetLength()) {
					yStart += RowHeight;
					::TextOut(hDC, x, yStart, &((LPCWSTR)stLine)[i], stLine.GetLength() - i);
				}
				break;
			}
		}

		yStart += RowHeight;
		stLine = Parse(stHeader, _T("\r\n"));
	}

	::DeleteObject(hFontItem);

	yStart += RowHeight;


	::SelectObject(hDC, hFontBody);
	::GetTextMetrics(hDC, &tm);
	RowHeight = tm.tmHeight + tm.tmExternalLeading;


	while (*pText)
	{

		if (yStart > Rect.bottom - RowHeight)
		{
			::EndPage(hDC);
			::StartPage(hDC);
			::SelectObject(hDC, hFontBody);
			yStart = Rect.top;
		}

		if ((bAbsatz == FALSE) && (*pText == _T(' ')))    // skip over first leading space, if we don't start a new Absatz
			pText++;

		pBegin = pText;          // set pointer to char at beginning of line

		do                        // until the line is known
		{
			pEnd = pText;         // set pointer to char at end of line

			while (*pText != _T('\0') && *pText != _T('\r') && *pText++ != _T(' '));

			if ((*pText == _T('\0')) || (*pText == _T('\r')))
			{
				::GetTextExtentPoint32(hDC, pBegin, pText - pBegin, &size);
				if (size.cx < PageWdt)
				{
					pEnd = pText;
					bAbsatz = (*pText == _T('\r'));
				}
				break;
			}

			bAbsatz = FALSE;

			::GetTextExtentPoint32(hDC, pBegin, pText - pBegin - 1, &size);  // after each space encountered, calculate extents
		} while (size.cx < PageWdt);

		if (pBegin == pEnd)	// wenn kein gltiges Zeilenende gefunden
			pEnd = pText;

		// prfen, ob ermittelte Zeile nicht zu lang, ggf. korrigieren:
		::GetTextExtentPoint32(hDC, pBegin, pEnd - pBegin, &size);
		if (size.cx > PageWdt)
		{
			bAbsatz = FALSE;
			do {
				pEnd--;
				::GetTextExtentPoint32(hDC, pBegin, pEnd - pBegin, &size);
			} while (size.cx > PageWdt);
		}

		if (bAbsatz)
		{
			*pEnd++ = _T(' ');  //Replace CR with Space
			*pEnd++ = _T(' ');  //Replace LF with Space
		}

		::TextOut(hDC, Rect.left, yStart, pBegin, pEnd - pBegin);

		yStart += RowHeight;  // prepare for next line
		pText = pEnd;
	}
	::EndPage(hDC);

	stText.ReleaseBuffer();
}
