// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// PopManView.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_POPMANVIEW_H_)
#define AFX_POPMANVIEW_H_

#if _MSC_VER > 1000
#pragma once
#endif 

#ifndef __AFXEXT_H__
#include <afxext.h>
#endif

#include "PopMan.h"
#include <afxtempl.h>
#include "Account.h"
#include "MailList.h"
#include "MultiLineTip.h"

class CPopManDoc;
class CPopManView;


class CMyTabCtrl : public CTabCtrl
{
public:
	CMyTabCtrl() :  m_bDragging(false),  m_bCapture(false), 
					m_curDragMove(NULL), m_curNoDrop(NULL),
					m_currTabIdx(-1),    m_TimerID(0) {};

	CPopManView* m_pView;
	//{{AFX_VIRTUAL(CMyTabCtrl)
	protected:
	//}}AFX_VIRTUAL
public:
	BOOL InsertItem( int nItem, LPCTSTR lpszItem );
	BOOL InsertItem( int nItem, LPCTSTR lpszItem, int nImage );
	BOOL GetItemCaption(int Idx, CString& stCaption);
	BOOL SetItemCaption(int Idx, CString stCaption);

protected:
	int GetTabIdxBelowCursor();
	bool m_bDragging;
	bool m_bCapture;
	POINT m_ptDragStart;
	HCURSOR m_curDragMove;
	HCURSOR m_curNoDrop;

	int m_currTabIdx;
	UINT m_TimerID;

	//{{AFX_MSG(CMyTabCtrl)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


class CPopManView : public CFormView
{
	friend class CMyTabCtrl;

protected:
	CPopManView();     
	DECLARE_DYNCREATE(CPopManView)

public:
	//{{AFX_DATA(CPopManView)
	enum { IDD = IDD_VIEW };
	//}}AFX_DATA

	void Refresh();
	CPopManDoc* GetDocument() const { return (CPopManDoc*)m_pDocument; }

public:
	void OnMailMarkedChange();
	void SetMultiTabbing(BOOL bMultiTab);
	BOOL GetMultiTabbing();
	void CheckCurrentTab();
	void SaveSettings();

	//{{AFX_VIRTUAL(CPopManView)
	public:
	virtual void OnInitialUpdate();
	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);
	protected:
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

protected:
	virtual ~CPopManView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	void LoadImageList();
	int GetIconIdx(UINT nMails, UINT nUnreadMails);
	void OnShowTabToolTip(int TabIdx);
	void JoinTabs(int Master, int Slave);
	void SplitTab(int Idx);
	void OnMoveTab(int from, int to);
//	int GetUpdatedTabIconIdx(int TabIdx);
    int GetTabIdxContainingMail(const CMail* pMail);
	void UpdateTabIconAndText(int Idx);
	CString GetAutoTabCaption(const CAccounts& Accounts);
	void SwitchTab(int Idx);
	void SetActiveTab(int Idx);
    void UpdateAllTabIconsAndText();
    void UpdateActiveTab();
    int AddTab(const CAccounts& accounts, bool bAutoCaption, const CString& stCaption, int Idx = -1);
	UINT AddTab(const CSettingsKey& settings);
	int AddTab(CAccount* pAcc, int Idx = -1);
    void RemoveTab(int idx, int idxNewCurrent);
	void ResizeControls();
	void SaveLayoutAndReset();
	BOOL SetTabbing(BOOL bTabbing);
	BOOL LoadSettings();
    int GetTrashTabIdx() const;
    bool IsTrashTabVisible() const { return m_bTrashTabIsVisible; };
    bool NeedTrashTab() const;
    void SetTrashTab();
    bool ShowMarkedMails(int tabIdx) const;
    bool ShowUnmarkedMails(int tabIdx) const;

    bool IsTabbingEffective() const { return m_Tab.m_hWnd != NULL; };

    bool IsTabDraggable(int tabIdx) const { return tabIdx != GetTrashTabIdx(); }
    bool IsTabDropable(int tabIdx) const  { return tabIdx != GetTrashTabIdx(); }

	CMailList m_List;

	BOOL m_bMultiTab;
    BOOL m_bMultilineTabs;
	BOOL m_bHideMarkedMails;
    BOOL m_bTrashTab;
    
    int m_LastTabIdx;

	struct TabInfo
	{
		TabInfo() : pSelectedMail(NULL), nSelectedPos(-1), TopIdx(0), bAutoCaption(TRUE) {}
		CAccounts Accounts;
		CMail* pSelectedMail;
        int nSelectedPos;
		int TopIdx;
		BOOL bAutoCaption;
		CString Caption;
	};
	
	CArray<TabInfo, TabInfo&> m_TabArray;

	CMyTabCtrl m_Tab;
	CImageList m_ImageList;

    bool m_bTrashTabIsVisible;

	CFont    m_Font;
	
	BOOL	m_bStartUp;

	int m_nTabContextMenuIdx;
	CMultiLineTip m_TipAcc;
	bool m_bTabContextMenu;
	
	int HeightFromPoints(int iPoints);
	int PointsFromHeight(int iHeight);

	//{{AFX_MSG(CPopManView)
	afx_msg void OnTabSelchange(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnTabSelchanging(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnTabRclick(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDestroy();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnFont();
	afx_msg void OnFontColor();
	afx_msg void OnGotoNextTab();
	afx_msg void OnGotoPrevTab();
	afx_msg void OnTabRename();
	afx_msg void OnMenuSelect(UINT nItemID, UINT nFlags, HMENU hSysMenu);
	afx_msg void OnHideMarked();
	afx_msg void OnUpdateHideMarked(CCmdUI* pCmdUI);
	afx_msg void OnTrashTab();
	afx_msg void OnUpdateTrashTab(CCmdUI* pCmdUI);
	afx_msg void OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu);
	//}}AFX_MSG
	afx_msg LRESULT OnMailRead(WPARAM, LPARAM);
	afx_msg void OnTabSplit();
	afx_msg void OnTabAccRemove();
	afx_msg void OnJoinTabs();
	afx_msg void OnUpdateGUI();
	
	DECLARE_MESSAGE_MAP()
};




/////////////////////////////////////////////////////////////////////////////
//{{AFX_INSERT_LOCATION}}

#endif // AFX_POPMANVIEW_H_
