// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// PopManDoc.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_POPMANDOC_H_)
#define AFX_POPMANDOC_H_

#if _MSC_VER > 1000
#pragma once
#endif 

#pragma warning(disable: 4786)

#include "Account.h"
#include "DlgDownload.h"
#include "TrayIcon.h"
#include <afxcoll.h>
#include <afxtempl.h>
#include "MultiLineTip.h"
#include "NewTip.h"
#include "PopMan.h"
#include "Plugin.h"
#include "Rule.h"
#include "LogFile.h"
#include "MailAddressFilterList.h"

const TCHAR szAccProtocol[]			 = _T("Protocol");
const TCHAR szAccNameValue[]		 = _T("Name");
const TCHAR szAccServerValue[]		 = _T("Server");
const TCHAR szAccPortValue[]		 = _T("Port");
const TCHAR szAccUserValue[]		 = _T("User");
const TCHAR szAccPassValue[]		 = _T("Pass");
const TCHAR szAccActiveValue[]		 = _T("Active");
const TCHAR szAccTopSupportedValue[] = _T("TopSupported");
const TCHAR szAccCustomColorValue[]		= _T("CustomColor");
const TCHAR szAccUseCustomColorValue[]  = _T("UseCustomColor");
const TCHAR szAccTimeOutValValue[]      = _T("TimeOutVal");

const TCHAR szAccTopMessagesValue[]	        = _T("LimitMessages");
const TCHAR szAccTopMessagesCountValue[]	= _T("LimitMessagesCount");

const TCHAR szAccRetrieveModeValue[]	    = _T("RetrieveMode");
const TCHAR szAccLinesValue[]			    = _T("Lines");
const TCHAR szAccMaxSizeOfSmallMailsValue[]	= _T("MaxSizeOfSmallMails");
const TCHAR szAccLinesBigMailsValue[]	    = _T("LinesBigMails");
const TCHAR szNewTipDurationValue[]	        = _T("NewTipDuration");
const TCHAR szMarkBlackListedMailValue[]    = _T("MarkBlackListedMail");


//const TCHAR szAccLimitLoadSizeValue[]   = _T("LimitLoadSize");
const TCHAR szAccStrictHeaderCheckValue[]   = _T("StrictHeaderCheck");
const TCHAR szAccTrayColorValue[]		    = _T("TrayColor");
const TCHAR szAccUseCustomIntervalValue[]   = _T("UseCustomInterval");
const TCHAR szAccCustomIntervalValue[]		= _T("CustomInterval");
const TCHAR szAccParametersValue[]			= _T("Parameters");
const TCHAR szAccUseUIDLForDeleteValue[]	= _T("UIDLForDelete");

const TCHAR szAutoCheckDelayOnResume[]   = _T("AutoCheckDelayOnResume");
const TCHAR szCheckMailOnStartup[]   = _T("CheckMailOnStartup");
const TCHAR szDUNValue[]		     = _T("DUN");
const TCHAR szUpdateInterval[]		 = _T("UpdateInterval");
const TCHAR szNotification[]		 = _T("Notification");
const TCHAR szSoundNotify[]		     = _T("SoundNotify");
const TCHAR szSoundFile[]		     = _T("SoundFile");
const TCHAR szMarkUnread[]		     = _T("MarkUnread");

const TCHAR szRulesLoggingEnabled[]	 = _T("RulesLoggingEnabled");
const TCHAR szRulesMaxLogSize[]		 = _T("RulesMaxLogSize");
const TCHAR szLoggingEnabled[]		 = _T("LoggingEnabled");
const TCHAR szMaxLogSize[]			 = _T("MaxLogSize");
const TCHAR szCompactLogging[]       = _T("CompactLogging");
const TCHAR szBallonTip[]			 = _T("BallonTip");
const TCHAR szLatestReleaseVersion[] = _T("LatestVersion");
const TCHAR szLatestBetaVersion[]	 = _T("LatestBetaVersion");
const TCHAR szSaveFolder[]			 = _T("SaveFolder");
const TCHAR szSaveAs[]				 = _T("SaveAs");
const TCHAR szFileTemplate[]		 = _T("FileTemplate");
const TCHAR szLastUpdateCheck[]		 = _T("LastUpdateCheck");
const TCHAR szAutoCheckMinimized[]	 = _T("AutoCheckMinimized");
const TCHAR szNotifyCode[]			 = _T("NotifyCode");
const TCHAR szCustomAutoCheck[]		 = _T("CustomAutoCheck");

const TCHAR szSuspendAutoCheck[]	 = _T("SuspendAutoCheck");
const TCHAR szSuspendFrom[]			 = _T("SuspendFrom");
const TCHAR szSuspendTo[]			 = _T("SuspendTo");
const TCHAR szStartCheckDelay[]		 = _T("StartCheckDelay");
const TCHAR szEmailClient[]			 = _T("EmailClient");
const TCHAR szReplyOption[]			 = _T("ReplyOption");
const TCHAR szReplyParam[]			 = _T("ReplyParam");
const TCHAR szHTMLReply[]			 = _T("HTMLReply");
const TCHAR szEnforceAddress[]		 = _T("EnforceAddress");
const TCHAR szClientLaunchAction[]	 = _T("QuitOnEmailClient");
const TCHAR szConfirmDeleteMain[]	 = _T("ConfirmDeleteMain");
const TCHAR szConfirmDeleteMsg[]	 = _T("ConfirmDeleteMsg");
const TCHAR szMarkDelete[]			 = _T("MarkDelete");
const TCHAR szShowMarkDeleteInfo[]	 = _T("ShowMarkDeleteInfo");
const TCHAR szShowEmptyTrashWarning[]= _T("ShowEmptyTrashWarning");
const TCHAR szRulesFileNameSetting[] = _T("RulesFileName");

const TCHAR szActionLeftClick[]		 = _T("ActionLeftClick");
const TCHAR szActionMiddleClick[]	 = _T("ActionMiddleClick");
const TCHAR szActionRightClick[]	 = _T("ActionRightClick");
const TCHAR szActionDoubleClick[]	 = _T("ActionDoubleClick");

const TCHAR szNumMailsInTray[]		 = _T("NumMailsInTray");
const TCHAR szRotateMailNum[]		 = _T("RotateMailNum");
const TCHAR szNumMails[]			 = _T("NumMails");
const TCHAR szRotationInterval[]	 = _T("RotationInterval");
const TCHAR szHighColorTray[]		 = _T("HighColorTray");
const TCHAR szAdvancedTrayInfo[]	 = _T("AdvancedTrayInfo");
const TCHAR szShowMainWnd[]			 = _T("ShowMainWnd");
const TCHAR szDoubleClickDelay[]	 = _T("DoubleClickDelay");

const TCHAR szDetailedNewTip[]		 = _T("DetailedTip");
const TCHAR szShowNewMailTip[]		 = _T("NewMailTip");
const TCHAR szNotifyProtectedOnly[]	 = _T( "NotifyProtectedOnly");
const TCHAR szKeyboardLight[]		 = _T("KeyboardLight");
const TCHAR szLogFile[]              = _T("PopManLogFile.log");
const TCHAR szRuleLogFile[]          = _T("RuleLogFile.log");
const TCHAR szReplyTmpFile[]         = _T("reply-tmp.eml");
const TCHAR szRulesFile[]			 = _T("Rules.txt");
const TCHAR szRulesExamplesFile[]	 = _T("ExampleRules.txt");
const TCHAR szLastDestinationList[]	 = _T("LastRulesDestList");

const TCHAR szCheckForUpdates[]      = _T("CheckForUpdates");

class CPopManDoc : public CDocument
{
protected: 
	CPopManDoc();
	DECLARE_DYNCREATE(CPopManDoc)

	enum NOTIFICATIONS
	{
		ntNewMail = 1,
		ntClear = 2,
		ntMailsDeleted = 3,
		ntNewAccount = 4,
		ntAccountRemoved = 5,
		ntAccountChanged = 6,
		ntEnsureVisible = 7
	};

	class AccountChangedParam : public CObject
	{
	public:
		CAccount* m_pOldAccount;
		CAccount* m_pNewAccount;
	};

public:
	CAccounts m_Accounts;

	UINT GetUpdateInterval() { return m_nUpdateInterval; };
	void SetUpdateInterval(UINT UpdateInterval);
	
	CTrayIcon   m_TrayIcon;
	BOOL		m_bNotification;
	BOOL		m_bSoundNotify;
	CString		m_stSoundFile;
	BOOL		m_bUseDUN;
	BOOL		m_bCheckMailOnStartup;
	BOOL		m_bMarkUnread;
	BOOL		m_bCompactLogging;

	CVersion	m_LatestReleaseVersion;
	CVersion	m_LatestBetaVersion;

	CString		m_stAppDataPath;

	CString		m_stSaveFolder;
	CString		m_stFileTemplate;

	DWORD		m_dwLastUpdateCheck;

	enum SAVEFILETYPES
	{
		frmEmlFile = 0,
		frmTxtFile = 1,
	};

	SAVEFILETYPES m_SaveMailAs;
	BOOL m_bAutoCheckMinimized;

	enum NOTIFYSTATES 
	{
		Minimized   = 1,
		AutoChecked = 2,
		Always      = 3
	};

	NOTIFYSTATES  m_nNotify;	

	BOOL m_bSuspendAutoCheck;
	UINT m_nSuspendFrom;
	UINT m_nSuspendTo;
	UINT m_nStartCheckDelay;
	CString m_stEmailClient;
	
    bool m_bMuteMode;
	
	enum REPLYOPTIONS
	{
		Eml      =  1,
		MAPI     =  2,
		MailTo   =  3,
		CmdParam =  4
	};

	REPLYOPTIONS  m_nReplyOption;	
	BOOL	 m_bHTMLReply;
	BOOL	 m_bEnforceAddress;
	CString  m_stReplyParam;

	enum TRAYACTIONS
	{
		Nothing			 = 0,
		ShowWindow		 = 1,
		CheckMail		 = 2,
		PopUpMenu		 = 3,
		RunEmailClient   = 4,
		CheckAndShow	 = 5,
		ToggleWindow     = 6,
		ToggleAutoCheck  = 7,
		ShowMailInfo   = 8,
	};

	TRAYACTIONS m_actionLeftClick;
	TRAYACTIONS m_actionMiddleClick;
	TRAYACTIONS m_actionRightClick;
	TRAYACTIONS m_actionDoubleClick;

	enum CLIENTLAUNCHACTION
	{
		NoAction	= 0,
		Quit		= 1,
		HideToTray	= 2
	};

	CLIENTLAUNCHACTION m_ClientLaunchAction;

	BOOL m_bConfirmDeleteMain;
	BOOL m_bConfirmDeleteMsg;
	BOOL m_bMarkDelete;

	enum NUMMAILSTRAY
	{
		All    = 0,
		New    = 1,
		Unread = 2
	};

	NUMMAILSTRAY m_numMails;
	BOOL	m_bNumMailsInTray;
	BOOL	m_bRotateMailNum;
	UINT	m_nRotationInterval;
	BOOL	m_bHighColorTray;
	BOOL	m_bAdvancedTrayInfo;
	BOOL	m_bShowMainWnd;

	BOOL	m_bShowNewMailTip;
	BOOL	m_bDetailedNewTip;
	BOOL	m_bBallonTip;
	BOOL	m_bNotifyProtectedOnly;


    CMailAddressFilterList m_BlackList;
    CMailAddressFilterList m_WhiteList;

    BOOL    m_bMarkBlackListedMail;

	BOOL	m_bCustomAutoCheck;

	enum KEYBOARDLIGHT 
	{
		None = 0,
		ScrollLock = 1,
		NumLock = 2,
		CapsLock = 3,
	};

	void setKeyboardLight(KEYBOARDLIGHT ligth) {
		ResetKeyboardLight();
		m_KeyboardLight = ligth;
	}
	KEYBOARDLIGHT getKeyboardLight() { return m_KeyboardLight; }

    void SetMaxLogSize(int size) { m_LogFile.SetMaxSize(size);    }
    int  GetMaxLogSize() const   { return m_LogFile.GetMaxSize(); }
    void EnableLog(bool enable)  { m_LogFile.SetEnabled(enable);  }
    bool IsLogEnabled() const    { return m_LogFile.IsEnabled();  }

    void SetMaxRulesLogSize(int size) { m_RuleLogFile.SetMaxSize(size);    }
    int  GetMaxRulesLogSize() const   { return m_RuleLogFile.GetMaxSize(); }
    void EnableRulesLog(bool enable)  { m_RuleLogFile.SetEnabled(enable);  }
    bool IsRulesLogEnabled() const    { return m_RuleLogFile.IsEnabled();  }
	
private:
    CLogFile m_LogFile;
    CLogFile m_RuleLogFile;

    CRulesManager m_RuleManager;

    CString m_stLastSelectedRulesDestList;

	KEYBOARDLIGHT m_KeyboardLight;

	CDlgDownload* m_pDlgDownload;

	UINT m_nUpdateInterval; // in minutes!
	UINT m_nTimerIDAutoCheck;
	UINT m_nTimerCheckOnStartup;
	UINT m_nTimerIDKeyboard;

//	UINT m_nNewMailCount;

	CStringArray m_MailCache;

    CString m_stRulesName;

	CMultiLineTip m_MailInfo;
	CNewTip		  m_NewTip;

	CString m_stCurrStatusText;

	BOOL m_bShowMarkDeleteInfo;
	BOOL m_bShowEmptyTrashWarning;

    bool m_bDisableDeferCheck;

protected:
	enum ACTIONS
	{
		Idle        =  0,
		Checking    =  1,
		Deleting    =  2,
		Downloading =  3,
		Marking     =  4,
	};

	ACTIONS m_currentAction;
	BOOL	m_bError;
	CString	m_stNewMailTip;
	CString	m_stErrorTip;
	CString	m_stCheckingTip;
	BOOL	m_bAutoChecked;

	CStringArray m_NewMailList;
	CStringArray m_OnNewMailList;

    CTime m_LastModifiedMailCache;

    int m_nNewMailTipDuration;

	enum NEWTIPBUTTON
	{
		ShowMail	= 0,
		EmailClient = 1,
		DeleteMail  = 2,
		CloseTip    = 3,
	};

	COleDateTime m_LastCheckTime;
	COleDateTime m_LastSuccessfulCheckTime;

	CTypedPtrList<CPtrList, CProtocolPlugin*> m_ProtocolPlugins;

	bool m_bKeyLightToggled;
	HANDLE m_hKeyboardDev;

public:
	//{{AFX_VIRTUAL(CPopManDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void OnCloseDocument();
	//}}AFX_VIRTUAL

public:
	void ShowMarkMessagInfo();
	int CountMarkedMails();
	CProtocol* GetProtocolFromName(LPCTSTR szName);
	void GetAvailableProtocols(CProtocols& protocols);
	void BlackListSenders(const CMails& list);
    void WhiteListSenders(const CMails& list);
	void OnUpdateGUI();
	void OnReadStateChanged();
	void SaveSettings();
	void OnStartUp();
	void OnMainWndHide();
	void OnMainWndMinimize();
	void OnMainWndRestore();
    void UpdateTrayIcon();
	void RemoveMails(const CMails* pMails);
	BOOL GetAccountPass(const CAccount* pAcc, CString& stPass, BOOL& bRemember);
	BOOL SetAutoStart(BOOL bAutoStart);
	BOOL AutoStartEnabled();
	void ReplyToMail(CMail* pMail);
	void Log(LPCTSTR szLog);
	//void Log(const void* pData, int nDataLen);
	void RepaintAllViews();
	BOOL IsMailValid(const CMail* pMail) const;
	BOOL SaveMail(CMails* pMailList);
	void ViewMailExternally(CMail* pMail);
	BOOL DownloadMail(CMail* pMail, BOOL& bNoConnection, BOOL bKeepConnectionAlive);
	BOOL ListMails(BOOL bGoOnline, BOOL bHardReload = FALSE);
	BOOL ListMailsFromAccs(CAccounts& Accs, BOOL bGoOnline, BOOL bHardReload);
    BOOL ListAccs(CAccounts& Accs, BOOL bHardReload, BOOL bRetryFailedAccs = TRUE);
	BOOL DeleteMails(CMails* pMailList);
	BOOL MarkMailsAsSeen(CMails* pMailList);

	void DisplayState(LPCTSTR pszState);
	void DisplayError(LPCTSTR pszError);


	void OnStatusChanged(const CAccount* pAccount);
	void OnNewMail(CMail* pMail, bool bIsNew, bool& bDelete);

	void OnDataTraffic(BOOL bReceivedData, const void* pData, int nDataLen);
	
	BOOL ConnectionsPending() const;
	void CancelConnections();

	CString GetCurrentStateText() const { return m_stCurrStatusText;}
	
	int GetMailCount(NUMMAILSTRAY numMails, CString& stTip);
    bool AddItemToRulesList(const CString& item, const CMail* pMail = NULL);
    bool IsAddItemToRulesListEnabled() const { return m_RuleManager.CountDefinedLists() > 0; }

    bool IsNewMailAvailable() const;
    
	COleDateTime GetLastCheckTime() const { return m_LastSuccessfulCheckTime; } // Used in PopManDoc OnAreYouMe
	BOOL GetErrorStatus() const { return m_bError; } // SNH added for MainFrm OnAreYouMe visibility

	virtual ~CPopManDoc();

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	BOOL IsEmptyTrashEnabled();
	void OnAutoCheck();
	void LoadPlugins();
	static CString GetStdNotifySound();
	CString GetIdleStateInfo() const;
	static void OnNewTipEvent(int nEvent, DWORD dwValue);
	void ShowNewMailTip(const CNewTip::CLines& Lines, LPCTSTR szHeader);
	void OnListAccount();
	static CString TabJustify(CString stTabs, HFONT hFont);
	CString FormatAccountErrTip(const CAccount* pAcc);
	int GetAccountMailNum(const CAccount* pAcc, NUMMAILSTRAY numMails);
	CString GetMessageCountStr(NUMMAILSTRAY numMails, int nMessages, int nAccs, const CString& stAccName);
	HICON CreateNumIcon(int nNum, COLORREF colorCircle);
	HICON CreateErrIcon(COLORREF colorCircle);
	HICON CreateInnerRectIcon(COLORREF colorInner, COLORREF colorOuter);
	void PaintInnerRect(HDC dc, int xOffset, int yOffset, int Width, int Height, COLORREF Color);
	void PaintCircle(HDC dc, int xOffset, int yOffset, COLORREF Color);
	void ExecuteAction(TRAYACTIONS Action);
	void UpdateNewMailTip();
	void SetNewMailState(BOOL bNewMail);
	CString GetStdEmailClient();
	void StopTimer();
	void StartTimer();
	void OnNewMailEvent(int nNewMails);
	void OnActionChanged(ACTIONS newAction);
	static BOOL ClearDirectory(LPCTSTR szDirectory);
	CString GetNameFromTemplate(CString stTemplate, const CMail* pMail);
	BOOL GetNewVersion(const CVersion& Version, CString stInfoLink);
	static CString GetNewFileName(CString stFolder, CString stFile, CString stExt);
	BOOL CheckOnlineUpdate(BOOL bGoOnline, BOOL& bNewVersion, CVersion& Version, CString& InfoLink);
    
    bool MailCacheChanged();
    void ResetMailCacheChanged();
    void GetMailCacheFileName(CString& fileName);
    void CheckReloadMailCache();
	void SaveMailCache();
	void LoadMailCache();
	
	BOOL LoadAccount(CSettingsKey& AccountsKey, LPCTSTR szAccount, CAccount*& pAcc);
	void SaveAccount(CSettingsKey& AccountsKey, LPCTSTR szAccount, const CAccount& Acc);
	BOOL CheckInetConnection(BOOL bGoOnline);
	void ResetKeyboardLight();
	static BOOL ShowDialDialog();
	static BOOL IsOnline();

	static void OnTrayAction(int nAction);
	void ToggleKeyboardLight();

	static void CALLBACK Timer_ToggleKeyboardLight(HWND hwnd, UINT uMSG, UINT idEvent, DWORD dwTime);
	static void CALLBACK Timer_AutoCheck(HWND hwnd, UINT uMSG, UINT idEvent, DWORD dwTime);
	static void CALLBACK Timer_CheckOnStartup(HWND hwnd, UINT uMSG, UINT idEvent, DWORD dwTime);
	static CPopManDoc* m_pDoc;

	BOOL  m_bLastLogFromServer;

	//{{AFX_MSG(CPopManDoc)
	afx_msg void OnCancel();
	afx_msg void OnUpdateCancel(CCmdUI* pCmdUI);
	afx_msg void OnAccounts();
	afx_msg void OnUpdateListMails(CCmdUI* pCmdUI);
	afx_msg void OnListMails();
	afx_msg void OnCheckUpdate();
	afx_msg void OnUpdateCheckUpdate(CCmdUI* pCmdUI);
	afx_msg void OnImportAccounts();
	afx_msg void OnReloadMails();
	afx_msg void OnAutocheckEnable();
	afx_msg void OnUpdateAutocheckEnable(CCmdUI* pCmdUI);
	afx_msg void OnLaunchEmailClient();
	afx_msg void OnShowBlacklist();
	afx_msg void OnEmptyTrash();
	afx_msg void OnUpdateEmptyTrash(CCmdUI* pCmdUI);
	afx_msg void OnRules();
	afx_msg void OnShowWhitelist();
	afx_msg void OnMuteMode();
	afx_msg void OnUpdateMuteMode(CCmdUI* pCmdUI);
	//}}AFX_MSG
	
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}

#endif // !defined(AFX_POPMANDOC_H_)
