// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// PopMan.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_POPMAN_H_)
#define AFX_POPMAN_H_

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       
#include <afxtempl.h>
#include "Settings.h"
#include "Version.h"

const TCHAR szMainRegKey[]	  =  _T("Software\\PopMan");
const TCHAR szPopManIniFile[] =  _T("PopMan.ini");
const TCHAR szMailCacheFile[] =  _T("MailCache.dat");
const TCHAR szBlackListFile[] =  _T("BlackList.dat");
const TCHAR szWhiteListFile[] =  _T("WhiteList.dat");

const TCHAR szMainWindowKey[] =  _T("MainWindow");
const TCHAR szMsgWindowKey[]  =  _T("MsgWindow");
const TCHAR szViewKey[]		  =  _T("View");
const TCHAR szAccountsKey[]   =  _T("Accounts");
const TCHAR szSettingsKey[]   =  _T("Settings");


const TCHAR szWndMaximizedValue[] = _T("Maximized");
const TCHAR szWndLeftValue[]      = _T("Left");
const TCHAR szWndTopValue[]       = _T("Top");
const TCHAR szWndWidthValue[]     = _T("Width");
const TCHAR szWndHeightValue[]    = _T("Height");

const TCHAR szTranslationFile[]   = _T("Translation");
const TCHAR szPasswordEnabled[]	  = _T("LastKW");
const TCHAR szPasswordValue[]	  = _T("CurrPd");

const TCHAR szThemeValue[]		  = _T("Theme");

const TCHAR szPopManWebsite[]     = _T("https://www.ch-software.de/popman");
const TCHAR szPopManEmail[]       = _T("chuebner@ch-software.de");
const TCHAR szPopManForum[]       = _T("https://www.ch-software.de/popman/forum");


const TCHAR szPopManUpdated[] = _T("03/23/2023");

const CVersion cstAppVersion(
						      1,		// Major version number
						      3,		// Minor version number
						      18,		// Sub\Beta version number
						      FALSE		// Is Beta version?
							);


BOOL GetSettingsRootKey(CSettingsKey& Key);
BOOL OpenSettingsKey(CSettingsKey& Key, LPCTSTR szKeyName);
BOOL CreateSettingsKey(CSettingsKey& Key, LPCTSTR szKeyName);
BOOL FlushSettings();



struct LANGUAGE
{
	CString stFile;
	CString stName;
	CString stAuthor;
	CString stEmail;
	CString stComment;
	CString stUpdated;
	UINT	nLangID;
};

typedef CArray<LANGUAGE, LANGUAGE&> CLanguages;


/////////////////////////////////////////////////////////////////////////////
// CPopManApp:
class CPopManApp : public CWinApp
{
public:
	CPopManApp();
	~CPopManApp() {TRACE0("App-Destruktor\n");};

	static CString GetAppPath();
	static CString GetAppDataPath();
	static CString GetGlobalAppDataPath();
	static CString GetAppLanguagePath();
	static CString GetAppTempPath();
	static CString GetAppPluginsPath();
	static CString GetAppThemesPath();
	static bool GetCurrentThemePath(CString& stPath);

	static BOOL GetInstalledLanguages(CLanguages& Languages);
	static void BroadcastChangedGUI();

	static void		GetAvailableThemes(CStringArray& themes);
	static bool		SetTheme(LPCTSTR szTheme);
	static CString	GetCurrentTheme() { return m_stTheme; }

	enum RESSIZE
	{
		Default = 0,
		Small   = 1,
		Big     = 2,
	};

	static HICON   GetIcon(UINT Icon, RESSIZE resSize = RESSIZE::Default);
	static HCURSOR GetCursor(UINT Cursor);

	void SaveSettings();

	BOOL	m_bPasswordProtect;
	CString m_stPassword;
	static BOOL m_bCheckForUpdates;

private:
	static BOOL CALLBACK UpdateGUI(HWND hWnd, LPARAM lParam);
	static BOOL CALLBACK Searcher(HWND hWnd, LPARAM lParam);
	static BOOL ExtractLanguageInfo(const CString& stData, LANGUAGE& Item);
	static CString GetItem(const CString& Src, LPCTSTR Search);
	static BOOL ImportRegistrySettings(CRegistryKey& KeyIn, CSettingsKey& KeyOut);
	
	
	static BOOL  m_bLocalStorage;
	static CString m_stTheme;
	
	struct ICONSET
	{
		ICONSET() : hDefault(NULL), hSmall(NULL), hBig(NULL) {};
		HICON hDefault;
		HICON hSmall;
		HICON hBig;
	};

	typedef CMap<UINT, UINT, ICONSET, ICONSET> CMapIcon;
	typedef CMap<UINT, UINT, HCURSOR, HCURSOR> CMapCursor;

	static CMapIcon   m_MapResourceIcon;
	static CMapCursor m_MapResourceCursor;

	static void DestroyResources(CMapIcon& mapIcons, CMapCursor& mapCursors);
	
	static LPCTSTR MapIconToName(UINT Icon);
	static LPCTSTR MapCursorToName(UINT Cursor);


	struct RESNAMEMAP
	{
		UINT Res;
		LPCTSTR szName;
	};
	
	static RESNAMEMAP mapIconName[];
	static RESNAMEMAP mapCursorName[];
	
	//{{AFX_VIRTUAL(CPopManApp)
	public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CPopManApp)
	afx_msg void OnAppAbout();
	afx_msg void OnAppHelp();
	afx_msg void OnUpdateAppAbout(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
protected:
	void ImportDataFile(LPCTSTR szFile);
	BOOL LoadUserDefaultLang();
};


/////////////////////////////////////////////////////////////////////////////


//{{AFX_INSERT_LOCATION}}

#endif // !defined(AFX_POPMAN_H_)
