// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// PluginAccount.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_PLUGINACCOUNT_H_)
#define AFX_PLUGINACCOUNT_H_

#if _MSC_VER > 1000
#pragma once
#endif 

#include <afxmt.h>
#include "Account.h"
#include "Plugin.h"


#define WM_CHANGE_THREAD WM_USER+20


class CPluginAccount : public CAccount  
{
public:
	CPluginAccount(CPopManDoc* pD, CProtocol& Protocol);
	virtual ~CPluginAccount();

	virtual void SetTimeOut(UINT nSecs) { m_nTimeOut = nSecs; }
	virtual UINT GetTimeOut()  const    { return m_nTimeOut;  }

	virtual BOOL  IsBusy()		const { return m_bBusy; }
	virtual BOOL  IsCanceled()	const { return m_bCanceled; }
	virtual BOOL  IsTimedOut()	const { return m_bTimedOut || m_Protocol.LastErrorMessage() == "Timeout" ; }

	virtual void Cancel() { m_bCanceled = TRUE;   WaitForComplete();  }
	virtual void Close();

	virtual BOOL ListMails(BOOL bHardReload);
	virtual BOOL DeleteMails(CMails* pMailList);
	virtual BOOL MarkMailsAsSeen(CMails* pMailList);
	virtual BOOL DownloadMail(CMail* pMail, BOOL bKeepConnectionAlive);

	virtual BOOL ReadSettings(const CSettingsKey& settings);
	virtual void SaveSettings(CSettingsKey& settings) const;

	virtual CString GetProtocolName() const { return m_Protocol.GetName(); }
    virtual CProtocol& GetProtocol() const { return m_Protocol; }

	const CString& GetParameters() const { return m_stParameters; }
	bool  SetParameters(const CString& Params) { 
		if(!m_Protocol.ValidateParameters(Params)) return false;

		m_stParameters = Params;
		return true;
	}


protected:
	CString m_stParameters;
	int  m_nTimeOut;
	BOOL m_bBusy;
	BOOL m_bCanceled;
	BOOL m_bTimedOut;
	CProtocol& m_Protocol;

	BOOL   m_bStopThread;
	BOOL   m_bThreadSuccess;
	
	BOOL BeginSession(UINT ErrLocation, void (*fnThread)(LPVOID));
	void ErrorOccured(ERRORS Error, UINT ErrLocation = 0, BOOL bTerminate = TRUE);
	void StateChanged(STATES State);
	BOOL IsMailInList(const CString& stUIDL);

	CString m_RefreshToken;
	CString m_AccessToken;
	CTime   m_AccessTokenExpiresAt;

protected:
	BOOL ConnectAndLogin(int* pMailsCount);
	BOOL OnListMails(BOOL bHardReload);
	BOOL OnDeleteMails(CMails* pMailList);
	BOOL OnMarkMails(CMails* pMailList);
	BOOL OnDownloadMail(CMail* pMail, BOOL bKeepConnectionAlive);

protected:
	static void WINAPI CallbackDoevents(DWORD dwContext);
		
	void OnNewMail(CMail* pMail, bool isNew, bool& bDelete);
	BOOL RetrieveMail(int Idx, BOOL bComplete, CString& stSrc);
	BOOL DeleteMail(int Idx);
	BOOL MarkMailAsSeen(int Idx);
	BOOL GetMailSize(int Idx, int& Size);
	bool IsAborted();

	BOOL	ListMails_bHardReload;
	CMails*	DeleteMails_pMailList;
	CMails*	MarkMails_pMailList;
	CMail*	DownloadMail_pMail;
	BOOL	DownloadMail_bKeepConnectionAlive;

	BOOL WaitForComplete();

	static void wt_ListMails(LPVOID lParam);
	static void wt_DeleteMails(LPVOID lParam);
	static void wt_MarkMails(LPVOID lParam);
	static void wt_DownloadMail(LPVOID lParam);
	static void wt_Disconnect(LPVOID lParam);
//	static void wt_MailboxChanged(LPVOID lParam);

	struct {
		ERRORS Error;
		UINT ErrLocation;
		BOOL bTerminate;
	} paramErrorOccured;

	struct {
		STATES State;
	} paramStateChanged;

	struct {
		CMail* pMail;
		bool   bNew;
		bool*  bDelete;
	} paramOnNewMail;

	CMails* paramDocRemoveMails;

	enum ThreadedProcs {
		procErrorOccured,
		procStateChanged,
		procDocRemoveMails,
		procOnNewMail,
	};

	LRESULT CallFunction(ThreadedProcs procID);
	bool IsWorkerThread();

	class CThreadWnd : public CWnd {
	public:
		CThreadWnd() { CWnd::CreateEx(0, AfxRegisterWndClass(0), _T("PluginAcc"), WS_POPUP, 0,0,0,0, NULL, 0); }
	protected:
		afx_msg LRESULT OnChangeThread(WPARAM wParam, LPARAM lParam);
		DECLARE_MESSAGE_MAP()
	};

	friend class CThreadWnd;

	static CWnd* pThreadWnd;
	static DWORD dwInstanceCount;

};

#endif // !defined(AFX_PLUGINACCOUNT_H_)
