// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// POP3Account.h
//
////////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_POP3ACCOUNT_H_)
#define AFX_POP3ACCOUNT_H_

#if _MSC_VER > 1000
#pragma once
#endif 


#include "Account.h"
#include "SyncTlsSocket.h"


class CPOP3Account : public CAccount {

public:

	CPOP3Account(CPopManDoc* pD, BOOL useTLS);
	virtual ~CPOP3Account();


	virtual void SetTimeOut(UINT nSecs) { m_Socket.SetTimeOut(nSecs); };
	virtual UINT GetTimeOut()  const    { return m_Socket.GetTimeOut(); };

	virtual BOOL  IsBusy()		const { return m_Socket.IsBlocking(); }
	virtual BOOL  IsCanceled()	const { return m_Socket.IsCanceled(); }
	virtual BOOL  IsTimedOut()	const { return m_Socket.IsTimedOut(); }

	virtual void Cancel() { m_Socket.Cancel(); }
	virtual void Close()  { m_Socket.Close(); StateChanged(stIdle);}

	virtual BOOL ListMails(BOOL bHardReload);
	virtual BOOL DeleteMails(CMails* pMailList);
	virtual BOOL MarkMailsAsSeen(CMails* pMailList) { return FALSE; }
	virtual BOOL DownloadMail(CMail* pMail, BOOL bKeepConnectionAlive);

	virtual BOOL ReadSettings(const CSettingsKey& settings);
	virtual void SaveSettings(CSettingsKey& settings) const;

	virtual CString GetProtocolName() const { return m_bUseTLS ? _T("POP3 TLS") : _T("POP3"); }

	void   SetTopSupported(BOOL bSupported) { m_bTopSupported = bSupported; }
	BOOL   IsTopSupported()	const { return m_bTopSupported; }

	void   SetStrictHeaderCheck(BOOL bStrict) { m_bStrictHeaderCheck = bStrict; }
	BOOL   IsStrictHeaderCheck()	const { return m_bStrictHeaderCheck; }

private:

	BOOL m_bUseTLS;

	void ErrorOccured(ERRORS Error, UINT ErrLocation = 0, BOOL bTerminate = TRUE);

	enum ABORT_CONDITION
	{
		abNone,
		abMsgTextComplete,  // abort receiving data, if the readable part of the message has been transmitted
		abEnough,			// abort receiving data, if about 66 KB of data has been received
	};

	BOOL GetCmdListing(CStringArray& ListingArray, const CString& stCmd, BOOL bErrorHandling);
	BOOL GetMailHeader(int nMailNo, CString& stHeader, BOOL bAbort = TRUE);
	BOOL ConnectAndLogin(int* pMailsCount = NULL, BOOL bUpdateCaches = TRUE);
	BOOL GetServerUIDLs(CStringArray& UIDLArray, BOOL bForceUpdate = FALSE);
	BOOL GetServerSizes(CStringArray& SizeArray, BOOL bForceUpdate = FALSE);
	BOOL GetMailSize(int nMailNo, int& nSize);
	BOOL RetrieveMail(int nMailNo, BOOL bComplete, CString& stSource);
	BOOL DeleteMail(int nMailNo);
	BOOL SendStat(int* pMailsCount);

	BOOL SendAndReceive(CString stSend, LPCTSTR pszMatch = NULL, LPCTSTR pszTerminator = NULL, ABORT_CONDITION AbortCondition = abNone);
	BOOL WaitForResponse(LPCTSTR pszMatch = NULL, LPCTSTR pszTerminator = NULL);
	
	BOOL IsMailInList(const CString& stUIDL, int nSize);
	BOOL IsMailInList(const CString& stSource);

	BOOL DoSaveDelete(int nMailsCount, CMails* pMailList);

private:
	CSyncTlsSocket	m_Socket;

	CString m_RefreshToken;
	CString m_AccessToken;
	CTime   m_AccessTokenExpiresAt;

	BOOL		m_bTopSupported; // specifies, whether the server supports the TOP command
	BOOL		m_bTopVerified;  // specifies, whether the availability of the TOP command has been verified
	BOOL		m_bTopReChecked; // specifies, whether the lack of the TOP command has been verified
	BOOL		m_bStrictHeaderCheck;  

	CString		m_stStatString;  

	CStringArray m_SizeCache;
};





#endif // AFX_POP3ACCOUNT_H_