// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// NewTip.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_NEWTIP_H__)
#define AFX_NEWTIP_H__

#if _MSC_VER > 1000
#pragma once
#endif 

#include <afxtempl.h>



class CNewTipButton
{
public:
	CNewTipButton() : m_State(STATE::Normal), m_pParent(NULL), m_bPressed(FALSE), m_dwID(0) {};
	
	CString m_stCaption;
	DWORD	m_dwID;

	int m_X;
	int m_Y;
	int m_Width;
	int m_Height;
	CWnd* m_pParent;

	enum STATE
	{
		Normal  = 0,
		Hover   = 1,
		Pressed = 2,
	};

	STATE		m_State;
	BOOL		m_bPressed;

	void SetPos(int X, int Y)
	{
		m_X = X;
		m_Y = Y;
	}

	void SetSize(int nWidth, int nHeight)
	{
		m_Width = nWidth;
		m_Height = nHeight;
	}

	CRect GetRect() const
	{
		return CRect(m_X, m_Y, m_X + m_Width, m_Y + m_Height);
	}

	void Draw(CDC& dc, COLORREF colorText);
	void OnMouseDown(CPoint point);
	void OnMouseMove(CPoint point);
	BOOL OnMouseUp(CPoint point);

};



class CNewTip : public CWnd
{
public:
	CNewTip();
	virtual ~CNewTip();

	void Show(int nSeconds);

public:
	//{{AFX_VIRTUAL(CNewTip)
	//}}AFX_VIRTUAL

	HFONT  m_headFont;
	HFONT  m_Font;

	typedef void (*CallbackFunc)(int, DWORD);
	CallbackFunc m_fnCallback;

	CString	m_stHead;
	
	struct LINE
	{
		LINE() { dwValue = 0; nColor = 0; }
		CString  stStr;
		COLORREF nColor;
		DWORD	 dwValue;
		CRect	 rcPos;
	};

	typedef CArray<LINE, LINE&> CLines;
	CLines m_Lines;

	typedef CArray<CNewTipButton, CNewTipButton&> CNewTipButtons;
	CNewTipButtons m_Buttons;

	enum NEWTIPEVENT
	{
		ItemClicked = 0,
		ButtonClicked = 1,
	};


private:
	static CString m_stClassName;
	void CalculateSize(int& nWidth, int& nHeight);

	int	   m_nLineHeight;
	int	   m_nHeadHeight;

	DWORD  dwDownValue;
	bool   m_bCallingBack;

protected:
	void DoCallBack(int event, DWORD val);
	DWORD GetItemValueFromPos(const POINT& Point);
	//{{AFX_MSG(CNewTip)
	afx_msg void OnPaint();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}

#endif // AFX_NEWTIP_H__
