// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// MultiLineTip.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_MULTILINETIP_H_)
#define AFX_MULTILINETIP_H_

#if _MSC_VER > 1000
#pragma once
#endif 

#include <afxtempl.h>


class CMultiLineTip : public CWnd
{
public:
    CMultiLineTip();
	virtual ~CMultiLineTip();

	void Show(const CWnd* pClient, const CString& stHead, const CString& stTip, bool bBelowCursor = false, bool bAutoHide = true, int boldLines[] = NULL, int countBoldLines = 0);

	CFont  m_boldFont;
	CFont  m_Font;

    typedef void (*fnMouseMove)(CObject* pObj);
    void SetMouseMoveReceiver(CObject* pObj, fnMouseMove fn) 
    {
        m_pMouseMoveReceiver = pObj;
        m_fnMouseMove = fn;        
    }

private:

    const CWnd* m_pClient;
    bool m_bAutoHide;

    fnMouseMove m_fnMouseMove;
    CObject* m_pMouseMoveReceiver;


	void CreateFonts();
	void CalculateSize(int& nWidth, int& nHeight);
	
	CString	m_stHead;
	static CString m_stClassName;

	POINT  m_ptLT;
	int	   m_nLineHeight;
    int    m_nEmptyLineHeight;
	int	   m_nHeadHeight;

	struct LINE
	{
        LINE() : nOffset(0), isBold(false) {}
		CString stLeft;
		CString stRight;
		int nOffset;
        bool isBold;
	};

	typedef CArray<LINE, LINE&> CLines;

	CLines m_Lines;

public:
	//{{AFX_VIRTUAL(CMultiLineTip)
	//}}AFX_VIRTUAL

protected:
	//{{AFX_MSG(CMultiLineTip)
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnPaint();
	afx_msg void OnDestroy();
	afx_msg void OnSettingChange(UINT uFlags, LPCTSTR lpszSection);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


//{{AFX_INSERT_LOCATION}}

#endif // AFX_MULTILINETIP_H_
