// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// MessageView.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_MESSAGEVIEW_H_)
#define AFX_MESSAGEVIEW_H_

#if _MSC_VER > 1000
#pragma once
#endif 

#include "TextDisplay.h"
#include <afxdlgs.h>
#include <Afxcoll.h>
#include "ExtIcon.h"
#include "Attachment.h"

/////////////////////////////////////////////////////////////////////////////
// CMessageView 

#ifndef __AFXEXT_H__
#include <afxext.h>
#endif


class CMail;
class CPopManDoc;


class CMessageView : public CFormView
{
	friend class CMessageFrm;

protected:
	CMessageView();           
	DECLARE_DYNCREATE(CMessageView)

public:
	//{{AFX_DATA(CMessageView)
	enum { IDD = IDD_MESSAGE };
	CEdit	m_editTo;
	CEdit	m_editFrom;
	CEdit	m_editDate;
	CEdit	m_editSubject;
	CListCtrl	m_ListAttachments;
	//}}AFX_DATA

	BOOL m_bSmallHead;

public:
	BOOL DeleteMail(bool bShift);
	void ShowMail(CMail* pMail);

	//{{AFX_VIRTUAL(CMessageView)
	public:
	virtual void OnInitialUpdate();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);   
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

protected:
	void ArrangeAttachments();
	void InitGUIText();
	int GetMaxLabelWidth();
	BOOL CompleteAttachments();
	void ListAttachments();
	BOOL SaveAttachmentList(CAttachments& List);
	static BOOL SaveAttachment(LPCTSTR szFileName, const CAttachment* pAttachment);
	static BOOL IsAttachmentValid(const CAttachment* pAttachment);
	void ArrangeHeadControls();
	void MoveControl(int ID, int Left, int Top, int Width, int Height);
	void ArrangeTextBox(int cx, int cy);
	void UpdateAllViews();
	void UpdateDisplay(CFont* pFont, COLORREF TextColor);
	
	void SaveSettings();
	void LoadSettings();

    bool GetText(const CEdit& edit, CString& text);

	
	CPopManDoc* GetDocument() { return (CPopManDoc*)m_pDocument; }

	CMail*	m_pMail;

	static CPtrList m_List;
	
	CFont	  m_Font;
	CFont	  m_FontStatic;

	CTextDisplay m_TextBox;
	CExtIcon	 m_ExtIcon;
	CImageList	 m_ImageList;

	HICON m_hIconVirus;

	CFindReplaceDialog* m_pFindDlg;

	UINT m_bResetTimerID;
	bool m_bDelayReset;

	CString m_stFind;
	BOOL m_bMatchCase;
	BOOL m_bMatchWholeWord;
	BOOL m_bSearchDown;
	void FindText(CString stFind, BOOL bMatchCase, BOOL bMatchWholeWord, BOOL bSearchDown);

	int HeightFromPoints(int iPoints);
	int PointsFromHeight(int iHeight);

	virtual ~CMessageView();

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	//{{AFX_MSG(CMessageView)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnSelectAll();
	afx_msg void OnCopy();
	afx_msg void OnUpdateCopy(CCmdUI* pCmdUI);
	afx_msg void OnFont();
	afx_msg void OnDestroy();
	afx_msg void OnFontColor();
	afx_msg void OnPrintMessage();
	afx_msg void OnFind();
	afx_msg void OnFindNext();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSaveMail();
	afx_msg void OnUpdateSaveMail(CCmdUI* pCmdUI);
	afx_msg void OnOpenMail();
	afx_msg void OnUpdateOpenMail(CCmdUI* pCmdUI);
	afx_msg void OnMailSource();
	afx_msg void OnUpdateMailSource(CCmdUI* pCmdUI);
	afx_msg void OnViewExternally();
	afx_msg void OnUpdateViewExternally(CCmdUI* pCmdUI);
	afx_msg void OnReplyTo();
	afx_msg void OnUpdateReplyTo(CCmdUI* pCmdUI);
	afx_msg void OnPaint();
	afx_msg void OnRClickAttachments(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnUpdateAttachmentOpen(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAttachmentSave(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAttachmentSaveAll(CCmdUI* pCmdUI);
	afx_msg void OnAttachmentOpen();
	afx_msg void OnAttachmentSave();
	afx_msg void OnAttachmentSaveAll();
	afx_msg void OnDblclkListAttachments(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDeleteMail();
	afx_msg void OnUpdateDeleteMail(CCmdUI* pCmdUI);
	afx_msg void OnGotoNextTab();
	afx_msg void OnGotoPrevTab();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnDeleteShift();
	afx_msg void OnUnmarkDelete();
	afx_msg void OnRulesAddListitem();
	afx_msg void OnUpdateRulesAddListitem(CCmdUI* pCmdUI);
	//}}AFX_MSG
	afx_msg LRESULT OnFindDlgMessage(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
	
};

/////////////////////////////////////////////////////////////////////////////
//{{AFX_INSERT_LOCATION}}

#endif 
