// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// MessageFrm.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_MESSAGEFRM_H_)
#define AFX_MESSAGEFRM_H_


#if _MSC_VER > 1000
#pragma once
#endif 


class CPopManDoc;
class CMail;


/////////////////////////////////////////////////////////////////////////////
// CMessageFrm 

class CMessageFrm : public CFrameWnd
{
	DECLARE_DYNCREATE(CMessageFrm)

public:
	CMessageFrm() {};
	CMessageFrm(CPopManDoc* pDoc, CMail* pMail);

	//{{AFX_VIRTUAL(CMessageFrm)
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

protected:
	void InitGUIText();

	CString GetCommnadString(UINT nID) const;
	virtual ~CMessageFrm();
	
	CPopManDoc*	m_pDoc;
	CString		m_stAccName;

	CWnd* m_pViewWnd;

	BOOL LoadWindowSettings(BOOL& bMaximized, CRect& FrameRect);
	void SaveWindowSettings();

	CStatusBar  m_wndStatusBar;

	virtual void GetMessageString(UINT nID, CString& rMessage) const;

	//{{AFX_MSG(CMessageFrm)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnClose();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnDeleteMail();
	afx_msg void OnUpdateDeleteMail(CCmdUI* pCmdUI);
	afx_msg void OnDeleteShift();
	//}}AFX_MSG
	afx_msg void OnUpdateAccountPane(CCmdUI *pCmdUI);
	afx_msg BOOL OnToolTipText(UINT, NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg LRESULT OnUpdateGUI(WPARAM, LPARAM);

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}

#endif 
