// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// MessageFrm.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "PopMan.h"
#include "MessageFrm.h"
#include "MessageView.h"
#include "Mail.h"
#include "RegKey.h"
#include "PopManDoc.h"
#include "StrFunctions.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//  i18nComment("Message Window")

/////////////////////////////////////////////////////////////////////////////
// CMessageFrm

static UINT indicators[] =
{
	ID_SEPARATOR,
	ID_INDICATOR_ACCOUNT
};

IMPLEMENT_DYNCREATE(CMessageFrm, CFrameWnd)


CMessageFrm::CMessageFrm(CPopManDoc* pDoc, CMail* pMail)
{
	m_pDoc = pDoc;
	
	m_stAccName = pMail->GetAccount()->m_stName;

	LoadFrame(IDR_MESSAGE, WS_OVERLAPPEDWINDOW, NULL, NULL);

	SetWindowText(pMail->GetSubject());
	
	ASSERT(m_pViewWnd);
	
	CMessageView* pMsgView = (CMessageView*)m_pViewWnd;
	pMsgView->ShowMail(pMail);

	ShowWindow(SW_SHOW);
}

CMessageFrm::~CMessageFrm()
{
}


BEGIN_MESSAGE_MAP(CMessageFrm, CFrameWnd)
	//{{AFX_MSG_MAP(CMessageFrm)
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_WM_SIZE()
	ON_UPDATE_COMMAND_UI(ID_FILE_DELETE_THIS_MAIL, OnUpdateDeleteMail)
	ON_COMMAND(ID_FILE_DELETE_THIS_MAIL_SHIFT, OnDeleteShift)
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_MESSAGE_CLOSE, OnClose)
	ON_COMMAND(ID_FILE_DELETE_THIS_MAIL, OnDeleteMail)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_ACCOUNT, OnUpdateAccountPane)
	ON_NOTIFY_EX_RANGE(TTN_NEEDTEXTW, 0, 0xFFFF, OnToolTipText)
	ON_NOTIFY_EX_RANGE(TTN_NEEDTEXTA, 0, 0xFFFF, OnToolTipText)
	ON_MESSAGE(WM_UPDATE_GUI, OnUpdateGUI)
END_MESSAGE_MAP()


int CMessageFrm::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	SetIcon(CPopManApp::GetIcon(IDR_MESSAGE, CPopManApp::RESSIZE::Big), TRUE);
	SetIcon(CPopManApp::GetIcon(IDR_MESSAGE, CPopManApp::RESSIZE::Small), FALSE);

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators, sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Statusleiste konnte nicht erstellt werden\n");
		return -1;      
	}
	m_wndStatusBar.SetPaneStyle(0, SBPS_NORMAL | SBPS_STRETCH);

	CCreateContext* pContext = new CCreateContext;
	pContext->m_pNewViewClass = RUNTIME_CLASS(CMessageView);
	pContext->m_pCurrentDoc = m_pDoc;
	pContext->m_pNewDocTemplate = NULL;
	pContext->m_pLastView = NULL;
	pContext->m_pCurrentFrame = NULL;

	m_pViewWnd = CreateView(pContext);

	ASSERT(m_pViewWnd);
	SetActiveView((CView*)m_pViewWnd);

	delete pContext;

	InitGUIText();

	return 0;
}


BOOL CMessageFrm::PreCreateWindow(CREATESTRUCT& cs) 
{
	cs.lpszClass = AfxRegisterWndClass(NULL, NULL, NULL, AfxGetApp()->LoadIcon(IDR_MESSAGE));
	ASSERT(cs.lpszClass);

	CRect rect(0, 0, 0, 0);
	BOOL  bMaximized = FALSE;
	LoadWindowSettings(bMaximized, rect);
	
	if(bMaximized)
		cs.style |= WS_MAXIMIZE;

	if (rect.Width() > 0 && rect.Height() > 0)
	{
		RECT rcIS, rcScreen = {0, 0, ::GetSystemMetrics(SM_CXSCREEN), ::GetSystemMetrics(SM_CYSCREEN)};
		if(::IntersectRect(&rcIS, &rcScreen, &rect))
		{
			cs.x = rect.left;
			cs.y = rect.top;
			cs.cx = rect.Width();
			cs.cy = rect.Height();
		}
	}
 	
	return CFrameWnd::PreCreateWindow(cs);
}


void CMessageFrm::OnClose() 
{
	SaveWindowSettings();
	DestroyWindow();
}


void CMessageFrm::SaveWindowSettings()
{
	CSettingsKey Key;
	if(CreateSettingsKey(Key, szMsgWindowKey))
	{
		Key.SetValue(szWndMaximizedValue, IsZoomed());

		if(!IsZoomed() && !IsIconic() && IsWindowVisible())
		{
			RECT rect;
			GetWindowRect(&rect);

			Key.SetValue(szWndLeftValue,   rect.left);
			Key.SetValue(szWndTopValue,    rect.top);
			Key.SetValue(szWndWidthValue,  rect.right - rect.left);
			Key.SetValue(szWndHeightValue, rect.bottom - rect.top);
		}
	}
}

BOOL CMessageFrm::LoadWindowSettings(BOOL& bMaximized, CRect& FrameRect)
{
	CSettingsKey Key;
	if(!OpenSettingsKey(Key, szMsgWindowKey))
		return FALSE;

	if(!Key.QueryValue(szWndMaximizedValue, bMaximized))
		return FALSE;

	if(!Key.QueryValue(szWndLeftValue, FrameRect.left))
		return FALSE;

	if(!Key.QueryValue(szWndTopValue, FrameRect.top))
		return FALSE;
	
	DWORD dwValue = 0;

	if(!Key.QueryValue(szWndWidthValue, dwValue))
		return FALSE;
	FrameRect.right = FrameRect.left + dwValue;
		
	if(!Key.QueryValue(szWndHeightValue, dwValue))
		return FALSE;
	FrameRect.bottom = FrameRect.top + dwValue;

	return TRUE;
}


void CMessageFrm::OnSize(UINT nType, int cx, int cy) 
{
	CFrameWnd::OnSize(nType, cx, cy);

	CStatusBarCtrl& StatusCtrl = m_wndStatusBar.GetStatusBarCtrl();
	if(StatusCtrl.m_hWnd == NULL)
		return;

	CClientDC dc(&StatusCtrl);
	CFont *pOldFont = dc.SelectObject(StatusCtrl.GetFont());
	CSize Size = dc.GetTextExtent(m_stAccName);		
	int nMargin = dc.GetTextExtent(_T(' ')).cx * 2;	
	dc.SelectObject(pOldFont);


	UINT nID, nStyle;
	int cxWidth;

	m_wndStatusBar.GetPaneInfo(1, nID, nStyle, cxWidth);
	m_wndStatusBar.SetPaneInfo(1, nID, nStyle, Size.cx + 2 * nMargin);	
}


void CMessageFrm::OnUpdateAccountPane(CCmdUI *pCmdUI)
{
	pCmdUI->Enable(); 
	
	CString stAcc = _T('\t') + m_stAccName;
	pCmdUI->SetText(stAcc); 

	// "Bereit" entfernen:
	m_wndStatusBar.SetPaneText(0, _T(""));
}


void CMessageFrm::OnDeleteShift() 
{
	CMessageView* pMsgView = (CMessageView*)m_pViewWnd;

	if(pMsgView->DeleteMail(true))
		::SendMessage(GetSafeHwnd(), WM_CLOSE, 0, 0 );
}

void CMessageFrm::OnDeleteMail() 
{
	CMessageView* pMsgView = (CMessageView*)m_pViewWnd;

	bool bShift = (::GetKeyState(VK_SHIFT) & 0x8000) != 0;
	if(pMsgView->DeleteMail(bShift))
		::SendMessage(GetSafeHwnd(), WM_CLOSE, 0, 0 );
}

void CMessageFrm::OnUpdateDeleteMail(CCmdUI* pCmdUI) 
{
	CMessageView* pMsgView = (CMessageView*)m_pViewWnd;
	pMsgView->OnUpdateDeleteMail(pCmdUI);
}



static void MenuTextPos(CMenu* pMenu, int Pos, LPCTSTR szText)
{
	pMenu->ModifyMenu(Pos, MF_BYPOSITION|MF_STRING, Pos, szText);
}

static void MenuTextCmd(CMenu* pMenu, int Cmd, LPCTSTR szText)
{
	pMenu->ModifyMenu(Cmd, MF_BYCOMMAND|MF_STRING, Cmd, szText);
}

void CMessageFrm::InitGUIText()
{
	CMenu* pMenu = GetMenu();
	if(pMenu == NULL) return;

	MenuTextPos(pMenu, 0, i18n("&File"));
		MenuTextCmd(pMenu, ID_FILE_SAVE_MAIL,		i18n("&Save As...\tCtrl+S"));
		MenuTextCmd(pMenu, ID_FILE_PRINT,			i18n("&Print...\tCtrl+P"));
		MenuTextCmd(pMenu, ID_FILE_MAIL_SOURCE,		CString(i18n("Sou&rce...")) + _T("\tF10"));
		MenuTextCmd(pMenu, ID_FILE_VIEW_EXTERNALLY, CString(i18n("View E&xternally...")) + _T("\tF11"));
		MenuTextCmd(pMenu, ID_FILE_REPLY_TO,		i18n("Repl&y To Sender\tCtrl+R"));
		MenuTextCmd(pMenu, ID_FILE_DELETE_THIS_MAIL,i18n("&Delete\tDel"));
		MenuTextCmd(pMenu, ID_MESSAGE_CLOSE,		i18n("&Close\tEsc"));
	
	MenuTextPos(pMenu, 1, i18n("&Edit"));
		MenuTextCmd(pMenu, ID_EDIT_CUT,				i18n("&Cut\tCtrl+X"));
		MenuTextCmd(pMenu, ID_EDIT_COPY,			i18n("C&opy\tCtrl+C"));
		MenuTextCmd(pMenu, ID_EDIT_PASTE,			i18n("&Paste\tCtrl+V"));
		MenuTextCmd(pMenu, ID_EDIT_FIND,			i18n("&Find...\tCtrl+F"));
		MenuTextCmd(pMenu, ID_EDIT_FIND_NEXT,		i18n("Find &Next\tF3"));
		MenuTextCmd(pMenu, ID_EDIT_SELECT_ALL,		i18n("Select &All\tCtrl+A"));

	MenuTextPos(pMenu, 2, i18n("&Tools"));
		MenuTextCmd(pMenu, ID_EXTRAS_FONT,			i18n("&Font..."));
		MenuTextCmd(pMenu, ID_EXTRAS_FONT_COLOR,	i18n("Font &Color..."));
        MenuTextCmd(pMenu, ID_RULES_ADD_LISTITEM,	i18n("Add Item To Rules &List...\tF9"));
	
	DrawMenuBar();
}


void CMessageFrm::GetMessageString(UINT nID, CString& rMessage) const
{
	rMessage = GetCommnadString(nID);
	rMessage = Parse(rMessage, _T("\r\n"));
}

BOOL CMessageFrm::OnToolTipText(UINT, NMHDR* pNMHDR, LRESULT* pResult)
{

#ifndef _countof
#define _countof(array) (sizeof(array)/sizeof(array[0]))
#endif

	ASSERT(pNMHDR->code == TTN_NEEDTEXTA || pNMHDR->code == TTN_NEEDTEXTW);

	// need to handle both ANSI and UNICODE versions of the message
	TOOLTIPTEXTA* pTTTA = (TOOLTIPTEXTA*)pNMHDR;
	TOOLTIPTEXTW* pTTTW = (TOOLTIPTEXTW*)pNMHDR;

	CString strTipText;
	UINT nID = pNMHDR->idFrom;
	if (pNMHDR->code == TTN_NEEDTEXTA && (pTTTA->uFlags & TTF_IDISHWND) ||
		pNMHDR->code == TTN_NEEDTEXTW && (pTTTW->uFlags & TTF_IDISHWND))
	{
		// idFrom is actually the HWND of the tool
		nID = ((UINT)(WORD)::GetDlgCtrlID((HWND)nID));
	}

	if (nID != 0) // will be zero on a separator
	{
		strTipText = GetCommnadString(nID);
		Parse(strTipText, _T("\r\n"));
	}
#ifndef _UNICODE
	if (pNMHDR->code == TTN_NEEDTEXTA)
		lstrcpyn(pTTTA->szText, strTipText, _countof(pTTTA->szText));
	else
		_mbstowcsz(pTTTW->szText, strTipText, _countof(pTTTW->szText));
#else
	if (pNMHDR->code == TTN_NEEDTEXTA)
		_wcstombsz(pTTTA->szText, strTipText, _countof(pTTTA->szText));
	else
		lstrcpyn(pTTTW->szText, strTipText, _countof(pTTTW->szText));
#endif
	*pResult = 0;

	// bring the tooltip window above other popup windows
	::SetWindowPos(pNMHDR->hwndFrom, HWND_TOP, 0, 0, 0, 0, SWP_NOACTIVATE|SWP_NOSIZE|SWP_NOMOVE|SWP_NOOWNERZORDER);

	return TRUE;    // message was handled
}


CString CMessageFrm::GetCommnadString(UINT nID) const
{
	CString stMessage;

	switch(nID)
	{
	case ID_FILE_SAVE_MAIL:
		stMessage = i18n("Save selected email to file.\r\nSave");
		break;
	case ID_FILE_MAIL_SOURCE:
		stMessage = i18n("Show source code of this email.\r\nSource code");
		break;
	case ID_FILE_VIEW_EXTERNALLY:
		stMessage = i18n("Save this email to a temporary file with extension eml and open it.\r\nView externally");
		break;
	case ID_FILE_PRINT:
		stMessage = i18n("Print this email.\r\nPrint");
		break;
	case ID_FILE_REPLY_TO:
		stMessage = i18n("Create a reply message to the sender.\r\nReply");
		break;
	case ID_FILE_DELETE_THIS_MAIL:
		stMessage = i18n("Delete this email.\r\nDelete");
		break;
	case ID_MESSAGE_CLOSE:
		stMessage = i18n("Close window.\r\nClose");
		break;
	case ID_EDIT_CUT:
		stMessage = i18n("Cut the selection and put it on the Clipboard.\r\nCut");
		break;
	case ID_EDIT_COPY:
		stMessage = i18n("Copy the selection and put it on the Clipboard.\r\nCopy");
		break;
	case ID_EDIT_PASTE:
		stMessage = i18n("Insert Clipboard contents.\r\nPaste");
		break;
	case ID_EDIT_FIND:
		stMessage = i18n("Find the specified text.\r\nFind");
		break;
	case ID_EDIT_FIND_NEXT:
		stMessage = i18n("Find next occurence of specified text.\r\nFind next");
		break;
	case ID_EDIT_SELECT_ALL:
		stMessage = i18n("Select the entire message.\r\nSelect All");
		break;
	case ID_EXTRAS_FONT:
		stMessage = i18n("Change font.\r\nFont");
		break;
	case ID_EXTRAS_FONT_COLOR:
		stMessage = i18n("Change font color.\r\nFont Color");
		break;
    case ID_RULES_ADD_LISTITEM:
		stMessage = i18n("Add item to Rules list.\r\nAdd To List");
		break;
	case AFX_IDS_IDLEMESSAGE:
		stMessage = i18n("Ready");
		break;
	case AFX_IDS_SCSIZE:
		stMessage = i18n("Change the window size.");
		break;
	case AFX_IDS_SCMOVE:
		stMessage = i18n("Change the window position.");
		break;
	case AFX_IDS_SCMINIMIZE:
		stMessage = i18n("Reduce the window to an icon.");
		break;
	case AFX_IDS_SCMAXIMIZE:
		stMessage = i18n("Enlarge the window to full size.");
		break;
	case AFX_IDS_SCCLOSE:
		stMessage = i18n("Close the active window.");
		break;
	case AFX_IDS_SCRESTORE:
		stMessage = i18n("Restore the window to normal size.");
		break;
	default:
		//TRACE("nID = %d \n", nID);
		stMessage.Empty();
		break;
	}

	return stMessage;
}


LRESULT CMessageFrm::OnUpdateGUI(WPARAM, LPARAM)
{
	SetIcon(CPopManApp::GetIcon(IDR_MESSAGE, CPopManApp::RESSIZE::Big), TRUE);
	SetIcon(CPopManApp::GetIcon(IDR_MESSAGE, CPopManApp::RESSIZE::Small), FALSE);

	InitGUIText();
	SendMessageToDescendants(WM_COMMAND, ID_APP_UPDATE_GUI, 0);

	return 1;
}

