// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// MainFrm.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_MAINFRM_H_)
#define AFX_MAINFRM_H_

#if _MSC_VER > 1000
#pragma once
#endif 

#include "DlgSettings.h"
#include "ColorStatusBar.h"

#include "FixTB.h"

class CMessageView;
class CPopManView;

class CMainFrame : public CFrameWnd
{
	
protected: 
	CMainFrame();
	DECLARE_DYNCREATE(CMainFrame)

public:
	BOOL m_bPreview;
	CPropPage_Layout::PREVIEW_LAYOUT m_PreviewLayout;
	int m_nPaneSize;
	BOOL m_bXHide;
	BOOL m_bMinHide;

	void HideToTray();
	void RestoreFromTray();

	CColorStatusBar& GetStatusBar() { return m_wndStatusBar; }
	CMessageView* GetMessageView()  { return m_pMessageView; }
	//{{AFX_VIRTUAL(CMainFrame)
	public:
	virtual void ActivateFrame(int nCmdShow = -1);
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void PostNcDestroy();
	virtual BOOL OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext);
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	//}}AFX_VIRTUAL

private:
	CWnd* CreateSplitterWnd(BOOL bInitialUpdate, CCreateContext* pContext, BOOL bPreview, BOOL bBelow);
	static BOOL CALLBACK CloseWindow(HWND hWnd, LPARAM lParam);

protected:
	BOOL LoadWindowSettings(BOOL& bMaximized, CRect& FrameRect);
	void SaveWindowSettings();

	BOOL LoadBarSettings(BOOL& bStatusBar, BOOL& bToolBar);
	void SaveBarSettings();

	virtual void GetMessageString(UINT nID, CString& rMessage) const;
	
public:
	virtual ~CMainFrame();

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  
	CSplitterWnd	m_Splitter;
	CSplitterWnd*	m_pSplitter;
	CMessageView*	m_pMessageView;
	CColorStatusBar m_wndStatusBar;
	//CToolBar		m_wndToolBar;
    CFixMFCToolBar  m_wndToolBar;
	CFont			m_Font;
	CFont			m_FontTrash;

	int m_nSelectedMenuIdx;

	CImageList *normalImageList;
	CImageList *disabledImageList;

	bool m_bRepositionTrashButton;

	CButton m_ButtonTrash;

    BOOL m_bIsHiddenMaximized;

protected:
	void SetTrashButtonPos();
	void LoadToolbarBitmap(bool bSwitch);
	CPopManView* GetMainView();
	static void OnStatusBarDblClick(int nPane);
	void OnListAccount();
	CString GetCommnadString(UINT nID) const;
	void InitGUIText();
	void RecalcStatusBar();

    void RemoveMenu(CMenu* pMenu, unsigned int menuID);
    void InsertMenu(CMenu* pMenu, unsigned int menuID, bool bBefore, unsigned int menuIDReference, bool bSeparate);
	
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnClose();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnViewStatusBar();
	afx_msg void OnShowWindow();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnUpdateShowWindow(CCmdUI* pCmdUI);
	afx_msg void OnSettings();
	afx_msg void OnGotoNextPane();
	afx_msg void OnUpdateSettings(CCmdUI* pCmdUI);
	afx_msg void OnViewMultitab();
	afx_msg void OnUpdateViewMultitab(CCmdUI* pCmdUI);
	afx_msg void OnMenuSelect(UINT nItemID, UINT nFlags, HMENU hSysMenu);
	afx_msg void OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu);
	afx_msg void OnPaint();
	afx_msg void OnInitMenu(CMenu* pMenu);
	afx_msg void OnAppEscape();
	//}}AFX_MSG
	afx_msg BOOL OnQueryEndSession();
	afx_msg BOOL OnToolTipText(UINT, NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg LRESULT OnAreYouMe(WPARAM, LPARAM);
	afx_msg LRESULT OnUpdateGUI(WPARAM, LPARAM);
	afx_msg void OnCheckTab();
	afx_msg void OnSelectTheme();

	afx_msg LRESULT OnPowerBroadcast(WPARAM, LPARAM);
	afx_msg LRESULT OnMailMarkedForDelete(WPARAM, LPARAM);

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}

#endif // !defined(AFX_MAINFRM_H_)
