// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// MailList.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_MAILLIST_H_)
#define AFX_MAILLIST_H_

#if _MSC_VER > 1000
#pragma once
#endif 

#include "Account.h"
#include "SortedHeaderCtrl.h"
#include "MultiLineTip.h"

class CPopManDoc;


class CMailList : public CListCtrl
{
public:
	CMailList();

	CAccounts* m_pAccounts;

	CMail* m_prevMail;

    BOOL m_bShowMarkedMail;
    BOOL m_bShowUnmarkedMail;

public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	CPopManDoc* GetDocument() { ASSERT(m_pDoc); return m_pDoc; };
	void SetDocument(CPopManDoc* pDoc) { m_pDoc = pDoc; };

	void Refresh(BOOL bRetainSelectedMail = FALSE);
	void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	void OnInitialUpdate(const CSettingsKey& settings);
	void SaveSettings(CSettingsKey& settings) const;
	
	//{{AFX_VIRTUAL(CMailList)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

public:
	void OnMailMarkedChange();
	void SetFont(CFont* pFont, BOOL bRedraw = TRUE);
	int SelectMail(const CMail* pMail);
    void SelectItem(int idx);
	CMail* GetDisplayedMail() const;
    CMail* GetSelectedMail() const;
    int GetSelectedItem() const;
	BOOL DeleteAllItems();
	void SetTopIndex(int nItem);
	virtual ~CMailList()  { }

protected:
	void DoDeleteMails(bool bShift);   
	
	CPopManDoc* m_pDoc;

	void InitGUIText();
	
	void UpdateColumnsText();
	static CString GetFormatedDate(COleDateTime tmDate) { return tmDate.Format(_T("%c")); };

	void SetMailInMessageView(CMail* pMail);
	void UpdateSortIndicator();

	enum COLUMNS
	{	
		colFrom		 =  0,
		colSubject	 =  1,
		colSize		 =  2,
		colTo		 =  3,
		colReceived  =  4,
		colAccount	 =  5,
		colAttach    =  6,
		colSent		 =  7,
		colPriority  =  8,
		colUserAgent =  9,
        colRules =  10,
		colSender = 11,
		colFromComplete = 12
	};

	static BOOL    IndexFromID(COLUMNS nID, int& nIndex);
	static COLUMNS GetIDFromIndex(int nIndex);

	void OnColumnSelect();
	int  AddColumn(LPCTSTR szCaption, int nWidth, int nAlign);
	void AddRow(const CMail* pMail, BOOL bSorted = TRUE);

	static int CALLBACK CompareFunc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort);
	
	struct COLUMN {
		COLUMNS colID;			 // ID
		int     nOrderIndex;	 // the index to access this column
		UINT    nWidth;			 // width of the column
		LPCTSTR szCaption;		 // caption
		LPCTSTR szCaptionMenu;	 // caption in menu
		bool	bCaptionInHeader;// Use caption in header or just in the context menu
		LPCTSTR szKey;			 // reg key that is used to save column settings
		DWORD   dwAlign;		 // alignment of caption 
		int		nCmdID;			 // command ID of the column used in the context menu
	};

	static COLUMN Columns[];
	
	
	BOOL IsOneMailSelected();
	BOOL IsDeleteMailsEnabled();
	BOOL IsSaveMailEnabled();

    
    BOOL ShowUnmarkedMails() const { return m_bShowUnmarkedMail;  }
    BOOL ShowMarkedMails() const   { return m_bShowMarkedMail; }
    BOOL ShowMail(const CMail& Mail) const 
    {
        if(Mail.IsMarkedForDelete())
            return ShowMarkedMails();
        else
            return ShowUnmarkedMails();
    }

    typedef BOOL (*fnMailPredicate)(const CMail& mail);

    int CountMailsInList(fnMailPredicate predicate) const;
    int CountMailsInAccounts(fnMailPredicate predicate) const;

    int RemoveMailsFromList(fnMailPredicate predicate);
    
private:
	static void OnTipMouseMove(CObject* pThis);

    bool IsOnNonEmptyRulesSubItem(CPoint point, CMail*& pMail);
    void ShowRulesTip(const CMail* pMail);

    bool m_bDisableRedraw;
	int  m_IDSortColumn;
	BOOL m_bSortAscending;
	
	CSortedHeaderCtrl  m_Header;

	CFont m_BoldFont;
	CFont m_StrikeFont;
	CFont m_BoldStrikeFont;

    const CMail* m_pLastTooltipMail;
    CMultiLineTip m_RulesTip;
    bool m_bTimerRulesTip;
 
	HICON m_hClip;

	//{{AFX_MSG(CMailList)
	afx_msg void OnCustomDraw(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDeleteMails();
	afx_msg void OnUpdateDeleteMails(CCmdUI* pCmdUI);
	afx_msg void OnSelectAll();
	afx_msg void OnSaveMail();
	afx_msg void OnUpdateSaveMail(CCmdUI* pCmdUI);
	
	afx_msg void OnViewMailExternally();
	afx_msg void OnUpdateViewMailExternally(CCmdUI* pCmdUI);

	afx_msg void OnColumnClick(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnMailSource();
	afx_msg void OnUpdateMailSource(CCmdUI* pCmdUI);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnView();
	afx_msg void OnUpdateView(CCmdUI* pCmdUI);
	afx_msg void OnDblclk(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnReturn(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnReplyTo();
	afx_msg void OnUpdateReplyTo(CCmdUI* pCmdUI);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnBlockSender();
	afx_msg void OnUpdateBlockSender(CCmdUI* pCmdUI);
	afx_msg void OnItemChanged(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg UINT OnGetDlgCode();
	afx_msg void OnDeleteMailsShift();
	afx_msg void OnDeleteUnmark();
	afx_msg void OnUpdateDeleteUnmark(CCmdUI* pCmdUI);
	afx_msg void OnRulesAddListitem();
	afx_msg void OnUpdateRulesAddListitem(CCmdUI* pCmdUI);
	afx_msg void OnWindowPosChanging(WINDOWPOS FAR* lpwndpos);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnUpdateTrustSender(CCmdUI* pCmdUI);
	afx_msg void OnTrustSender();
	afx_msg void OnProtectMessage();
	//}}AFX_MSG
	afx_msg  void OnUpdateGUI();

    afx_msg void OnMarkAllRead();
    afx_msg void OnUpdateMarkAllRead(CCmdUI* pCmdUI);
    afx_msg void OnMarkAllUnread();
    afx_msg void OnUpdateMarkAllUnread(CCmdUI* pCmdUI);
    

	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnMarkAsSeenOnServer();
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}

#endif // AFX_MAILLIST_H_
