//////////////////////////////////////////////////////////////////////
// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// MailAddressFilterList.h
//
////////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAILADDRESSFILTERLIST_H_)
#define AFX_MAILADDRESSFILTERLIST_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


class CMailAddressFilterList  
{
public:
    CMailAddressFilterList() {}
    virtual ~CMailAddressFilterList() {}

	bool Contains(const CString& stAddress) const;
	bool AddAddress(const CString& stAddress);
    bool AddDomain(const CString& stDomain);
	void Save();
	void Load(LPCTSTR szFile);

    const CStringArray& GetAddresses() const { return m_AddressList; }
    const CStringArray& GetDomains()   const { return m_DomainList; }

    void SetAddresses(const CStringArray& newAddresses);
    void SetDomains(const CStringArray& newDomains);

private:
    CString m_stFile;
    CStringArray m_AddressList;
	CStringArray m_DomainList;
};

#endif // !defined(AFX_MAILADDRESSFILTERLIST_H_)
