//////////////////////////////////////////////////////////////////////
// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// MailAddressFilterList.cpp
//
////////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MailAddressFilterList.h"
#include "StrFunctions.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

void BubbleSort(CStringArray& array);
int BinarySearch(const CStringArray& array, const CString& item, int* pInsertAt = NULL);

void CMailAddressFilterList::Load(LPCTSTR szFile)
{
    m_stFile = szFile;

	try 
	{
		CStdioFile File(szFile, CFile::modeRead);
		CString stLine;

		m_AddressList.SetSize(0, static_cast<unsigned int>(File.GetLength()) / 16);
		while(File.ReadString(stLine)) 
		{
			stLine.TrimLeft();
			stLine.TrimRight();
			if(stLine.IsEmpty()) continue;

			if(stLine.Find(_T('@')) > 0)
				m_AddressList.Add(stLine); 
			else
				m_DomainList.Add(stLine); 

		}
		File.Close();

		BubbleSort(m_AddressList);
	    BubbleSort(m_DomainList);
	}
	catch(CFileException* e)
	{
		if(e->m_cause != CFileException::fileNotFound)
			e->ReportError();

		e->Delete();
	}
}

void CMailAddressFilterList::Save()
{
    if(m_stFile.IsEmpty()) return;

	try 
	{
		CFile File(m_stFile, CFile::modeCreate | CFile::modeWrite);
				
		USES_CONVERSION;
        int i;
		for(i = 0; i < m_AddressList.GetSize(); ++i) 
		{
			const CString& stData = m_AddressList[i];
			File.Write(T2A((LPTSTR)(LPCTSTR)stData), stData.GetLength());
			File.Write("\r\n", 2);
		}
		for(i = 0; i < m_DomainList.GetSize(); ++i) 
		{
			const CString& stData = m_DomainList[i];
			File.Write(T2A((LPTSTR)(LPCTSTR)stData), stData.GetLength());
			File.Write("\r\n", 2);
		}
		File.Close();
	}
	catch(CFileException* e)
	{
		e->ReportError();
		e->Delete();
	}
}

bool CMailAddressFilterList::AddAddress(const CString& stAddress)
{
	if(stAddress.Find(_T('@')) < 1) return false;
    int insertNew = 0;
	if(BinarySearch(m_AddressList, stAddress, &insertNew) > -1) return false;

    m_AddressList.InsertAt(insertNew, stAddress);
    return true;
}

bool CMailAddressFilterList::AddDomain(const CString& stDomain)
{
	if(stDomain.Find(_T('@')) > -1) return false;
    int insertNew = 0;
	if(BinarySearch(m_DomainList, stDomain, &insertNew) > -1) return false;

    m_DomainList.InsertAt(insertNew, stDomain);
    return true;
}

bool CMailAddressFilterList::Contains(const CString& stAddress) const
{
    int idx = stAddress.Find(_T('@'));
	if(idx <= 0 || idx >= stAddress.GetLength()-1) return false;
	
	if(BinarySearch(m_AddressList, stAddress) > -1)
		return true;
	
	const CString domain = stAddress.Mid(idx+1);
    const int lenDomain = domain.GetLength();

//	if(BinarySearch(m_DomainList, domain) > -1)
//		return true;

    for(int i = 0; i < m_DomainList.GetSize(); ++i) 
    {
        const CString& listedDomain = m_DomainList[i];
        const int lenListedDomain = listedDomain.GetLength();

        if(lenDomain >= lenListedDomain) 
        {
            if(domain.CompareNoCase(listedDomain) == 0)
                return true;

            if(lenDomain > lenListedDomain) 
            {
                const int postfixStart = lenDomain - lenListedDomain;
                if(postfixStart == FindNoCase(domain, listedDomain, postfixStart)) 
                {
                    if(domain[postfixStart-1] == _T('.'))
                        return true;
                }
            }
        }
    }
    return false;
}

void CMailAddressFilterList::SetAddresses(const CStringArray& newAddresses)
{
    m_AddressList.RemoveAll();
    m_AddressList.Append(newAddresses);
    BubbleSort(m_AddressList);
}

void CMailAddressFilterList::SetDomains(const CStringArray& newDomains)
{
    m_DomainList.RemoveAll();
    m_DomainList.Append(newDomains);
    BubbleSort(m_DomainList);
}

void BubbleSort(CStringArray& array)
{
	int idxEnd = array.GetSize() - 1;
	int left = 0;
	bool bSwapped = true;

    CString swap;

	while(bSwapped) 
	{
		bSwapped = false;
		for(int i = idxEnd; i > left; --i) 
		{
			if(array[i-1].CompareNoCase(array[i]) > 0)
			{			
				swap = array[i];
				array[i] = array[i-1];
				array[i-1] = swap;
				bSwapped = true;
			}
 		}
		++left;
	}
}

int BinarySearch(const CStringArray& array, const CString& item, int* pInsertAt)
{
    if(array.GetSize() == 0) 
    {
        if(pInsertAt) *pInsertAt = 0;
        return -1;
    }

	int left  = 0;
	int right = array.GetSize()-1;

	while(true)
	{
		int mid = (left + right) / 2;
		int cmp = item.CompareNoCase(array[mid]);
		if(cmp == 0) return mid;
        if(left >= right) 
        {
            if(pInsertAt) 
                *pInsertAt = (cmp < 0 ? mid : mid+1);
            return -1;
        }
		if(cmp < 0) 
			right = mid - 1;
		else
			left = mid + 1;
	} 
}
