// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// Mail.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_MAIL_H_)
#define AFX_MAIL_H_

#if _MSC_VER > 1000
#pragma once
#endif


#include <afxtempl.h>
#include "Attachment.h"
#include "HtmlConvert.h"

class CAccount;
class CMail;


class CMails : public CTypedPtrList<CPtrList, CMail*>
{
public:

	CMails& operator=(const CMails& mails) 
	{
		if(this == &mails) return *this;
		RemoveAll();
		POSITION pos = mails.GetHeadPosition();
		while(pos != NULL)
			AddTail(mails.GetNext(pos));
		return *this;
	}

	int GetIdxByMail(const CMail* pMail)
	{
		int nIdx = 0;

		POSITION pos = GetHeadPosition();
		while(pos != NULL)
		{
			if(pMail == GetNext(pos))
				return nIdx;

			nIdx++;
		}		

		return -1;
	}

};


class CMail : public CObject  
{
	friend class CAccount;

public:
			
	CMail(CAccount* pAcc) { 
		m_pAccount = pAcc; 
		m_bCustomColor = FALSE;
		m_CustomColor = 0;
		TRACE1("CMail: %X\n", (int)this);
	}

	virtual ~CMail();

	BOOL Init(const CString& stSource, int nSize, const CString& stUIDL, BOOL bComplete);

	const CString& GetSubject() const		{ return m_stSubject; }
   	void SetSubject(const CString& stNewSubject);

	const CString& GetTo() const			{ return m_stTo; }
	const CString& GetFrom() const			{ return m_stFrom; }
	const CString& GetFromAddress() const	{ return m_stFromAddress; }
	const CString& GetFromComplete() const  { return m_stFromComplete; }
	const CString& GetUIDL() const			{ return m_stUIDL; }
	const CString& GetSource() const		{ return m_stSource; }
	const CString& GetPlainText() const		{ return m_stPlainText; }
	const CString& GetHtml() const			{ return m_stHtml; }
	const CString& GetSizeFormated() const  { return m_stSizeFormated; }
	const CString& GetHeader() const		{ return m_stHeader; }
	const CString& GetReplyTo() const		{ return m_stReplyTo; }
	const CString& GetExtractedMsg() const;
    const CString& GetEntireFrom() const;

    const std::vector<LinkInfo>& GetHtmlLinks() const { return m_HtmlLinks; }

	CString GetQuottedMsg() const;
	CString GetTextMail() const;

	BOOL CompleteSource(const CString& stSource);

	const CString& GetSignature() const;			
		
	UINT		 GetSize() const			{ return m_nSize; }
	COleDateTime GetDate() const			{ return m_tmDate; }
	COleDateTime GetReceived() const		{ return m_tmReceived; }
	CAccount*	 GetAccount() const			{ return m_pAccount; }
	BOOL IsComplete() const					{ return m_bComplete; }

	enum MailPriority {
		Low     = 1,
		Normal  = 2,
		High    = 3,
	};
	MailPriority GetPriority() const		{ return m_Priority; }
	const CString& GetUserAgent() const		{ return m_stUserAgent; }
	
	BOOL IsRead() const						{ return m_bRead; }
	void SetRead(BOOL bRead = TRUE);	

	BOOL IsMarkedForDelete() const			{ return m_bMarkedForDelete; }
	void SetMarkedForDelete(BOOL bMark = TRUE, BOOL bSurpressEvents = FALSE);

	CAttachments m_Attachments;

	static int getNumberOfMarkedMessages() { return nMarkedMessages; }

	static BOOL IsMessageTextComplete(const CString& Src);
	static BOOL CompareHeaders(const CString& stHeaderA, const CString& stHeaderB, BOOL bStrict = TRUE);
	static BOOL HeadersMayEqual(const CString& stHeaderA, const CString& stHeaderB);

	CString GetProperty(LPCTSTR szProperty, bool bISODecoded = false) const;

    struct RuleInfo {
        RuleInfo()  {}
        RuleInfo(CString name, CString info, CString actions) : Name(name), Info(info), Actions(actions) {}
        CString Name;
        CString Info;
        CString Actions;
    };

    CList<RuleInfo, const RuleInfo&> m_RuleInfos;

    const CString& GetRules() const;

	BOOL GetAlwaysProtected() const { return m_bAlwaysProtected; }
	void SetAlwaysProtected(BOOL val);

	BOOL	 m_bCustomColor;
	COLORREF m_CustomColor;

protected:
	void AddAttachment(const CString& stFileName, int nSrcIdx, int nAttachmentIdx);
	void ClearAttachments();
    static CString GetTextFromHTML(const CString& stHTML, std::vector<LinkInfo>* pLinks = NULL);
	static BOOL IsValidTextContent(const CString& stText);
	static CString GetPropertyFromSrc(const CString& stSrc, LPCTSTR szProperty);
	void ParseContentType(const CString& stHead, BOOL& bImageOrText, CString& stName);
	BOOL ParseContentDisposition(CString stHead, BOOL& bAttachment, CString& stFileName);
	CString GetPartHead(const CString& stSource, int nTypeStart);
	void ExtractAttachments(BOOL bClearAttachments);
	void ExtractMessageText();
	
	BOOL ParseMailSource(BOOL bResetContent = TRUE);
	
	CAccount* m_pAccount;
	
	BOOL	 m_bComplete;
	BOOL	 m_bRead;
	BOOL	 m_bMarkedForDelete;

	CString  m_stSubject;
	CString  m_stTo;
	CString  m_stFrom;
	CString  m_stFromAddress;
	CString  m_stFromComplete;
	CString  m_stUIDL;
	CString  m_stSource;
	CString  m_stPlainText;
	CString  m_stHtml;
	CString  m_stSizeFormated;
	CString  m_stSize;
	CString  m_stHeader;
	UINT	 m_nSize;
	COleDateTime m_tmDate;
	COleDateTime m_tmReceived;
	CString  m_stReplyTo;
	mutable CString  m_stExtractedMsg;
    mutable CString  m_stEntireFrom;
    mutable CString  m_stRules;
    mutable std::vector<LinkInfo> m_HtmlLinks;
	CString  m_stSignature;
	MailPriority m_Priority;
	CString m_stUserAgent;
	BOOL m_bAlwaysProtected;

	enum ENCODING_TYPE
	{
		enNone,
		enBase64,
		enQuotedPrintable,
	};

	static int nMarkedMessages;

private:

	COleDateTime FormatDate(CString Src);
	static int CheckMailChar(TCHAR s);
	static CString ExtractMail(const CString& Src);
	static CString GetItem(const CString& Src, LPCTSTR Search, int nStart = 0, int* pIdxFound = NULL);
	static CString ISODecode(const CString& Src);
	static CString ExtractNames(CString Src);
	static CString GetNextPart(CString& Src);
	static CString GetQuotation(const CString& Src);
	static CString RemoveMail(const CString& Src);
	static ENCODING_TYPE GetEncodingType(const CString& stEncoding, int startPos);
	static CString DecodeString(const CString& stMsgText, ENCODING_TYPE Encoding);
	static CString ExtractBoundary(CString stStr);
};



#endif // !defined(AFX_MAIL_H_)
