// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// LogFile.h
//
////////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_LOGFILE_H_)
#define AFX_LOGFILE_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CLogFile  
{
public:
    CLogFile() : m_nMaxSize(250*1024), m_bEnabled(false) {}

    void Init(LPCTSTR szFile) 
    {
        m_stFile = szFile;
    }

	virtual ~CLogFile();

    void Log(LPCTSTR szLog);
    void Log(const void* pData, int nDataLen);

    void SetMaxSize(int size) { m_nMaxSize = size; }
    int  GetMaxSize() const   { return m_nMaxSize; }

    void SetEnabled(bool enable) { m_bEnabled= enable; }
    bool IsEnabled() const { return m_bEnabled; }

    // char* GetCopyOfContent(unsigned int&  nSize);



    void Close();

private:
    bool OpenLogFile();

    unsigned int m_nMaxSize;
    bool m_bEnabled;
    CFile m_LogFile;
    CString m_stFile;
};

#endif // !defined(AFX_LOGFILE_H_)
