// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// LogFile.cpp
//
////////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "LogFile.h"
#include "StrFunctions.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////

CLogFile::~CLogFile()
{
    Close();
}

void CLogFile::Close()
{
    if(m_LogFile.m_hFile != CFile::hFileNull)
        m_LogFile.Close();
}

bool CLogFile::OpenLogFile()
{
    //CString stFileName;
	//stFileName = m_stAppDataPath + szLogFile;

	if(!m_LogFile.Open(m_stFile, CFile::shareDenyNone | CFile::modeReadWrite | CFile::modeCreate | CFile::modeNoTruncate))
	{
		m_bEnabled = false;

		CString stErr = StrFormat(i18n("The log file \"{1}\" could not be opened.\r\nLogging disabled!"), _T("s"), (LPCTSTR)m_stFile);
		AfxMessageBox(stErr);
		return false;
	}

	return true;
}


void CLogFile::Log(LPCTSTR szLog)
{
	USES_CONVERSION;

	LPCSTR szData = T2A((LPTSTR)szLog);

	Log(szData, strlen(szData) );
}

void CLogFile::Log(const void* pData, int nDataLen)
{
	if(!m_bEnabled) return;
	
	try
	{
		if(m_LogFile.m_hFile == CFile::hFileNull)
			if(!OpenLogFile())
				return;

        unsigned int nFileSize = static_cast<unsigned int>(m_LogFile.SeekToEnd());

		if(nFileSize + nDataLen > m_nMaxSize)
		{
			int nSaveIdx = int(m_nMaxSize / 2);
			m_LogFile.Seek(nSaveIdx, CFile::begin);
			int nSaveSize = nFileSize - nSaveIdx;

			char* pBuffer = new char[nSaveSize];

			m_LogFile.Read(pBuffer, nSaveSize);



            const char* pFindBlankLine = pBuffer;

            int countLBs = 0;
            while(*pFindBlankLine && countLBs < 2)
            {
                char c = *pFindBlankLine++;
                
                if(c == '\n')
                    ++countLBs;
                else if(c != '\r' && c != ' ' && c != '\t')
                    countLBs = 0;
            }

            unsigned int offset = (pFindBlankLine-pBuffer);
            if(offset > 2*1024) {
                offset = 0;
                pFindBlankLine = pBuffer;
            }

			m_LogFile.SetLength(nSaveSize-offset);
			m_LogFile.SeekToBegin();
			m_LogFile.Write(pFindBlankLine, nSaveSize-offset);
			m_LogFile.SeekToEnd();

			delete [] pBuffer;
		}

		m_LogFile.Write(pData, nDataLen); 

	}
	catch(CFileException* e)
	{			
		TCHAR buffer[512];
		e->GetErrorMessage(buffer, 512, NULL);
		CString stErr = i18n("Error while writing to the log file:");
		stErr += _T("\r\n\"");
		stErr += buffer;
		stErr += _T("\"\r\n\r\n");
		stErr += i18n("Logging disabled!");

		AfxMessageBox(stErr);

		m_bEnabled = false;

		e->Delete();
	}
}

/*
char* CLogFile::GetCopyOfContent(unsigned int&  nSize)
{
    nSize = 0;

    if(m_LogFile.m_hFile == CFile::hFileNull)
        if(!OpenLogFile())
		    return NULL;

    unsigned int nFileLen = static_cast<unsigned int>(m_LogFile.GetLength());
	m_LogFile.SeekToBegin();
	char* pBuf = new char[nFileLen+1];
	m_LogFile.Read(pBuf, nFileLen);
    pBuf[nFileLen] = '\0';
    nSize = nFileLen;

    return pBuf;
}
*/