// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// HtmlConvert.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(_HtmlConvert_H_)
#define _HtmlConvert_H_

#if _MSC_VER > 1000
#pragma once
#endif

#include <vector>

#ifdef UNICODE
#define HTMLToText  HTMLToTextW
#else
#define HTMLToText HTMLToTextA
#endif // !UNICODE 

struct LinkInfo {
    unsigned int idxStart;
    unsigned int len;
    LPCTSTR szLink;
};


BOOL WINAPI HTMLToTextW(LPCWSTR szHTML, LPWSTR szText, BOOL bPreferASCII, LPWSTR szCharset, int nCharsetLen, UINT* pCodePage, std::vector<LinkInfo>* pLinks = NULL);
BOOL WINAPI HTMLToTextA(LPCSTR  szHTML, LPSTR  szText, BOOL bPreferASCII, LPSTR szCharset,  int nCharsetLen, UINT* pCodePage, std::vector<LinkInfo>* pLinks = NULL);


#endif


