﻿// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hübner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// HtmlConvert.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "StdAfx.h"
#include "HtmlConvert.h"


enum TAGS {
	tgUnknown,
	tgBr,
    tgA_S, tgA_E,
	tgPara_S, tgPara_E,
	tgDiv_S, tgDiv_E,
	tgBlockquote_S, tgBlockquote_E,
	tgTable_S, tgTable_E,
	tgTr_S,	tgTr_E,
	tgTd_S,	tgTd_E,
	tgTh_S,	tgTh_E,
	tgOl_S,	tgOl_E,
	tgUl_S,	tgUl_E,
	tgLi_S,	tgLi_E,
	tgH_S, tgH_E,
	tgPre_S, tgPre_E,
	tgSpan_S, tgSpan_E,
	tgTitle_S, 
	tgStyle_S, 
	tgOption_S,
	tgXml_S,
	tgScript_S,
	tgIfFields_S,
	tgIfSupportLists_S
};

#include <unordered_map>
#include <string>

static const std::unordered_map<std::wstring, WCHAR> Entities = {
	{ _T("aacute"),                0x000E1 },
	{ _T("Aacute"),                0x000C1 },
	{ _T("abreve"),                0x00103 },
	{ _T("Abreve"),                0x00102 },
	{ _T("ac"),                    0x0223E },
	{ _T("acd"),                   0x0223F },
	{ _T("acirc"),                 0x000E2 },
	{ _T("Acirc"),                 0x000C2 },
	{ _T("acute"),                 0x000B4 },
	{ _T("acy"),                   0x00430 },
	{ _T("Acy"),                   0x00410 },
	{ _T("aelig"),                 0x000E6 },
	{ _T("AElig"),                 0x000C6 },
	{ _T("agrave"),                0x000E0 },
	{ _T("Agrave"),                0x000C0 },
	{ _T("alefsym"),               0x02135 },
	{ _T("alpha"),                 0x003B1 },
	{ _T("Alpha"),                 0x00391 },
	{ _T("amacr"),                 0x00101 },
	{ _T("Amacr"),                 0x00100 },
	{ _T("amalg"),                 0x02A3F },
	{ _T("amp"),                   0x00026 },
	{ _T("and"),                   0x02227 },
	{ _T("And"),                   0x02A53 },
	{ _T("andand"),                0x02A55 },
	{ _T("andd"),                  0x02A5C },
	{ _T("andslope"),              0x02A58 },
	{ _T("andv"),                  0x02A5A },
	{ _T("ang"),                   0x02220 },
	{ _T("ange"),                  0x029A4 },
	{ _T("angmsd"),                0x02221 },
	{ _T("angmsdaa"),              0x029A8 },
	{ _T("angmsdab"),              0x029A9 },
	{ _T("angmsdac"),              0x029AA },
	{ _T("angmsdad"),              0x029AB },
	{ _T("angmsdae"),              0x029AC },
	{ _T("angmsdaf"),              0x029AD },
	{ _T("angmsdag"),              0x029AE },
	{ _T("angmsdah"),              0x029AF },
	{ _T("angrt"),                 0x0221F },
	{ _T("angrtvb"),               0x022BE },
	{ _T("angrtvbd"),              0x0299D },
	{ _T("angsph"),                0x02222 },
	{ _T("angst"),                 0x0212B },
	{ _T("angzarr"),               0x0237C },
	{ _T("aogon"),                 0x00105 },
	{ _T("Aogon"),                 0x00104 },
	{ _T("apacir"),                0x02A6F },
	{ _T("ape"),                   0x0224A },
	{ _T("apE"),                   0x02A70 },
	{ _T("apid"),                  0x0224B },
	{ _T("apos"),                  0x00027 },
	{ _T("ApplyFunction"),         0x02061 },
	{ _T("aring"),                 0x000E5 },
	{ _T("Aring"),                 0x000C5 },
	{ _T("ast"),                   0x0002A },
	{ _T("asymp"),                 0x02248 },
	{ _T("asympeq"),               0x0224D },
	{ _T("atilde"),                0x000E3 },
	{ _T("Atilde"),                0x000C3 },
	{ _T("auml"),                  0x000E4 },
	{ _T("Auml"),                  0x000C4 },
	{ _T("awconint"),              0x02233 },
	{ _T("awint"),                 0x02A11 },
	{ _T("Barv"),                  0x02AE7 },
	{ _T("barvee"),                0x022BD },
	{ _T("barwed"),                0x02305 },
	{ _T("Barwed"),                0x02306 },
	{ _T("bbrk"),                  0x023B5 },
	{ _T("bbrktbrk"),              0x023B6 },
	{ _T("bcong"),                 0x0224C },
	{ _T("bcy"),                   0x00431 },
	{ _T("Bcy"),                   0x00411 },
	{ _T("becaus"),                0x02235 },
	{ _T("bemptyv"),               0x029B0 },
	{ _T("bepsi"),                 0x003F6 },
	{ _T("bernou"),                0x0212C },
	{ _T("beta"),                  0x003B2 },
	{ _T("Beta"),                  0x00392 },
	{ _T("beth"),                  0x02136 },
	{ _T("blank"),                 0x02423 },
	{ _T("blk12"),                 0x02592 },
	{ _T("blk14"),                 0x02591 },
	{ _T("blk34"),                 0x02593 },
	{ _T("block"),                 0x02588 },
	{ _T("bnot"),                  0x02310 },
	{ _T("bNot"),                  0x02AED },
	{ _T("bottom"),                0x022A5 },
	{ _T("bowtie"),                0x022C8 },
	{ _T("boxbox"),                0x029C9 },
	{ _T("boxdl"),                 0x02510 },
	{ _T("boxdL"),                 0x02555 },
	{ _T("boxDl"),                 0x02556 },
	{ _T("boxDL"),                 0x02557 },
	{ _T("boxdr"),                 0x0250C },
	{ _T("boxdR"),                 0x02552 },
	{ _T("boxDr"),                 0x02553 },
	{ _T("boxDR"),                 0x02554 },
	{ _T("boxh"),                  0x02500 },
	{ _T("boxH"),                  0x02550 },
	{ _T("boxhd"),                 0x0252C },
	{ _T("boxhD"),                 0x02565 },
	{ _T("boxHd"),                 0x02564 },
	{ _T("boxHD"),                 0x02566 },
	{ _T("boxhu"),                 0x02534 },
	{ _T("boxhU"),                 0x02568 },
	{ _T("boxHu"),                 0x02567 },
	{ _T("boxHU"),                 0x02569 },
	{ _T("boxul"),                 0x02518 },
	{ _T("boxuL"),                 0x0255B },
	{ _T("boxUl"),                 0x0255C },
	{ _T("boxUL"),                 0x0255D },
	{ _T("boxur"),                 0x02514 },
	{ _T("boxuR"),                 0x02558 },
	{ _T("boxUr"),                 0x02559 },
	{ _T("boxUR"),                 0x0255A },
	{ _T("boxv"),                  0x02502 },
	{ _T("boxV"),                  0x02551 },
	{ _T("boxvh"),                 0x0253C },
	{ _T("boxvH"),                 0x0256A },
	{ _T("boxVh"),                 0x0256B },
	{ _T("boxVH"),                 0x0256C },
	{ _T("boxvl"),                 0x02524 },
	{ _T("boxvL"),                 0x02561 },
	{ _T("boxVl"),                 0x02562 },
	{ _T("boxVL"),                 0x02563 },
	{ _T("boxvr"),                 0x0251C },
	{ _T("boxvR"),                 0x0255E },
	{ _T("boxVr"),                 0x0255F },
	{ _T("boxVR"),                 0x02560 },
	{ _T("bprime"),                0x02035 },
	{ _T("breve"),                 0x002D8 },
	{ _T("brvbar"),                0x000A6 },
	{ _T("bsemi"),                 0x0204F },
	{ _T("bsim"),                  0x0223D },
	{ _T("bsime"),                 0x022CD },
	{ _T("bsol"),                  0x0005C },
	{ _T("bsolb"),                 0x029C5 },
	{ _T("bull"),                  0x02022 },
	{ _T("bump"),                  0x0224E },
	{ _T("bumpe"),                 0x0224F },
	{ _T("bumpE"),                 0x02AAE },
	{ _T("cacute"),                0x00107 },
	{ _T("Cacute"),                0x00106 },
	{ _T("cap"),                   0x02229 },
	{ _T("Cap"),                   0x022D2 },
	{ _T("capand"),                0x02A44 },
	{ _T("capbrcup"),              0x02A49 },
	{ _T("capcap"),                0x02A4B },
	{ _T("capcup"),                0x02A47 },
	{ _T("capdot"),                0x02A40 },
	{ _T("CapitalDifferentialD"),  0x02145 },
	{ _T("caret"),                 0x02041 },
	{ _T("caron"),                 0x002C7 },
	{ _T("ccaps"),                 0x02A4D },
	{ _T("ccaron"),                0x0010D },
	{ _T("Ccaron"),                0x0010C },
	{ _T("ccedil"),                0x000E7 },
	{ _T("Ccedil"),                0x000C7 },
	{ _T("ccirc"),                 0x00109 },
	{ _T("Ccirc"),                 0x00108 },
	{ _T("Cconint"),               0x02230 },
	{ _T("ccups"),                 0x02A4C },
	{ _T("ccupssm"),               0x02A50 },
	{ _T("cdot"),                  0x0010B },
	{ _T("Cdot"),                  0x0010A },
	{ _T("cedil"),                 0x000B8 },
	{ _T("cemptyv"),               0x029B2 },
	{ _T("cent"),                  0x000A2 },
	{ _T("Cfr"),                   0x0212D },
	{ _T("chcy"),                  0x00447 },
	{ _T("CHcy"),                  0x00427 },
	{ _T("check"),                 0x02713 },
	{ _T("chi"),                   0x003C7 },
	{ _T("Chi"),                   0x003A7 },
	{ _T("cir"),                   0x025CB },
	{ _T("circ"),                  0x002C6 },
	{ _T("cire"),                  0x02257 },
	{ _T("cirE"),                  0x029C3 },
	{ _T("cirfnint"),              0x02A10 },
	{ _T("cirmid"),                0x02AEF },
	{ _T("cirscir"),               0x029C2 },
	{ _T("clubs"),                 0x02663 },
	{ _T("colon"),                 0x0003A },
	{ _T("Colon"),                 0x02237 },
	{ _T("colone"),                0x02254 },
	{ _T("Colone"),                0x02A74 },
	{ _T("comma"),                 0x0002C },
	{ _T("commat"),                0x00040 },
	{ _T("comp"),                  0x02201 },
	{ _T("compfn"),                0x02218 },
	{ _T("cong"),                  0x02245 },
	{ _T("congdot"),               0x02A6D },
	{ _T("conint"),                0x0222E },
	{ _T("Conint"),                0x0222F },
	{ _T("Copf"),                  0x02102 },
	{ _T("coprod"),                0x02210 },
	{ _T("copy"),                  0x000A9 },
	{ _T("copysr"),                0x02117 },
	{ _T("crarr"),                 0x021B5 },
	{ _T("cross"),                 0x02717 },
	{ _T("Cross"),                 0x02A2F },
	{ _T("csub"),                  0x02ACF },
	{ _T("csube"),                 0x02AD1 },
	{ _T("csup"),                  0x02AD0 },
	{ _T("csupe"),                 0x02AD2 },
	{ _T("ctdot"),                 0x022EF },
	{ _T("cudarrl"),               0x02938 },
	{ _T("cudarrr"),               0x02935 },
	{ _T("cuepr"),                 0x022DE },
	{ _T("cuesc"),                 0x022DF },
	{ _T("cularr"),                0x021B6 },
	{ _T("cularrp"),               0x0293D },
	{ _T("cup"),                   0x0222A },
	{ _T("Cup"),                   0x022D3 },
	{ _T("cupbrcap"),              0x02A48 },
	{ _T("cupcap"),                0x02A46 },
	{ _T("cupcup"),                0x02A4A },
	{ _T("cupdot"),                0x0228D },
	{ _T("cupor"),                 0x02A45 },
	{ _T("curarr"),                0x021B7 },
	{ _T("curarrm"),               0x0293C },
	{ _T("curren"),                0x000A4 },
	{ _T("cuvee"),                 0x022CE },
	{ _T("cuwed"),                 0x022CF },
	{ _T("cwconint"),              0x02232 },
	{ _T("cwint"),                 0x02231 },
	{ _T("cylcty"),                0x0232D },
	{ _T("dagger"),                0x02020 },
	{ _T("Dagger"),                0x02021 },
	{ _T("daleth"),                0x02138 },
	{ _T("darr"),                  0x02193 },
	{ _T("dArr"),                  0x021D3 },
	{ _T("Darr"),                  0x021A1 },
	{ _T("dashv"),                 0x022A3 },
	{ _T("Dashv"),                 0x02AE4 },
	{ _T("dblac"),                 0x002DD },
	{ _T("dcaron"),                0x0010F },
	{ _T("Dcaron"),                0x0010E },
	{ _T("dcy"),                   0x00434 },
	{ _T("Dcy"),                   0x00414 },
	{ _T("ddarr"),                 0x021CA },
	{ _T("DDotrahd"),              0x02911 },
	{ _T("deg"),                   0x000B0 },
	{ _T("delta"),                 0x003B4 },
	{ _T("Delta"),                 0x00394 },
	{ _T("demptyv"),               0x029B1 },
	{ _T("dfisht"),                0x0297F },
	{ _T("dHar"),                  0x02965 },
	{ _T("dharl"),                 0x021C3 },
	{ _T("dharr"),                 0x021C2 },
	{ _T("diam"),                  0x022C4 },
	{ _T("diams"),                 0x02666 },
	{ _T("DifferentialD"),         0x02146 },
	{ _T("disin"),                 0x022F2 },
	{ _T("divide"),                0x000F7 },
	{ _T("divonx"),                0x022C7 },
	{ _T("djcy"),                  0x00452 },
	{ _T("DJcy"),                  0x00402 },
	{ _T("dlcorn"),                0x0231E },
	{ _T("dlcrop"),                0x0230D },
	{ _T("dollar"),                0x00024 },
	{ _T("dot"),                   0x002D9 },
	{ _T("Dot"),                   0x000A8 },
	{ _T("DotDot"),                0x020DC },
	{ _T("DownArrowBar"),          0x02913 },
	{ _T("DownBreve"),             0x00311 },
	{ _T("DownLeftRightVector"),   0x02950 },
	{ _T("DownLeftTeeVector"),     0x0295E },
	{ _T("DownLeftVectorBar"),     0x02956 },
	{ _T("DownRightTeeVector"),    0x0295F },
	{ _T("DownRightVectorBar"),    0x02957 },
	{ _T("DownTeeArrow"),          0x021A7 },
	{ _T("drcorn"),                0x0231F },
	{ _T("drcrop"),                0x0230C },
	{ _T("dscy"),                  0x00455 },
	{ _T("DScy"),                  0x00405 },
	{ _T("dsol"),                  0x029F6 },
	{ _T("dstrok"),                0x00111 },
	{ _T("Dstrok"),                0x00110 },
	{ _T("dtdot"),                 0x022F1 },
	{ _T("dtri"),                  0x025BF },
	{ _T("dtrif"),                 0x025BE },
	{ _T("duarr"),                 0x021F5 },
	{ _T("duhar"),                 0x0296F },
	{ _T("dwangle"),               0x029A6 },
	{ _T("dzcy"),                  0x0045F },
	{ _T("DZcy"),                  0x0040F },
	{ _T("dzigrarr"),              0x027FF },
	{ _T("eacute"),                0x000E9 },
	{ _T("Eacute"),                0x000C9 },
	{ _T("easter"),                0x02A6E },
	{ _T("ecaron"),                0x0011B },
	{ _T("Ecaron"),                0x0011A },
	{ _T("ecir"),                  0x02256 },
	{ _T("ecirc"),                 0x000EA },
	{ _T("Ecirc"),                 0x000CA },
	{ _T("ecolon"),                0x02255 },
	{ _T("ecy"),                   0x0044D },
	{ _T("Ecy"),                   0x0042D },
	{ _T("eDDot"),                 0x02A77 },
	{ _T("edot"),                  0x00117 },
	{ _T("eDot"),                  0x02251 },
	{ _T("Edot"),                  0x00116 },
	{ _T("efDot"),                 0x02252 },
	{ _T("eg"),                    0x02A9A },
	{ _T("egrave"),                0x000E8 },
	{ _T("Egrave"),                0x000C8 },
	{ _T("egs"),                   0x02A96 },
	{ _T("egsdot"),                0x02A98 },
	{ _T("el"),                    0x02A99 },
	{ _T("elinters"),              0x023E7 },
	{ _T("ell"),                   0x02113 },
	{ _T("els"),                   0x02A95 },
	{ _T("elsdot"),                0x02A97 },
	{ _T("emacr"),                 0x00113 },
	{ _T("Emacr"),                 0x00112 },
	{ _T("empty"),                 0x02205 },
	{ _T("EmptySmallSquare"),      0x025FB },
	{ _T("EmptyVerySmallSquare"),  0x025AB },
	{ _T("emsp"),                  0x02003 },
	{ _T("emsp13"),                0x02004 },
	{ _T("emsp14"),                0x02005 },
	{ _T("eng"),                   0x0014B },
	{ _T("ENG"),                   0x0014A },
	{ _T("ensp"),                  0x02002 },
	{ _T("eogon"),                 0x00119 },
	{ _T("Eogon"),                 0x00118 },
	{ _T("epar"),                  0x022D5 },
	{ _T("eparsl"),                0x029E3 },
	{ _T("eplus"),                 0x02A71 },
	{ _T("epsi"),                  0x003F5 },
	{ _T("Epsilon"),               0x00395 },
	{ _T("epsiv"),                 0x003B5 },
	{ _T("Equal"),                 0x02A75 },
	{ _T("equals"),                0x0003D },
	{ _T("equest"),                0x0225F },
	{ _T("equiv"),                 0x02261 },
	{ _T("equivDD"),               0x02A78 },
	{ _T("eqvparsl"),              0x029E5 },
	{ _T("erarr"),                 0x02971 },
	{ _T("erDot"),                 0x02253 },
	{ _T("escr"),                  0x0212F },
	{ _T("Escr"),                  0x02130 },
	{ _T("esdot"),                 0x02250 },
	{ _T("esim"),                  0x02242 },
	{ _T("Esim"),                  0x02A73 },
	{ _T("eta"),                   0x003B7 },
	{ _T("Eta"),                   0x00397 },
	{ _T("eth"),                   0x000F0 },
	{ _T("ETH"),                   0x000D0 },
	{ _T("euml"),                  0x000EB },
	{ _T("Euml"),                  0x000CB },
	{ _T("euro"),                  0x020AC },
	{ _T("excl"),                  0x00021 },
	{ _T("exist"),                 0x02203 },
	{ _T("ExponentialE"),          0x02147 },
	{ _T("fcy"),                   0x00444 },
	{ _T("Fcy"),                   0x00424 },
	{ _T("female"),                0x02640 },
	{ _T("ffilig"),                0x0FB03 },
	{ _T("fflig"),                 0x0FB00 },
	{ _T("ffllig"),                0x0FB04 },
	{ _T("filig"),                 0x0FB01 },
	{ _T("FilledSmallSquare"),     0x025FC },
	{ _T("flat"),                  0x0266D },
	{ _T("fllig"),                 0x0FB02 },
	{ _T("fltns"),                 0x025B1 },
	{ _T("fnof"),                  0x00192 },
	{ _T("forall"),                0x02200 },
	{ _T("fork"),                  0x022D4 },
	{ _T("forkv"),                 0x02AD9 },
	{ _T("fpartint"),              0x02A0D },
	{ _T("frac12"),                0x000BD },
	{ _T("frac13"),                0x02153 },
	{ _T("frac14"),                0x000BC },
	{ _T("frac15"),                0x02155 },
	{ _T("frac16"),                0x02159 },
	{ _T("frac18"),                0x0215B },
	{ _T("frac23"),                0x02154 },
	{ _T("frac25"),                0x02156 },
	{ _T("frac34"),                0x000BE },
	{ _T("frac35"),                0x02157 },
	{ _T("frac38"),                0x0215C },
	{ _T("frac45"),                0x02158 },
	{ _T("frac56"),                0x0215A },
	{ _T("frac58"),                0x0215D },
	{ _T("frac78"),                0x0215E },
	{ _T("frasl"),                 0x02044 },
	{ _T("frown"),                 0x02322 },
	{ _T("Fscr"),                  0x02131 },
	{ _T("gacute"),                0x001F5 },
	{ _T("gamma"),                 0x003B3 },
	{ _T("Gamma"),                 0x00393 },
	{ _T("gammad"),                0x003DD },
	{ _T("Gammad"),                0x003DC },
	{ _T("gap"),                   0x02A86 },
	{ _T("gbreve"),                0x0011F },
	{ _T("Gbreve"),                0x0011E },
	{ _T("Gcedil"),                0x00122 },
	{ _T("gcirc"),                 0x0011D },
	{ _T("Gcirc"),                 0x0011C },
	{ _T("gcy"),                   0x00433 },
	{ _T("Gcy"),                   0x00413 },
	{ _T("gdot"),                  0x00121 },
	{ _T("Gdot"),                  0x00120 },
	{ _T("ge"),                    0x02265 },
	{ _T("gE"),                    0x02267 },
	{ _T("gel"),                   0x022DB },
	{ _T("gEl"),                   0x02A8C },
	{ _T("ges"),                   0x02A7E },
	{ _T("gescc"),                 0x02AA9 },
	{ _T("gesdot"),                0x02A80 },
	{ _T("gesdoto"),               0x02A82 },
	{ _T("gesdotol"),              0x02A84 },
	{ _T("gesles"),                0x02A94 },
	{ _T("Gg"),                    0x022D9 },
	{ _T("gimel"),                 0x02137 },
	{ _T("gjcy"),                  0x00453 },
	{ _T("GJcy"),                  0x00403 },
	{ _T("gl"),                    0x02277 },
	{ _T("gla"),                   0x02AA5 },
	{ _T("glE"),                   0x02A92 },
	{ _T("glj"),                   0x02AA4 },
	{ _T("gnap"),                  0x02A8A },
	{ _T("gne"),                   0x02A88 },
	{ _T("gnE"),                   0x02269 },
	{ _T("gnsim"),                 0x022E7 },
	{ _T("grave"),                 0x00060 },
	{ _T("GreaterGreater"),        0x02AA2 },
	{ _T("gscr"),                  0x0210A },
	{ _T("gsim"),                  0x02273 },
	{ _T("gsime"),                 0x02A8E },
	{ _T("gsiml"),                 0x02A90 },
	{ _T("gt"),                    0x0003E },
	{ _T("Gt"),                    0x0226B },
	{ _T("gtcc"),                  0x02AA7 },
	{ _T("gtcir"),                 0x02A7A },
	{ _T("gtdot"),                 0x022D7 },
	{ _T("gtlPar"),                0x02995 },
	{ _T("gtquest"),               0x02A7C },
	{ _T("gtrarr"),                0x02978 },
	{ _T("hairsp"),                0x0200A },
	{ _T("hamilt"),                0x0210B },
	{ _T("hardcy"),                0x0044A },
	{ _T("HARDcy"),                0x0042A },
	{ _T("harr"),                  0x02194 },
	{ _T("hArr"),                  0x021D4 },
	{ _T("harrcir"),               0x02948 },
	{ _T("harrw"),                 0x021AD },
	{ _T("Hat"),                   0x0005E },
	{ _T("hcirc"),                 0x00125 },
	{ _T("Hcirc"),                 0x00124 },
	{ _T("hearts"),                0x02665 },
	{ _T("hellip"),                0x02026 },
	{ _T("hercon"),                0x022B9 },
	{ _T("Hfr"),                   0x0210C },
	{ _T("hoarr"),                 0x021FF },
	{ _T("homtht"),                0x0223B },
	{ _T("horbar"),                0x02015 },
	{ _T("hstrok"),                0x00127 },
	{ _T("Hstrok"),                0x00126 },
	{ _T("hybull"),                0x02043 },
	{ _T("hyphen"),                0x02010 },
	{ _T("iacute"),                0x000ED },
	{ _T("Iacute"),                0x000CD },
	{ _T("icirc"),                 0x000EE },
	{ _T("Icirc"),                 0x000CE },
	{ _T("icy"),                   0x00438 },
	{ _T("Icy"),                   0x00418 },
	{ _T("Idot"),                  0x00130 },
	{ _T("iecy"),                  0x00435 },
	{ _T("IEcy"),                  0x00415 },
	{ _T("iexcl"),                 0x000A1 },
	{ _T("igrave"),                0x000EC },
	{ _T("Igrave"),                0x000CC },
	{ _T("iinfin"),                0x029DC },
	{ _T("iiota"),                 0x02129 },
	{ _T("ijlig"),                 0x00133 },
	{ _T("IJlig"),                 0x00132 },
	{ _T("imacr"),                 0x0012B },
	{ _T("Imacr"),                 0x0012A },
	{ _T("image"),                 0x02111 },
	{ _T("ImaginaryI"),            0x02148 },
	{ _T("imath"),                 0x00131 },
	{ _T("imof"),                  0x022B7 },
	{ _T("imped"),                 0x001B5 },
	{ _T("incare"),                0x02105 },
	{ _T("infin"),                 0x0221E },
	{ _T("infintie"),              0x029DD },
	{ _T("int"),                   0x0222B },
	{ _T("Int"),                   0x0222C },
	{ _T("intcal"),                0x022BA },
	{ _T("integers"),              0x02124 },
	{ _T("intlarhk"),              0x02A17 },
	{ _T("InvisibleComma"),        0x02063 },
	{ _T("InvisibleTimes"),        0x02062 },
	{ _T("iocy"),                  0x00451 },
	{ _T("IOcy"),                  0x00401 },
	{ _T("iogon"),                 0x0012F },
	{ _T("Iogon"),                 0x0012E },
	{ _T("iota"),                  0x003B9 },
	{ _T("Iota"),                  0x00399 },
	{ _T("iprod"),                 0x02A3C },
	{ _T("iquest"),                0x000BF },
	{ _T("Iscr"),                  0x02110 },
	{ _T("isin"),                  0x02208 },
	{ _T("isindot"),               0x022F5 },
	{ _T("isinE"),                 0x022F9 },
	{ _T("isins"),                 0x022F4 },
	{ _T("isinsv"),                0x022F3 },
	{ _T("itilde"),                0x00129 },
	{ _T("Itilde"),                0x00128 },
	{ _T("iukcy"),                 0x00456 },
	{ _T("Iukcy"),                 0x00406 },
	{ _T("iuml"),                  0x000EF },
	{ _T("Iuml"),                  0x000CF },
	{ _T("jcirc"),                 0x00135 },
	{ _T("Jcirc"),                 0x00134 },
	{ _T("jcy"),                   0x00439 },
	{ _T("Jcy"),                   0x00419 },
	{ _T("jmath"),                 0x00237 },
	{ _T("jsercy"),                0x00458 },
	{ _T("Jsercy"),                0x00408 },
	{ _T("jukcy"),                 0x00454 },
	{ _T("Jukcy"),                 0x00404 },
	{ _T("kappa"),                 0x003BA },
	{ _T("Kappa"),                 0x0039A },
	{ _T("kappav"),                0x003F0 },
	{ _T("kcedil"),                0x00137 },
	{ _T("Kcedil"),                0x00136 },
	{ _T("kcy"),                   0x0043A },
	{ _T("Kcy"),                   0x0041A },
	{ _T("kgreen"),                0x00138 },
	{ _T("khcy"),                  0x00445 },
	{ _T("KHcy"),                  0x00425 },
	{ _T("kjcy"),                  0x0045C },
	{ _T("KJcy"),                  0x0040C },
	{ _T("lAarr"),                 0x021DA },
	{ _T("lacute"),                0x0013A },
	{ _T("Lacute"),                0x00139 },
	{ _T("laemptyv"),              0x029B4 },
	{ _T("lambda"),                0x003BB },
	{ _T("Lambda"),                0x0039B },
	{ _T("lang"),                  0x027E8 },
	{ _T("Lang"),                  0x027EA },
	{ _T("langd"),                 0x02991 },
	{ _T("lap"),                   0x02A85 },
	{ _T("laquo"),                 0x000AB },
	{ _T("larr"),                  0x02190 },
	{ _T("lArr"),                  0x021D0 },
	{ _T("Larr"),                  0x0219E },
	{ _T("larrb"),                 0x021E4 },
	{ _T("larrbfs"),               0x0291F },
	{ _T("larrfs"),                0x0291D },
	{ _T("larrhk"),                0x021A9 },
	{ _T("larrlp"),                0x021AB },
	{ _T("larrpl"),                0x02939 },
	{ _T("larrsim"),               0x02973 },
	{ _T("larrtl"),                0x021A2 },
	{ _T("lat"),                   0x02AAB },
	{ _T("latail"),                0x02919 },
	{ _T("lAtail"),                0x0291B },
	{ _T("late"),                  0x02AAD },
	{ _T("lbarr"),                 0x0290C },
	{ _T("lBarr"),                 0x0290E },
	{ _T("lbbrk"),                 0x02772 },
	{ _T("lbrke"),                 0x0298B },
	{ _T("lbrksld"),               0x0298F },
	{ _T("lbrkslu"),               0x0298D },
	{ _T("lcaron"),                0x0013E },
	{ _T("Lcaron"),                0x0013D },
	{ _T("lcedil"),                0x0013C },
	{ _T("Lcedil"),                0x0013B },
	{ _T("lceil"),                 0x02308 },
	{ _T("lcub"),                  0x0007B },
	{ _T("lcy"),                   0x0043B },
	{ _T("Lcy"),                   0x0041B },
	{ _T("ldca"),                  0x02936 },
	{ _T("ldquo"),                 0x0201C },
	{ _T("ldquor"),                0x0201E },
	{ _T("ldrdhar"),               0x02967 },
	{ _T("ldrushar"),              0x0294B },
	{ _T("ldsh"),                  0x021B2 },
	{ _T("le"),                    0x02264 },
	{ _T("lE"),                    0x02266 },
	{ _T("LeftDownTeeVector"),     0x02961 },
	{ _T("LeftDownVectorBar"),     0x02959 },
	{ _T("LeftRightVector"),       0x0294E },
	{ _T("LeftTeeArrow"),          0x021A4 },
	{ _T("LeftTeeVector"),         0x0295A },
	{ _T("LeftTriangleBar"),       0x029CF },
	{ _T("LeftUpDownVector"),      0x02951 },
	{ _T("LeftUpTeeVector"),       0x02960 },
	{ _T("LeftUpVectorBar"),       0x02958 },
	{ _T("LeftVectorBar"),         0x02952 },
	{ _T("leg"),                   0x022DA },
	{ _T("lEg"),                   0x02A8B },
	{ _T("les"),                   0x02A7D },
	{ _T("lescc"),                 0x02AA8 },
	{ _T("lesdot"),                0x02A7F },
	{ _T("lesdoto"),               0x02A81 },
	{ _T("lesdotor"),              0x02A83 },
	{ _T("lesges"),                0x02A93 },
	{ _T("LessLess"),              0x02AA1 },
	{ _T("lfisht"),                0x0297C },
	{ _T("lfloor"),                0x0230A },
	{ _T("lg"),                    0x02276 },
	{ _T("lgE"),                   0x02A91 },
	{ _T("lHar"),                  0x02962 },
	{ _T("lhard"),                 0x021BD },
	{ _T("lharu"),                 0x021BC },
	{ _T("lharul"),                0x0296A },
	{ _T("lhblk"),                 0x02584 },
	{ _T("ljcy"),                  0x00459 },
	{ _T("LJcy"),                  0x00409 },
	{ _T("Ll"),                    0x022D8 },
	{ _T("llarr"),                 0x021C7 },
	{ _T("llhard"),                0x0296B },
	{ _T("lltri"),                 0x025FA },
	{ _T("lmidot"),                0x00140 },
	{ _T("Lmidot"),                0x0013F },
	{ _T("lmoust"),                0x023B0 },
	{ _T("lnap"),                  0x02A89 },
	{ _T("lne"),                   0x02A87 },
	{ _T("lnE"),                   0x02268 },
	{ _T("lnsim"),                 0x022E6 },
	{ _T("loang"),                 0x027EC },
	{ _T("loarr"),                 0x021FD },
	{ _T("lobrk"),                 0x027E6 },
	{ _T("lopar"),                 0x02985 },
	{ _T("loplus"),                0x02A2D },
	{ _T("lotimes"),               0x02A34 },
	{ _T("lowast"),                0x02217 },
	{ _T("lowbar"),                0x0005F },
	{ _T("loz"),                   0x025CA },
	{ _T("lozf"),                  0x029EB },
	{ _T("lpar"),                  0x00028 },
	{ _T("lparlt"),                0x02993 },
	{ _T("lrarr"),                 0x021C6 },
	{ _T("lrhar"),                 0x021CB },
	{ _T("lrhard"),                0x0296D },
	{ _T("lrm"),                   0x0200E },
	{ _T("lrtri"),                 0x022BF },
	{ _T("lsaquo"),                0x02039 },
	{ _T("Lscr"),                  0x02112 },
	{ _T("lsh"),                   0x021B0 },
	{ _T("lsim"),                  0x02272 },
	{ _T("lsime"),                 0x02A8D },
	{ _T("lsimg"),                 0x02A8F },
	{ _T("lsqb"),                  0x0005B },
	{ _T("lsquo"),                 0x02018 },
	{ _T("lsquor"),                0x0201A },
	{ _T("lstrok"),                0x00142 },
	{ _T("Lstrok"),                0x00141 },
	{ _T("lt"),                    0x0003C },
	{ _T("Lt"),                    0x0226A },
	{ _T("ltcc"),                  0x02AA6 },
	{ _T("ltcir"),                 0x02A79 },
	{ _T("ltdot"),                 0x022D6 },
	{ _T("lthree"),                0x022CB },
	{ _T("ltimes"),                0x022C9 },
	{ _T("ltlarr"),                0x02976 },
	{ _T("ltquest"),               0x02A7B },
	{ _T("ltri"),                  0x025C3 },
	{ _T("ltrie"),                 0x022B4 },
	{ _T("ltrif"),                 0x025C2 },
	{ _T("ltrPar"),                0x02996 },
	{ _T("lurdshar"),              0x0294A },
	{ _T("luruhar"),               0x02966 },
	{ _T("macr"),                  0x000AF },
	{ _T("male"),                  0x02642 },
	{ _T("malt"),                  0x02720 },
	{ _T("map"),                   0x021A6 },
	{ _T("Map"),                   0x02905 },
	{ _T("marker"),                0x025AE },
	{ _T("mcomma"),                0x02A29 },
	{ _T("mcy"),                   0x0043C },
	{ _T("Mcy"),                   0x0041C },
	{ _T("mdash"),                 0x02014 },
	{ _T("mDDot"),                 0x0223A },
	{ _T("MediumSpace"),           0x0205F },
	{ _T("mho"),                   0x02127 },
	{ _T("micro"),                 0x000B5 },
	{ _T("mid"),                   0x02223 },
	{ _T("midcir"),                0x02AF0 },
	{ _T("middot"),                0x000B7 },
	{ _T("minus"),                 0x02212 },
	{ _T("minusb"),                0x0229F },
	{ _T("minusd"),                0x02238 },
	{ _T("minusdu"),               0x02A2A },
	{ _T("mlcp"),                  0x02ADB },
	{ _T("mnplus"),                0x02213 },
	{ _T("models"),                0x022A7 },
	{ _T("mu"),                    0x003BC },
	{ _T("Mu"),                    0x0039C },
	{ _T("mumap"),                 0x022B8 },
	{ _T("nabla"),                 0x02207 },
	{ _T("nacute"),                0x00144 },
	{ _T("Nacute"),                0x00143 },
	{ _T("nap"),                   0x02249 },
	{ _T("napos"),                 0x00149 },
	{ _T("natur"),                 0x0266E },
	{ _T("nbsp"),                  0x000A0 },
	{ _T("ncap"),                  0x02A43 },
	{ _T("ncaron"),                0x00148 },
	{ _T("Ncaron"),                0x00147 },
	{ _T("ncedil"),                0x00146 },
	{ _T("Ncedil"),                0x00145 },
	{ _T("ncong"),                 0x02247 },
	{ _T("ncup"),                  0x02A42 },
	{ _T("ncy"),                   0x0043D },
	{ _T("Ncy"),                   0x0041D },
	{ _T("ndash"),                 0x02013 },
	{ _T("ne"),                    0x02260 },
	{ _T("nearhk"),                0x02924 },
	{ _T("nearr"),                 0x02197 },
	{ _T("neArr"),                 0x021D7 },
	{ _T("nequiv"),                0x02262 },
	{ _T("nesear"),                0x02928 },
	{ _T("NewLine"),               0x0000A },
	{ _T("nexist"),                0x02204 },
	{ _T("nge"),                   0x02271 },
	{ _T("ngsim"),                 0x02275 },
	{ _T("ngt"),                   0x0226F },
	{ _T("nharr"),                 0x021AE },
	{ _T("nhArr"),                 0x021CE },
	{ _T("nhpar"),                 0x02AF2 },
	{ _T("nis"),                   0x022FC },
	{ _T("nisd"),                  0x022FA },
	{ _T("niv"),                   0x0220B },
	{ _T("njcy"),                  0x0045A },
	{ _T("NJcy"),                  0x0040A },
	{ _T("nlarr"),                 0x0219A },
	{ _T("nlArr"),                 0x021CD },
	{ _T("nldr"),                  0x02025 },
	{ _T("nle"),                   0x02270 },
	{ _T("nlsim"),                 0x02274 },
	{ _T("nlt"),                   0x0226E },
	{ _T("nltri"),                 0x022EA },
	{ _T("nltrie"),                0x022EC },
	{ _T("nmid"),                  0x02224 },
	{ _T("NoBreak"),               0x02060 },
	{ _T("Nopf"),                  0x02115 },
	{ _T("not"),                   0x000AC },
	{ _T("Not"),                   0x02AEC },
	{ _T("NotCupCap"),             0x0226D },
	{ _T("notin"),                 0x02209 },
	{ _T("notinvb"),               0x022F7 },
	{ _T("notinvc"),               0x022F6 },
	{ _T("notni"),                 0x0220C },
	{ _T("notnivb"),               0x022FE },
	{ _T("notnivc"),               0x022FD },
	{ _T("npar"),                  0x02226 },
	{ _T("npolint"),               0x02A14 },
	{ _T("npr"),                   0x02280 },
	{ _T("nprcue"),                0x022E0 },
	{ _T("nrarr"),                 0x0219B },
	{ _T("nrArr"),                 0x021CF },
	{ _T("nrtri"),                 0x022EB },
	{ _T("nrtrie"),                0x022ED },
	{ _T("nsc"),                   0x02281 },
	{ _T("nsccue"),                0x022E1 },
	{ _T("nsim"),                  0x02241 },
	{ _T("nsime"),                 0x02244 },
	{ _T("nsqsube"),               0x022E2 },
	{ _T("nsqsupe"),               0x022E3 },
	{ _T("nsub"),                  0x02284 },
	{ _T("nsube"),                 0x02288 },
	{ _T("nsup"),                  0x02285 },
	{ _T("nsupe"),                 0x02289 },
	{ _T("ntgl"),                  0x02279 },
	{ _T("ntilde"),                0x000F1 },
	{ _T("Ntilde"),                0x000D1 },
	{ _T("ntlg"),                  0x02278 },
	{ _T("nu"),                    0x003BD },
	{ _T("Nu"),                    0x0039D },
	{ _T("num"),                   0x00023 },
	{ _T("numero"),                0x02116 },
	{ _T("numsp"),                 0x02007 },
	{ _T("nvdash"),                0x022AC },
	{ _T("nvDash"),                0x022AD },
	{ _T("nVdash"),                0x022AE },
	{ _T("nVDash"),                0x022AF },
	{ _T("nvHarr"),                0x02904 },
	{ _T("nvinfin"),               0x029DE },
	{ _T("nvlArr"),                0x02902 },
	{ _T("nvrArr"),                0x02903 },
	{ _T("nwarhk"),                0x02923 },
	{ _T("nwarr"),                 0x02196 },
	{ _T("nwArr"),                 0x021D6 },
	{ _T("nwnear"),                0x02927 },
	{ _T("oacute"),                0x000F3 },
	{ _T("Oacute"),                0x000D3 },
	{ _T("oast"),                  0x0229B },
	{ _T("ocir"),                  0x0229A },
	{ _T("ocirc"),                 0x000F4 },
	{ _T("Ocirc"),                 0x000D4 },
	{ _T("ocy"),                   0x0043E },
	{ _T("Ocy"),                   0x0041E },
	{ _T("odash"),                 0x0229D },
	{ _T("odblac"),                0x00151 },
	{ _T("Odblac"),                0x00150 },
	{ _T("odiv"),                  0x02A38 },
	{ _T("odot"),                  0x02299 },
	{ _T("odsold"),                0x029BC },
	{ _T("oelig"),                 0x00153 },
	{ _T("OElig"),                 0x00152 },
	{ _T("ofcir"),                 0x029BF },
	{ _T("ogon"),                  0x002DB },
	{ _T("ograve"),                0x000F2 },
	{ _T("Ograve"),                0x000D2 },
	{ _T("ogt"),                   0x029C1 },
	{ _T("ohbar"),                 0x029B5 },
	{ _T("ohm"),                   0x02126 },
	{ _T("olarr"),                 0x021BA },
	{ _T("olcir"),                 0x029BE },
	{ _T("olcross"),               0x029BB },
	{ _T("oline"),                 0x0203E },
	{ _T("olt"),                   0x029C0 },
	{ _T("omacr"),                 0x0014D },
	{ _T("Omacr"),                 0x0014C },
	{ _T("omega"),                 0x003C9 },
	{ _T("Omega"),                 0x003A9 },
	{ _T("omicron"),               0x003BF },
	{ _T("Omicron"),               0x0039F },
	{ _T("omid"),                  0x029B6 },
	{ _T("ominus"),                0x02296 },
	{ _T("opar"),                  0x029B7 },
	{ _T("operp"),                 0x029B9 },
	{ _T("oplus"),                 0x02295 },
	{ _T("or"),                    0x02228 },
	{ _T("Or"),                    0x02A54 },
	{ _T("orarr"),                 0x021BB },
	{ _T("ord"),                   0x02A5D },
	{ _T("order"),                 0x02134 },
	{ _T("ordf"),                  0x000AA },
	{ _T("ordm"),                  0x000BA },
	{ _T("origof"),                0x022B6 },
	{ _T("oror"),                  0x02A56 },
	{ _T("orslope"),               0x02A57 },
	{ _T("orv"),                   0x02A5B },
	{ _T("oS"),                    0x024C8 },
	{ _T("oslash"),                0x000F8 },
	{ _T("Oslash"),                0x000D8 },
	{ _T("osol"),                  0x02298 },
	{ _T("otilde"),                0x000F5 },
	{ _T("Otilde"),                0x000D5 },
	{ _T("otimes"),                0x02297 },
	{ _T("Otimes"),                0x02A37 },
	{ _T("otimesas"),              0x02A36 },
	{ _T("ouml"),                  0x000F6 },
	{ _T("Ouml"),                  0x000D6 },
	{ _T("ovbar"),                 0x0233D },
	{ _T("OverBrace"),             0x023DE },
	{ _T("OverParenthesis"),       0x023DC },
	{ _T("par"),                   0x02225 },
	{ _T("para"),                  0x000B6 },
	{ _T("parsim"),                0x02AF3 },
	{ _T("parsl"),                 0x02AFD },
	{ _T("part"),                  0x02202 },
	{ _T("pcy"),                   0x0043F },
	{ _T("Pcy"),                   0x0041F },
	{ _T("percnt"),                0x00025 },
	{ _T("period"),                0x0002E },
	{ _T("permil"),                0x02030 },
	{ _T("pertenk"),               0x02031 },
	{ _T("phi"),                   0x003C6 },
	{ _T("Phi"),                   0x003A6 },
	{ _T("phmmat"),                0x02133 },
	{ _T("phone"),                 0x0260E },
	{ _T("pi"),                    0x003C0 },
	{ _T("Pi"),                    0x003A0 },
	{ _T("piv"),                   0x003D6 },
	{ _T("planck"),                0x0210F },
	{ _T("planckh"),               0x0210E },
	{ _T("plus"),                  0x0002B },
	{ _T("plusacir"),              0x02A23 },
	{ _T("plusb"),                 0x0229E },
	{ _T("pluscir"),               0x02A22 },
	{ _T("plusdo"),                0x02214 },
	{ _T("plusdu"),                0x02A25 },
	{ _T("pluse"),                 0x02A72 },
	{ _T("plusmn"),                0x000B1 },
	{ _T("plussim"),               0x02A26 },
	{ _T("plustwo"),               0x02A27 },
	{ _T("pointint"),              0x02A15 },
	{ _T("Popf"),                  0x02119 },
	{ _T("pound"),                 0x000A3 },
	{ _T("pr"),                    0x0227A },
	{ _T("Pr"),                    0x02ABB },
	{ _T("prap"),                  0x02AB7 },
	{ _T("prcue"),                 0x0227C },
	{ _T("pre"),                   0x02AAF },
	{ _T("prE"),                   0x02AB3 },
	{ _T("prime"),                 0x02032 },
	{ _T("Prime"),                 0x02033 },
	{ _T("prnap"),                 0x02AB9 },
	{ _T("prnE"),                  0x02AB5 },
	{ _T("prnsim"),                0x022E8 },
	{ _T("prod"),                  0x0220F },
	{ _T("profalar"),              0x0232E },
	{ _T("profline"),              0x02312 },
	{ _T("profsurf"),              0x02313 },
	{ _T("prop"),                  0x0221D },
	{ _T("prsim"),                 0x0227E },
	{ _T("prurel"),                0x022B0 },
	{ _T("psi"),                   0x003C8 },
	{ _T("Psi"),                   0x003A8 },
	{ _T("puncsp"),                0x02008 },
	{ _T("qint"),                  0x02A0C },
	{ _T("qprime"),                0x02057 },
	{ _T("quaternions"),           0x0210D },
	{ _T("quatint"),               0x02A16 },
	{ _T("quest"),                 0x0003F },
	{ _T("quot"),                  0x00022 },
	{ _T("rAarr"),                 0x021DB },
	{ _T("race"),                  0x029DA },
	{ _T("racute"),                0x00155 },
	{ _T("Racute"),                0x00154 },
	{ _T("radic"),                 0x0221A },
	{ _T("raemptyv"),              0x029B3 },
	{ _T("rang"),                  0x027E9 },
	{ _T("Rang"),                  0x027EB },
	{ _T("rangd"),                 0x02992 },
	{ _T("range"),                 0x029A5 },
	{ _T("raquo"),                 0x000BB },
	{ _T("rarr"),                  0x02192 },
	{ _T("rArr"),                  0x021D2 },
	{ _T("Rarr"),                  0x021A0 },
	{ _T("rarrap"),                0x02975 },
	{ _T("rarrb"),                 0x021E5 },
	{ _T("rarrbfs"),               0x02920 },
	{ _T("rarrc"),                 0x02933 },
	{ _T("rarrfs"),                0x0291E },
	{ _T("rarrhk"),                0x021AA },
	{ _T("rarrlp"),                0x021AC },
	{ _T("rarrpl"),                0x02945 },
	{ _T("rarrsim"),               0x02974 },
	{ _T("rarrtl"),                0x021A3 },
	{ _T("Rarrtl"),                0x02916 },
	{ _T("rarrw"),                 0x0219D },
	{ _T("ratail"),                0x0291A },
	{ _T("rAtail"),                0x0291C },
	{ _T("ratio"),                 0x02236 },
	{ _T("rationals"),             0x0211A },
	{ _T("rbarr"),                 0x0290D },
	{ _T("rBarr"),                 0x0290F },
	{ _T("RBarr"),                 0x02910 },
	{ _T("rbbrk"),                 0x02773 },
	{ _T("rbrke"),                 0x0298C },
	{ _T("rbrksld"),               0x0298E },
	{ _T("rbrkslu"),               0x02990 },
	{ _T("rcaron"),                0x00159 },
	{ _T("Rcaron"),                0x00158 },
	{ _T("rcedil"),                0x00157 },
	{ _T("Rcedil"),                0x00156 },
	{ _T("rceil"),                 0x02309 },
	{ _T("rcub"),                  0x0007D },
	{ _T("rcy"),                   0x00440 },
	{ _T("Rcy"),                   0x00420 },
	{ _T("rdca"),                  0x02937 },
	{ _T("rdldhar"),               0x02969 },
	{ _T("rdquo"),                 0x0201D },
	{ _T("rdsh"),                  0x021B3 },
	{ _T("real"),                  0x0211C },
	{ _T("reals"),                 0x0211D },
	{ _T("rect"),                  0x025AD },
	{ _T("reg"),                   0x000AE },
	{ _T("rfisht"),                0x0297D },
	{ _T("rfloor"),                0x0230B },
	{ _T("rHar"),                  0x02964 },
	{ _T("rhard"),                 0x021C1 },
	{ _T("rharu"),                 0x021C0 },
	{ _T("rharul"),                0x0296C },
	{ _T("rho"),                   0x003C1 },
	{ _T("Rho"),                   0x003A1 },
	{ _T("rhov"),                  0x003F1 },
	{ _T("RightDownTeeVector"),    0x0295D },
	{ _T("RightDownVectorBar"),    0x02955 },
	{ _T("RightTeeVector"),        0x0295B },
	{ _T("RightTriangleBar"),      0x029D0 },
	{ _T("RightUpDownVector"),     0x0294F },
	{ _T("RightUpTeeVector"),      0x0295C },
	{ _T("RightUpVectorBar"),      0x02954 },
	{ _T("RightVectorBar"),        0x02953 },
	{ _T("ring"),                  0x002DA },
	{ _T("rlarr"),                 0x021C4 },
	{ _T("rlhar"),                 0x021CC },
	{ _T("rlm"),                   0x0200F },
	{ _T("rmoust"),                0x023B1 },
	{ _T("rnmid"),                 0x02AEE },
	{ _T("roang"),                 0x027ED },
	{ _T("roarr"),                 0x021FE },
	{ _T("robrk"),                 0x027E7 },
	{ _T("ropar"),                 0x02986 },
	{ _T("roplus"),                0x02A2E },
	{ _T("rotimes"),               0x02A35 },
	{ _T("RoundImplies"),          0x02970 },
	{ _T("rpar"),                  0x00029 },
	{ _T("rpargt"),                0x02994 },
	{ _T("rppolint"),              0x02A12 },
	{ _T("rrarr"),                 0x021C9 },
	{ _T("rsaquo"),                0x0203A },
	{ _T("Rscr"),                  0x0211B },
	{ _T("rsh"),                   0x021B1 },
	{ _T("rsqb"),                  0x0005D },
	{ _T("rsquo"),                 0x02019 },
	{ _T("rthree"),                0x022CC },
	{ _T("rtimes"),                0x022CA },
	{ _T("rtri"),                  0x025B9 },
	{ _T("rtrie"),                 0x022B5 },
	{ _T("rtrif"),                 0x025B8 },
	{ _T("rtriltri"),              0x029CE },
	{ _T("RuleDelayed"),           0x029F4 },
	{ _T("ruluhar"),               0x02968 },
	{ _T("rx"),                    0x0211E },
	{ _T("sacute"),                0x0015B },
	{ _T("Sacute"),                0x0015A },
	{ _T("sc"),                    0x0227B },
	{ _T("Sc"),                    0x02ABC },
	{ _T("scap"),                  0x02AB8 },
	{ _T("scaron"),                0x00161 },
	{ _T("Scaron"),                0x00160 },
	{ _T("sccue"),                 0x0227D },
	{ _T("sce"),                   0x02AB0 },
	{ _T("scE"),                   0x02AB4 },
	{ _T("scedil"),                0x0015F },
	{ _T("Scedil"),                0x0015E },
	{ _T("scirc"),                 0x0015D },
	{ _T("Scirc"),                 0x0015C },
	{ _T("scnap"),                 0x02ABA },
	{ _T("scnE"),                  0x02AB6 },
	{ _T("scnsim"),                0x022E9 },
	{ _T("scpolint"),              0x02A13 },
	{ _T("scsim"),                 0x0227F },
	{ _T("scy"),                   0x00441 },
	{ _T("Scy"),                   0x00421 },
	{ _T("sdot"),                  0x022C5 },
	{ _T("sdotb"),                 0x022A1 },
	{ _T("sdote"),                 0x02A66 },
	{ _T("searhk"),                0x02925 },
	{ _T("searr"),                 0x02198 },
	{ _T("seArr"),                 0x021D8 },
	{ _T("sect"),                  0x000A7 },
	{ _T("semi"),                  0x0003B },
	{ _T("seswar"),                0x02929 },
	{ _T("setmn"),                 0x02216 },
	{ _T("sext"),                  0x02736 },
	{ _T("sharp"),                 0x0266F },
	{ _T("shchcy"),                0x00449 },
	{ _T("SHCHcy"),                0x00429 },
	{ _T("shcy"),                  0x00448 },
	{ _T("SHcy"),                  0x00428 },
	{ _T("shy"),                   0x000AD },
	{ _T("sigma"),                 0x003C3 },
	{ _T("Sigma"),                 0x003A3 },
	{ _T("sigmav"),                0x003C2 },
	{ _T("sim"),                   0x0223C },
	{ _T("simdot"),                0x02A6A },
	{ _T("sime"),                  0x02243 },
	{ _T("simg"),                  0x02A9E },
	{ _T("simgE"),                 0x02AA0 },
	{ _T("siml"),                  0x02A9D },
	{ _T("simlE"),                 0x02A9F },
	{ _T("simne"),                 0x02246 },
	{ _T("simplus"),               0x02A24 },
	{ _T("simrarr"),               0x02972 },
	{ _T("smashp"),                0x02A33 },
	{ _T("smeparsl"),              0x029E4 },
	{ _T("smile"),                 0x02323 },
	{ _T("smt"),                   0x02AAA },
	{ _T("smte"),                  0x02AAC },
	{ _T("softcy"),                0x0044C },
	{ _T("SOFTcy"),                0x0042C },
	{ _T("sol"),                   0x0002F },
	{ _T("solb"),                  0x029C4 },
	{ _T("solbar"),                0x0233F },
	{ _T("spades"),                0x02660 },
	{ _T("sqcap"),                 0x02293 },
	{ _T("sqcup"),                 0x02294 },
	{ _T("sqsub"),                 0x0228F },
	{ _T("sqsube"),                0x02291 },
	{ _T("sqsup"),                 0x02290 },
	{ _T("sqsupe"),                0x02292 },
	{ _T("squ"),                   0x025A1 },
	{ _T("squf"),                  0x025AA },
	{ _T("sstarf"),                0x022C6 },
	{ _T("star"),                  0x02606 },
	{ _T("starf"),                 0x02605 },
	{ _T("straightphi"),           0x003D5 },
	{ _T("sub"),                   0x02282 },
	{ _T("Sub"),                   0x022D0 },
	{ _T("subdot"),                0x02ABD },
	{ _T("sube"),                  0x02286 },
	{ _T("subE"),                  0x02AC5 },
	{ _T("subedot"),               0x02AC3 },
	{ _T("submult"),               0x02AC1 },
	{ _T("subne"),                 0x0228A },
	{ _T("subnE"),                 0x02ACB },
	{ _T("subplus"),               0x02ABF },
	{ _T("subrarr"),               0x02979 },
	{ _T("subsim"),                0x02AC7 },
	{ _T("subsub"),                0x02AD5 },
	{ _T("subsup"),                0x02AD3 },
	{ _T("sum"),                   0x02211 },
	{ _T("sung"),                  0x0266A },
	{ _T("sup"),                   0x02283 },
	{ _T("Sup"),                   0x022D1 },
	{ _T("sup1"),                  0x000B9 },
	{ _T("sup2"),                  0x000B2 },
	{ _T("sup3"),                  0x000B3 },
	{ _T("supdot"),                0x02ABE },
	{ _T("supdsub"),               0x02AD8 },
	{ _T("supe"),                  0x02287 },
	{ _T("supE"),                  0x02AC6 },
	{ _T("supedot"),               0x02AC4 },
	{ _T("suphsub"),               0x02AD7 },
	{ _T("suplarr"),               0x0297B },
	{ _T("supmult"),               0x02AC2 },
	{ _T("supne"),                 0x0228B },
	{ _T("supnE"),                 0x02ACC },
	{ _T("supplus"),               0x02AC0 },
	{ _T("supsim"),                0x02AC8 },
	{ _T("supsub"),                0x02AD4 },
	{ _T("supsup"),                0x02AD6 },
	{ _T("swarhk"),                0x02926 },
	{ _T("swarr"),                 0x02199 },
	{ _T("swArr"),                 0x021D9 },
	{ _T("swnwar"),                0x0292A },
	{ _T("szlig"),                 0x000DF },
	{ _T("Tab"),                   0x00009 },
	{ _T("target"),                0x02316 },
	{ _T("tau"),                   0x003C4 },
	{ _T("Tau"),                   0x003A4 },
	{ _T("tbrk"),                  0x023B4 },
	{ _T("tcaron"),                0x00165 },
	{ _T("Tcaron"),                0x00164 },
	{ _T("tcedil"),                0x00163 },
	{ _T("Tcedil"),                0x00162 },
	{ _T("tcy"),                   0x00442 },
	{ _T("Tcy"),                   0x00422 },
	{ _T("tdot"),                  0x020DB },
	{ _T("telrec"),                0x02315 },
	{ _T("there4"),                0x02234 },
	{ _T("theta"),                 0x003B8 },
	{ _T("Theta"),                 0x00398 },
	{ _T("thetav"),                0x003D1 },
	{ _T("thinsp"),                0x02009 },
	{ _T("thorn"),                 0x000FE },
	{ _T("THORN"),                 0x000DE },
	{ _T("tilde"),                 0x002DC },
	{ _T("times"),                 0x000D7 },
	{ _T("timesb"),                0x022A0 },
	{ _T("timesbar"),              0x02A31 },
	{ _T("timesd"),                0x02A30 },
	{ _T("tint"),                  0x0222D },
	{ _T("top"),                   0x022A4 },
	{ _T("topbot"),                0x02336 },
	{ _T("topcir"),                0x02AF1 },
	{ _T("topfork"),               0x02ADA },
	{ _T("tprime"),                0x02034 },
	{ _T("trade"),                 0x02122 },
	{ _T("tridot"),                0x025EC },
	{ _T("trie"),                  0x0225C },
	{ _T("triminus"),              0x02A3A },
	{ _T("triplus"),               0x02A39 },
	{ _T("trisb"),                 0x029CD },
	{ _T("tritime"),               0x02A3B },
	{ _T("trpezium"),              0x023E2 },
	{ _T("tscy"),                  0x00446 },
	{ _T("TScy"),                  0x00426 },
	{ _T("tshcy"),                 0x0045B },
	{ _T("TSHcy"),                 0x0040B },
	{ _T("tstrok"),                0x00167 },
	{ _T("Tstrok"),                0x00166 },
	{ _T("twixt"),                 0x0226C },
	{ _T("uacute"),                0x000FA },
	{ _T("Uacute"),                0x000DA },
	{ _T("uarr"),                  0x02191 },
	{ _T("uArr"),                  0x021D1 },
	{ _T("Uarr"),                  0x0219F },
	{ _T("Uarrocir"),              0x02949 },
	{ _T("ubrcy"),                 0x0045E },
	{ _T("Ubrcy"),                 0x0040E },
	{ _T("ubreve"),                0x0016D },
	{ _T("Ubreve"),                0x0016C },
	{ _T("ucirc"),                 0x000FB },
	{ _T("Ucirc"),                 0x000DB },
	{ _T("ucy"),                   0x00443 },
	{ _T("Ucy"),                   0x00423 },
	{ _T("udarr"),                 0x021C5 },
	{ _T("udblac"),                0x00171 },
	{ _T("Udblac"),                0x00170 },
	{ _T("udhar"),                 0x0296E },
	{ _T("ufisht"),                0x0297E },
	{ _T("ugrave"),                0x000F9 },
	{ _T("Ugrave"),                0x000D9 },
	{ _T("uHar"),                  0x02963 },
	{ _T("uharl"),                 0x021BF },
	{ _T("uharr"),                 0x021BE },
	{ _T("uhblk"),                 0x02580 },
	{ _T("ulcorn"),                0x0231C },
	{ _T("ulcrop"),                0x0230F },
	{ _T("ultri"),                 0x025F8 },
	{ _T("umacr"),                 0x0016B },
	{ _T("Umacr"),                 0x0016A },
	{ _T("UnderBar"),              0x00332 },
	{ _T("UnderBrace"),            0x023DF },
	{ _T("UnderParenthesis"),      0x023DD },
	{ _T("uogon"),                 0x00173 },
	{ _T("Uogon"),                 0x00172 },
	{ _T("UpArrowBar"),            0x02912 },
	{ _T("uplus"),                 0x0228E },
	{ _T("upsi"),                  0x003C5 },
	{ _T("Upsi"),                  0x003D2 },
	{ _T("Upsilon"),               0x003A5 },
	{ _T("UpTeeArrow"),            0x021A5 },
	{ _T("urcorn"),                0x0231D },
	{ _T("urcrop"),                0x0230E },
	{ _T("uring"),                 0x0016F },
	{ _T("Uring"),                 0x0016E },
	{ _T("urtri"),                 0x025F9 },
	{ _T("utdot"),                 0x022F0 },
	{ _T("utilde"),                0x00169 },
	{ _T("Utilde"),                0x00168 },
	{ _T("utri"),                  0x025B5 },
	{ _T("utrif"),                 0x025B4 },
	{ _T("uuarr"),                 0x021C8 },
	{ _T("uuml"),                  0x000FC },
	{ _T("Uuml"),                  0x000DC },
	{ _T("uwangle"),               0x029A7 },
	{ _T("vangrt"),                0x0299C },
	{ _T("varr"),                  0x02195 },
	{ _T("vArr"),                  0x021D5 },
	{ _T("vBar"),                  0x02AE8 },
	{ _T("Vbar"),                  0x02AEB },
	{ _T("vBarv"),                 0x02AE9 },
	{ _T("vcy"),                   0x00432 },
	{ _T("Vcy"),                   0x00412 },
	{ _T("vdash"),                 0x022A2 },
	{ _T("vDash"),                 0x022A8 },
	{ _T("Vdash"),                 0x022A9 },
	{ _T("VDash"),                 0x022AB },
	{ _T("Vdashl"),                0x02AE6 },
	{ _T("veebar"),                0x022BB },
	{ _T("veeeq"),                 0x0225A },
	{ _T("vellip"),                0x022EE },
	{ _T("verbar"),                0x0007C },
	{ _T("Verbar"),                0x02016 },
	{ _T("VerticalSeparator"),     0x02758 },
	{ _T("vltri"),                 0x022B2 },
	{ _T("vrtri"),                 0x022B3 },
	{ _T("Vvdash"),                0x022AA },
	{ _T("vzigzag"),               0x0299A },
	{ _T("wcirc"),                 0x00175 },
	{ _T("Wcirc"),                 0x00174 },
	{ _T("wedbar"),                0x02A5F },
	{ _T("wedgeq"),                0x02259 },
	{ _T("weierp"),                0x02118 },
	{ _T("wreath"),                0x02240 },
	{ _T("xcap"),                  0x022C2 },
	{ _T("xcirc"),                 0x025EF },
	{ _T("xcup"),                  0x022C3 },
	{ _T("xdtri"),                 0x025BD },
	{ _T("xharr"),                 0x027F7 },
	{ _T("xhArr"),                 0x027FA },
	{ _T("xi"),                    0x003BE },
	{ _T("Xi"),                    0x0039E },
	{ _T("xlarr"),                 0x027F5 },
	{ _T("xlArr"),                 0x027F8 },
	{ _T("xmap"),                  0x027FC },
	{ _T("xnis"),                  0x022FB },
	{ _T("xodot"),                 0x02A00 },
	{ _T("xoplus"),                0x02A01 },
	{ _T("xotime"),                0x02A02 },
	{ _T("xrarr"),                 0x027F6 },
	{ _T("xrArr"),                 0x027F9 },
	{ _T("xsqcup"),                0x02A06 },
	{ _T("xuplus"),                0x02A04 },
	{ _T("xutri"),                 0x025B3 },
	{ _T("xvee"),                  0x022C1 },
	{ _T("xwedge"),                0x022C0 },
	{ _T("yacute"),                0x000FD },
	{ _T("Yacute"),                0x000DD },
	{ _T("yacy"),                  0x0044F },
	{ _T("YAcy"),                  0x0042F },
	{ _T("ycirc"),                 0x00177 },
	{ _T("Ycirc"),                 0x00176 },
	{ _T("ycy"),                   0x0044B },
	{ _T("Ycy"),                   0x0042B },
	{ _T("yen"),                   0x000A5 },
	{ _T("yicy"),                  0x00457 },
	{ _T("YIcy"),                  0x00407 },
	{ _T("yucy"),                  0x0044E },
	{ _T("YUcy"),                  0x0042E },
	{ _T("yuml"),                  0x000FF },
	{ _T("Yuml"),                  0x00178 },
	{ _T("zacute"),                0x0017A },
	{ _T("Zacute"),                0x00179 },
	{ _T("zcaron"),                0x0017E },
	{ _T("Zcaron"),                0x0017D },
	{ _T("zcy"),                   0x00437 },
	{ _T("Zcy"),                   0x00417 },
	{ _T("zdot"),                  0x0017C },
	{ _T("Zdot"),                  0x0017B },
	{ _T("ZeroWidthSpace"),        0x0200B },
	{ _T("zeta"),                  0x003B6 },
	{ _T("Zeta"),                  0x00396 },
	{ _T("Zfr"),                   0x02128 },
	{ _T("zhcy"),                  0x00436 },
	{ _T("ZHcy"),                  0x00416 },
	{ _T("zigrarr"),               0x021DD },
	{ _T("zwj"),                   0x0200D },
	{ _T("zwnj"),                  0x0200C },
};


static struct Map_Tags {

	LPCTSTR szTag;
	TAGS     tgStart;
	TAGS     tgEnd;

} Tags[] = {
    {  _T("a"),      tgA_S,      tgA_E      },
	{  _T("br"),     tgBr,       tgUnknown  },
	{  _T("p"),      tgPara_S,   tgPara_E   },
	{  _T("table"),  tgTable_S,  tgTable_E  },
	{  _T("tr"),     tgTr_S,     tgTr_E     },
	{  _T("td"),     tgTd_S,     tgTd_E     },
	{  _T("th"),     tgTh_S,     tgTh_E     },
	{  _T("ol"),     tgOl_S,     tgOl_E     },
	{  _T("ul"),     tgUl_S,     tgUl_E     },
	{  _T("li"),     tgLi_S,     tgLi_E     },
	{  _T("div"),    tgDiv_S,    tgDiv_E    },
	{  _T("span"),   tgSpan_S,   tgSpan_E },
	{  _T("blockquote"),   tgBlockquote_S,   tgBlockquote_E  },
	{  _T("h1"),     tgH_S,      tgH_E      },
	{  _T("h2"),     tgH_S,      tgH_E      },
	{  _T("h3"),     tgH_S,      tgH_E      },
	{  _T("h4"),     tgH_S,      tgH_E      },
	{  _T("h5"),     tgH_S,      tgH_E      },
	{  _T("h6"),     tgH_S,      tgH_E      },
	{ _T("pre"),     tgPre_S,    tgPre_E    },
	{  _T("title"),  tgTitle_S,  tgUnknown  },
	{  _T("style"),  tgStyle_S,  tgUnknown  },
	{  _T("option"), tgOption_S, tgUnknown  },
	{  _T("xml"),    tgXml_S,    tgUnknown  },
	{  _T("script"), tgScript_S, tgUnknown  },
	{  _T("!--[if supportfields]"), tgIfFields_S,       tgUnknown },
	{  _T("![if !supportlists]"),   tgIfSupportLists_S, tgUnknown },
	
};


static struct Map_Codepage {

	LPCTSTR stName;
	int     nCP;

} Codepages[] =  {
	{ _T("us-ascii"),		 1252 },
	{ _T("windows-1250"),	 1250 },
	{ _T("windows-1251"),	 1251 },
	{ _T("windows-1252"),	 1252 },
	{ _T("windows-1253"),	 1253 },
	{ _T("windows-1254"),	 1254 },
	{ _T("windows-1255"),	 1255 },
	{ _T("windows-1256"),	 1256 },
	{ _T("windows-1257"),	 1257 },
	{ _T("windows-1258"),	 1258 },
	{ _T("iso-8859-1"),		 1252 },
	{ _T("iso-8859-2"),		28592 },
	{ _T("iso-8859-3"),		28593 },
	{ _T("iso-8859-4"),		28594 },
	{ _T("iso-8859-5"),		28595 },
	{ _T("iso-8859-6"),		28596 },
	{ _T("iso-8859-7"),		28597 },
	{ _T("iso-8859-8"),		28598 },
	{ _T("iso-8859-9"),		28599 },
	{ _T("iso-8859-15"),	28605 },
	{ _T("utf-7"),			65000 },
	{ _T("utf-8"),			65001 },
	{ _T("utf-16"),			1200 },
	{ _T("unicodefffe"),	1201 },
	{ _T("windows-874"),	  874 },
	{ _T("shift_jis"),		  932 },
	{ _T("iso-2022-jp"),	  932 },
	{ _T("gb2312"),			  936 },
	{ _T("ks_c_5601-1987"),   949 },
	{ _T("big5"),			  950 },

	{ _T("ibm037"),			   37 },
	{ _T("ibm437"),			  437 },
	{ _T("ibm500"),			  500 },
	{ _T("ibm720"),			  720 },
	{ _T("ibm737"),			  737 },
	{ _T("ibm775"),			  775 },
	{ _T("ibm850"),			  850 },
	{ _T("ibm852"),			  852 },
	{ _T("ibm855"),			  855 },
	{ _T("ibm857"),			  857 },
	{ _T("ibm858"),			  858 },
	{ _T("ibm860"),			  860 },
	{ _T("ibm861"),			  861 },
	{ _T("ibm862"),			  862 },
	{ _T("ibm863"),			  863 },
	{ _T("ibm865"),			  865 },
	{ _T("cp866"),			  866 },
	
	{ _T("macintosh"),		10000 },
	{ _T("x-cp20261"),		20261 },
	{ _T("x-cp50227"),		50227 },

	{ _T("koi8-r"),			20866 },
	{ _T("csiso2022jp"),	50221 },
	{ _T("iso-2022-kr"),	50225 },
	{ _T("euc-kr"),			50225 },
	{ _T("euc-jp"),			51932 },
	{ _T("euc-cn"),			51936 },
	{ _T("hz-gb-2312"),		52936 },
	{ _T("gb18030"),		54936 },
	
};


#define SIZE(Array) ( sizeof(Array) / sizeof(Array[0]) )

static void  ProcessTag(LPCTSTR szTrgStart, LPTSTR& szTrg, LPCTSTR& szTagStart, LinkInfo* pLinkInfo);
static int   LeadingNewlines(LPCTSTR szTrgLeft, LPCTSTR szTrg);
static void  WriteNewLines(LPTSTR& szTrg, int nCount);
static void  SkipSpaces(LPCTSTR szTrgLeft, LPTSTR& szTrg);
static TAGS  GetTag(LPCTSTR szTag);
static BOOL  Check_Tag(LPCTSTR szTag, LPCTSTR szComp);
static TCHAR EntityToChar(LPCTSTR& szStart, BOOL bASCII, WCHAR& charExt);
static WCHAR WingdingsToChar(WCHAR c, WCHAR& charExt);
static int   FrontLineBreaks(LPTSTR szSrc, LPTSTR& szFirtNonSpace);
static void  JumpOver(LPCTSTR& szSrc, LPCTSTR szSearch);
static void  JumpOverFirst(LPCTSTR& szSrc, LPCTSTR szSearch1, LPCTSTR szSearch2);
static void  SkipWhiteSpaces(LPCTSTR& szStr);
static WCHAR ACharToWChar(CHAR chAnsi);
static CHAR  WCharToAChar(WCHAR chUnicode);
static int   FindNoCase(LPCTSTR szSrc, LPCTSTR szFind, int nStart = 0);
static TCHAR lcase (TCHAR c);
static UINT  GetCodepageFromName(LPCTSTR stCP);
static void  ExtractEncoding(LPCTSTR stHtml, LPTSTR szRes, int nResLen);
static void FixURL(LPTSTR pURL);

static TAGS lastTag = tgUnknown;
static BOOL bInTD = FALSE;
static BOOL bInLI = FALSE;
static BOOL bPre = FALSE;
static BOOL inWingdings = FALSE;

#ifdef _UNICODE
BOOL WINAPI HTMLToTextW(LPCTSTR szHTML, LPTSTR szText, BOOL bPreferASCII, LPTSTR szEncoding, int nEncodingLen, UINT* pCodePage, std::vector<LinkInfo>* pLinks)
#else
BOOL WINAPI HTMLToTextA(LPCTSTR szHTML, LPTSTR szText, BOOL bPreferASCII, LPTSTR szEncoding, int nEncodingLen, UINT* pCodePage, std::vector<LinkInfo>* pLinks)
#endif
{
	if(szHTML == NULL || szText == NULL)
		return FALSE;

	*szText	= _T('\0');

	lastTag = tgUnknown;
	bInTD = FALSE;
	bInLI = FALSE;
	bPre  = FALSE;

//	TCHAR EncodingBuf[32] = _T("");
//	ExtractEncoding(szHTML, EncodingBuf, sizeof(EncodingBuf)/sizeof(TCHAR));
//	for(LPTSTR pR = EncodingBuf; *pR; pR++) {
//		*pR = lcase(*pR);
//	}
//
//	UINT nCodePage = GetCodepageFromName(EncodingBuf);
//	
//	
//#ifdef _UNICODE
//
//	BOOL bCodepageInstalled = (nCodePage > 0);
//
//	WCHAR* pUnicode = NULL;
//
//	if(nCodePage > 0 && nCodePage != GetACP())
//	{
//		int nLen = _tcslen(szHTML);
//		char* pBytes = new char[nLen+1];
//			
//		WideCharToMultiByte(CP_ACP, 0, szHTML, nLen, pBytes, nLen+1, NULL, NULL);
//
//		pUnicode = new WCHAR[nLen+1]; 
//		
//		int nWideChars = MultiByteToWideChar(nCodePage, 0, pBytes, nLen, pUnicode, nLen+1);
//		if(nWideChars != 0)
//		{
//			pUnicode[nWideChars] = 0;
//			szHTML = pUnicode;
//		}
//		else 
//		{
//			delete[] pUnicode;
//			pUnicode = NULL;
//			bCodepageInstalled = FALSE;
//		}
//
//		delete[] pBytes;
//	}
//
//
//#else
//
//
//	BOOL bCodepageInstalled = (nCodePage > 0 && GetACP() == nCodePage);
//
//	char* pBytes = NULL;
//
//	if(nCodePage == 65000 || nCodePage == 65001)
//	{
//		int nLen = _tcslen(szHTML);
//		WCHAR* pUnicode = new WCHAR[nLen+1];
//			
//		int nWideChars = MultiByteToWideChar(nCodePage, 0, szHTML, nLen, pUnicode, nLen+1);
//		if(nWideChars > 0) 
//		{
//			pBytes = new char[nWideChars+1]; 
//			int nBytes = WideCharToMultiByte(CP_ACP, 0, pUnicode, nWideChars, pBytes, nWideChars+1, NULL, NULL);
//			if(nBytes > 0)
//			{
//				pBytes[nBytes] = 0;
//				szHTML = pBytes;
//				bCodepageInstalled = TRUE;
//			}
//			else
//			{
//				delete[] pBytes;
//				pBytes = NULL;
//			}
//		}
//		delete[] pUnicode;
//	}
//
//#endif
//
    LinkInfo linkInfo = {0};
    LinkInfo* pLinkInfo = (pLinks ? &linkInfo : NULL);
	
	LPTSTR  szTextStart = szText;
	
	
	for(; *szHTML; szHTML++)
	{
		TCHAR Char = *szHTML;
		
		if(Char == _T('<') && szHTML[1] > _T(' ') && szHTML[1] != _T('<'))	
		{
			ProcessTag(szTextStart, szText, szHTML, pLinkInfo);

            if(pLinks && linkInfo.len > 0 && linkInfo.szLink) 
            {
                //*szText = 0;
                //TRACE("%s \n", szTextStart + linkInfo.idxStart);

                while(szTextStart[linkInfo.idxStart] <= _T(' ') && linkInfo.len > 0) 
                {
                    linkInfo.idxStart++; 
                    linkInfo.len--; 
                }

                while(szTextStart[linkInfo.idxStart + linkInfo.len - 1] <= _T(' ') && linkInfo.len > 0) 
                {
                    linkInfo.len--; 
                }

                if(linkInfo.len > 0) {
                    pLinks->push_back(linkInfo);
                    linkInfo.szLink = NULL;
                }
                linkInfo.len = 0;
            }

			if(*szHTML)
				continue;
			else
				break;
		}
		
		
		if(!bPre)
		{
			if( Char == _T(' ') || Char == _T('\r') || Char == _T('\n')  || Char == _T('\t') )
			{
				if(szText == szTextStart)
					continue;

				if(szText[-1] == _T(' ') || szText[-1] == _T('\n'))
					continue;

				Char =  _T(' ');
			}
		}
		else
		{
			if(Char == _T('\n')) {
				*szText++ = _T('\r');  
				*szText++ = _T('\n'); 
				continue;
			}
			if(Char == _T('\r')) {
				if(szHTML[1] != '\n') {
					*szText++ = _T('\r');  
					*szText++ = _T('\n'); 
				}
				continue;
			}
		}

#ifdef _UNICODE
		const BOOL preferANSI = FALSE;
#else
		const BOOL preferANSI = TRUE;
#endif
		WCHAR charExt = 0;
		if(Char == _T('&') && szHTML[1] > _T(' ') )	
			Char = EntityToChar(szHTML, preferANSI, charExt);
#ifdef _UNICODE
		if (inWingdings) {
			Char = WingdingsToChar(Char, charExt);			
		}
#endif
		if (Char != _T('\xAD')) {//  geschützter Bindestrich wird ignoriert!
			*szText++ = Char;
			if (charExt != 0) {
				*szText++ = charExt;
			}
		}		
	}
	
	*szText = _T('\0');

    if(linkInfo.szLink)
        delete [] (TCHAR*)linkInfo.szLink;

// zu viele Leerzeilen am Anfang auf eine Leerzeile reduzieren:
	LPTSTR szWrite = NULL;
	if(FrontLineBreaks(szTextStart, szWrite) > 1)
	{
		while(*szWrite-- != _T('\r'));

		while(szWrite >= szTextStart)
			*szWrite-- = _T(' ');
	}

	//if(pCodePage)
	//	*pCodePage = nCodePage;

	/*if(szEncoding && nEncodingLen > 0) {
		int nLenCopy = min(_tcslen(EncodingBuf) , (unsigned)nEncodingLen-1);
		_tcsncpy(szEncoding, EncodingBuf, nLenCopy);
		szEncoding[nLenCopy] = 0;
	}*/

//#ifdef _UNICODE
//
//	if(pUnicode)
//		delete[] pUnicode;
//
//#else
//
//	if(pBytes)
//		delete[] pBytes;
//
//#endif

//	return bCodepageInstalled;
	return 1;
}

inline static int FrontLineBreaks(LPTSTR szSrc, LPTSTR& szFirstNonSpace)
{
	int nCRLFCount = 0;

	for(; *szSrc; szSrc++)
	{
		if(*szSrc == _T('\r') || *szSrc == _T(' ') || *szSrc == _T('\xA0') || *szSrc == _T('\t'))
			continue;

		if(*szSrc == _T('\n'))
			nCRLFCount++;
		else
			break;
	}
	
	szFirstNonSpace = szSrc;
	return nCRLFCount;
}

inline static void ProcessTag(LPCTSTR szTrgStart, LPTSTR& szTrg, LPCTSTR& szTagStart, LinkInfo* pLinkInfo)
{
	TCHAR Tag[64];
	int n = 0;
		
	szTagStart++;
	
	if(szTagStart[0] == _T('!') && szTagStart[1] == _T('-') && szTagStart[2] == _T('-')) {
		JumpOverFirst(szTagStart, _T("-->"), _T("--!>"));
		return;
	}

	int nTagLevel = 1;

    LPCTSTR szTagStartOrig = szTagStart;

	while(*szTagStart)
	{
		if(*szTagStart == _T('<'))
			nTagLevel++;

		if(*szTagStart == _T('>'))
			nTagLevel--;

		if(nTagLevel == 0)
			break;

		if(n < SIZE(Tag) - 1)
			Tag[n++] = lcase(*szTagStart);
	
		szTagStart++;
	}
    Tag[n] = _T('\0');

	TAGS currTag = GetTag(Tag);
	if(currTag == tgUnknown)
		return;


	switch(currTag)	{
	case tgStyle_S:
	case tgOption_S:
	case tgXml_S: 
	case tgIfFields_S:
	case tgIfSupportLists_S:
	case tgSpan_S:
    case tgA_S:
		break;

	default: if(bInTD == FALSE && bInLI == FALSE) 
				 SkipSpaces(szTrgStart, szTrg);
	}


	switch(currTag)
	{
		case tgBr:

			if(LeadingNewlines(szTrgStart, szTrg) < 4)
			{
				*szTrg++ = _T('\r');
				*szTrg++ = _T('\n');
			}
			break;

        case tgA_S:

            if(pLinkInfo)
            {
                int pos = -1;

                while(true)
                {
                    pos = FindNoCase(szTagStartOrig, _T("href"), pos+1);
                    if(pos < 0) break;
                
                    TCHAR prev = szTagStartOrig[pos-1];
                    if(prev <= _T(' ')) {
                        TCHAR next = szTagStartOrig[pos+4];
                        if(next <= _T(' ') || next == _T('='))
                            break;
                    }
                }

                if(pos > -1)
                {
                    pos += 4;
                    while(szTagStartOrig[pos] <= _T(' ') && szTagStartOrig[pos]!=_T('\0')) pos++;

                    if(szTagStartOrig[pos] == _T('=')) {
                        ++pos;
                        while(szTagStartOrig[pos] <= _T(' ') && szTagStartOrig[pos]!=_T('\0')) pos++;

                        if(szTagStartOrig[pos] == _T('\"')) {

                            ++pos;
                            int start = pos;

                            while(szTagStartOrig[pos] != _T('\"') && szTagStartOrig[pos]!=_T('\0')) pos++;

                            int len = pos-start;
                            if(szTagStartOrig[pos] == _T('\"') && len>0) {

                                if(pLinkInfo->szLink)
                                    delete [] (TCHAR*)pLinkInfo->szLink;

                                LPTSTR szLink = new TCHAR[len+1];
                                _tcsncpy(szLink, &szTagStartOrig[start], len);
                                szLink[len] = _T('\0');
								FixURL(szLink);
                                pLinkInfo->szLink = szLink;
                            }
                        }
						else if (szTagStartOrig[pos] == _T('\'')) {

							++pos;
							int start = pos;

							while (szTagStartOrig[pos] != _T('\'') && szTagStartOrig[pos] != _T('\0')) pos++;

							int len = pos - start;
							if (szTagStartOrig[pos] == _T('\'') && len>0) {

								if (pLinkInfo->szLink)
									delete[](TCHAR*)pLinkInfo->szLink;

								LPTSTR szLink = new TCHAR[len + 1];
								_tcsncpy(szLink, &szTagStartOrig[start], len);
								szLink[len] = _T('\0');
								FixURL(szLink);
								pLinkInfo->szLink = szLink;
							}
						}
                        else { // invalid HTML, no " around href attribute value
                        
                            int start = pos;

                            while(szTagStartOrig[pos] > _T(' ') && szTagStartOrig[pos] != _T('>') && szTagStartOrig[pos]!=_T('\0')) pos++;

                            int len = pos-start;
                            if(szTagStartOrig[pos] != _T('\0') && len > 0) {

								if (pLinkInfo->szLink) {
									delete[](TCHAR*)pLinkInfo->szLink;
									pLinkInfo->szLink = NULL;
								}

								if (szTagStartOrig[start] == _T('\'')) start++;
								if (szTagStartOrig[pos-1] == _T('\'')) pos--;

								len = pos - start;
								if (len > 0) {
									LPTSTR szLink = new TCHAR[len + 1];
									_tcsncpy(szLink, &szTagStartOrig[start], len);
									szLink[len] = _T('\0');
									pLinkInfo->szLink = szLink;
								}
                            }
                        }
                    }
                }

                pLinkInfo->idxStart = szTrg - szTrgStart;
				pLinkInfo->len = 0;
            }
            break;

		case tgA_E: {

			const unsigned int pos = (szTrg - szTrgStart);
			if (pos > pLinkInfo->idxStart) {
				pLinkInfo->len = pos - pLinkInfo->idxStart;
			}
			else {
				pLinkInfo->len = 0;
			}
			break;
		}
		case tgOl_S:   case tgOl_E:
		case tgUl_S:   case tgUl_E:
		case tgH_S:    case tgH_E:
		case tgBlockquote_S: case tgBlockquote_E:
		{
			int nNewLines = 2 - LeadingNewlines(szTrgStart, szTrg);
			
			if(nNewLines > 0 && !bInLI)
				WriteNewLines(szTrg, nNewLines);

			break;
		}	
		
		case tgPara_S: case tgPara_E:
		{
			int nNewLines = 2 - LeadingNewlines(szTrgStart, szTrg);
			
			if(nNewLines > 0 && !bInTD && !bInLI)
				WriteNewLines(szTrg, nNewLines);

			break;
		}	

		case tgDiv_S: case tgDiv_E:
		{
			if(LeadingNewlines(szTrgStart, szTrg) == 0 && !bInTD && !bInLI)
				WriteNewLines(szTrg, 1);

			break;
		}


		case tgTable_S:
		{
			int nStdNewLines = (lastTag == tgTd_S  ?  2 : 1);			

			int nNewLines = nStdNewLines - LeadingNewlines(szTrgStart, szTrg);
			
			if(nNewLines > 0)
				WriteNewLines(szTrg, nNewLines);

			break;
		}

		case tgTable_E:

			if(LeadingNewlines(szTrgStart, szTrg) == 0)
			{
				*szTrg++ = _T('\r');
				*szTrg++ = _T('\n');
			}
			break;
			

		case tgLi_S:

			if(LeadingNewlines(szTrgStart, szTrg) == 0)
			{
				*szTrg++ = _T('\r');
				*szTrg++ = _T('\n');
			}

			*szTrg++ = _T(' ');
			*szTrg++ = _T('-');
			*szTrg++ = _T(' ');
			break;		


		case tgTr_S:
		
			if(lastTag == tgTable_S)
				break;
			
			if(LeadingNewlines(szTrgStart, szTrg) < 2)
			{
				*szTrg++ = _T('\r');
				*szTrg++ = _T('\n');
			}
			break;
		
		

		case tgTd_S: 
		case tgTh_S: 
			
			if(LeadingNewlines(szTrgStart, szTrg) == 0)
				*szTrg++ = _T('\t');
				
			break;
		
		
		case tgPre_S:
			bPre = true;
			break;

		case tgPre_E:
			bPre = false;
			break;


		case tgTitle_S:
		
			JumpOver(szTagStart, _T("</title>"));
			break;
		

		case tgStyle_S:

			JumpOver(szTagStart, _T("</style>"));
			break;


		case tgOption_S:

			JumpOver(szTagStart, _T("</option>"));
			break;


		case tgXml_S:
		
			JumpOver(szTagStart, _T("</xml>"));
			break;

		case tgScript_S:
		
			JumpOver(szTagStart, _T("</script>"));
			break;

		case tgIfFields_S:
		
			JumpOver(szTagStart, _T("<![endif]-->"));
			break;
		

		case tgIfSupportLists_S:
		
			JumpOver(szTagStart, _T("<![endif]>"));
			*szTrg++ = _T('*');
			*szTrg++ = _T(' ');
			break;

			
		case tgSpan_S: {

			LPCTSTR szFind = _tcsstr(Tag, _T("display"));
			if (szFind)
			{
				szFind += 7;
				SkipWhiteSpaces(szFind);
				if (*szFind != _T(':'))
					break;
				szFind++;
				SkipWhiteSpaces(szFind);
				if (szFind != _tcsstr(szFind, _T("none")))
					break;

				JumpOver(szTagStart, _T("</span>"));
			}
			else {
				const int posWingdings = FindNoCase(Tag, _T("Wingdings"));
				if (posWingdings > 0) {
					const int posFontFamily = FindNoCase(Tag, _T("font-family"));
					const int posStyle = FindNoCase(Tag, _T("style"));
					if (posStyle > 0 && posFontFamily > 0) {
						inWingdings = true;
					}
				}
			}
			break;
		}

		case tgSpan_E:
			inWingdings = false;
			break;

	}

	switch(currTag) 
	{
		case tgLi_E:
		case tgOl_E:
		case tgUl_E:
		case tgH_E:
		case tgPara_E:
		case tgTd_E:
		case tgTable_E:
			bInTD = bInLI = FALSE;
			break;
		case tgTd_S:
			bInTD = TRUE;
			break;
		case tgLi_S:
			bInLI = TRUE;
			break;
	}

	lastTag = currTag;
}

inline static void SkipWhiteSpaces(LPCTSTR& szStr)
{
	for(; *szStr; szStr++)
		if(*szStr > _T(' '))
			return;
}

inline static void JumpOver(LPCTSTR& szSrc, LPCTSTR szSearch)
{
	int posEnd = FindNoCase(szSrc, szSearch);
	if(posEnd != -1)
	{
		szSrc += posEnd;	
		szSrc += _tcslen(szSearch) - 1;
	}
}

inline static  void  JumpOverFirst(LPCTSTR& szSrc, LPCTSTR szSearch1, LPCTSTR szSearch2)
{
	int posEnd1 = FindNoCase(szSrc, szSearch1);
	int posEnd2 = FindNoCase(szSrc, szSearch2);
	if(posEnd1 != -1 && (posEnd2 == -1 || posEnd1 < posEnd2))
	{
		szSrc += posEnd1;	
		szSrc += _tcslen(szSearch1) - 1;
	}

	if(posEnd2 != -1 && (posEnd1 == -1 || posEnd2 < posEnd1))
	{
		szSrc += posEnd2;	
		szSrc += _tcslen(szSearch2) - 1;
	}
}

inline static TAGS GetTag(LPCTSTR szTag)
{
	for(int i = 0; i < SIZE(Tags); i++)
	{
		switch(Check_Tag(szTag, Tags[i].szTag))
		{
			case 1:	return Tags[i].tgStart;
			case 2: return Tags[i].tgEnd; 
		}
	}
	return tgUnknown;
}

inline static int Check_Tag(LPCTSTR szTag, LPCTSTR szComp)
{
	if(szTag[0] == _T('/'))
	{
		if(_tcsstr(szTag+1, szComp) == szTag+1)
		{
			int nLen = _tcslen(szComp);
			if( szTag[nLen+1] == _T('\0') )
				return 2;
		}
		return 0;
	}
	
	if(_tcsstr(szTag, szComp) == szTag)
	{
		int nLen = _tcslen(szComp);
		if((szTag[nLen] == _T('\0') || szTag[nLen] == _T(' ') || szTag[nLen] == _T('\t') || szTag[nLen] == _T('\r') || szTag[nLen] == _T('\n')))
			return 1;
	}
	return 0;
}


static int LeadingNewlines(LPCTSTR szTrgLeft, LPCTSTR szTrg)
{
	int nCRLFCount = 0;

	for(--szTrg; szTrg >= szTrgLeft; szTrg--)
	{
		if(*szTrg == _T('\r') || *szTrg == _T(' ') || *szTrg == _T('\xA0') || *szTrg == _T('\t'))
			continue;

		if( *szTrg == _T('\n') )
			nCRLFCount++;
		else
			return nCRLFCount;
	}
	return nCRLFCount;
}

inline static bool AnyPrintableCharacterOnLine(LPCTSTR szTrgLeft, LPTSTR szTrg) 
{
	for (; szTrg > szTrgLeft; szTrg--) 
	{
		if (*szTrg == _T('\r') || *szTrg == _T(' ') || *szTrg == _T('\xA0') || *szTrg == _T('\t'))
			continue;

		return *szTrg != _T('\n');
	}
	return false;
}

inline static void SkipSpaces(LPCTSTR szTrgLeft, LPTSTR& szTrg)
{
	for(; szTrg > szTrgLeft; szTrg--)
	{
		const TCHAR Char = szTrg[-1];
		if( Char != _T(' ') && Char != _T('\xA0') && Char != _T('\t') )
			return;

		if (Char == _T('\xA0') && AnyPrintableCharacterOnLine(szTrgLeft, szTrg)) {
			return;
		}
	}
}

inline static void WriteNewLines(LPTSTR& szTrg, int nCount)
{
	for(; nCount > 0; nCount--)
	{
		*szTrg++ = _T('\r');
		*szTrg++ = _T('\n');
	}
}



inline static int WingdingsToUnicode(WCHAR c) {
	switch (c) {
	case '(': return 0x1F57F; // Black touchtone telephone
	case ')': return 0x2706; // Telephone location sign
	case '*': return 0x1F582; // Back of envelope
	case '+': return 0x1F583; // Stamped envelope
	case 'A': return 0x270C; // Victory hand
	case 'B': return 0x1F44C; // OK hand sign
	case 'C': return 0x1F44D; // Thumbs up sign
	case 'D': return 0x1F44E; // Thumbs down sign	
	case 'E': return 0x261C; // White left pointing index
	case 'F': return 0x261E; // White right pointing index
	case 'G': return 0x261D; // White up pointing index
	case 'H': return 0x261F; // White down pointing index
	case 'I': return 0x1F590;  // Raised hand with fingers splayed
	case 'J': return 0x263A;  // White smiling face
	case 'K': return 0x1F610; // Neutral face
	case 'L': return 0x2639; // White frowning face
	case 'M': return 0x1F4A3; // Bomb
	case 'N': return 0x2620; // Skull and crossbones
	case 'O': return 0x1F3F3; // Waving white flag
	case 'P': return 0x1F3F1; // White pennant
	case 'Q': return 0x2708; // Airplane
	case 'R': return 0x263C; // White sun with rays
	case 'S': return 0x1F4A7; // Droplet
	case 'T': return 0x2744; // Snowflake
	case 'U': return 0x1F546; // White Latin cross
	case 'V': return 0x271E; // Shadowed white Latin cross
	case 'W': return 0x1F548; // Celtic cross
	case 'X': return 0x2720; // Maltese cross
	case 'Y': return 0x2721; // Star of David
	case 'Z': return 0x262A; // Star and crescent
	case '[': return 0x262F; // Yin Yang
	case ']': return 0x2638; // Wheel of Dharma
	case 0xFB: return 0x1F5F6; // Ballot bold script X
	case 0xFC: return 0x2714;  // Heavy check mark
	case 0xFD: return 0x1F5F7; // Ballot box with bold script X
	case 0xFE: return 0x1F5F9; // Ballot box with bold check
	default: return c;
	}
}

inline static WCHAR WingdingsToChar(WCHAR c, WCHAR& charExt) {
	const int code = WingdingsToUnicode(c);
	if (code > 0xFFFF) { // UTF-16 encode:
		const int x = code - 0x10000;
		const int low = 0xDC00 | (x & 0x3FF);
		const int hig = 0xD800 | ((x & 0xFFC00) >> 10);
		charExt = (WCHAR)low;
		return (WCHAR)hig;
	}
	else {
		return (WCHAR)code;
	}
}

// Wandelt HTMl-Entities in Zeichen um.
// Übernimt Pointer auf '&' und verschiebt diesen auf ';', wenn erfolgreich
// bzw. lässt Pointer unverändert, wenn das Entity nicht umgewandelt werden 
// konnte.
inline static TCHAR EntityToChar(LPCTSTR& szStart, BOOL bASCII, WCHAR& charExt)
{
	TCHAR Entity[24] = _T("");
	int   n = 0;
	int   nOffset = 1;

	while(szStart[nOffset] && szStart[nOffset] != _T(';'))
	{
		if(n < SIZE(Entity) - 1)
			Entity[n++] = szStart[nOffset];
	
		nOffset++;
	}
	
	if(szStart[nOffset] == 0 || nOffset < 2 || nOffset > 9) 
		return _T('&');

	if(Entity[0] == _T('#'))
	{
		int res = 0;
		
		if(Entity[1] == _T('x') || Entity[1] == _T('X'))
			res = _tcstoul(Entity+2, NULL, 16);
		else
			res = _tcstoul(Entity+1, NULL, 10);
		
		if(res <= 0)
			return _T('&');

		szStart += nOffset; 			// Erfolgreich -> Pointer verschieben!!

		if(bASCII)
		{
			if(res == 8209 || res == 8212 || res == 8211)
				return _T('-');
			   
			if(res == 8226)
				return _T('*');
			
			if(res == 8220 || res == 8221)
				return _T('\"');
			
			if(res == 8217)
				return _T('\'');
		
		}

#ifdef _UNICODE
		if (res > 0xFFFF) {
			const int x = res - 0x10000;
			const int low = 0xDC00 | (x & 0x3FF);
			const int hig = 0xD800 | ((x & 0xFFC00) >> 10);

			charExt = (WCHAR)low;
			return (WCHAR)hig;
		}
		else {
			return (WCHAR)res;
		}
#else
		return WCharToAChar((WCHAR)res);
#endif

	}

	auto search = Entities.find(Entity);
	if (search != Entities.end()) {
		szStart += nOffset;
		return search->second;
	}	
	
	return _T('&');		// Entity konnte nicht erkannt werden
}


static void ExtractEncoding(LPCTSTR stHtml, LPTSTR szRes, int nResLen)
{
	if(stHtml == NULL || szRes == NULL || nResLen <= 0) return;
	szRes[0] = 0;
	int nIdxMeta = 0, nIdxEnd = 0, nIdxHttp = 0;
		
	while(true)
	{
		nIdxMeta = FindNoCase(stHtml, _T("<meta"), nIdxEnd);
		if(nIdxMeta == -1) return;
		nIdxEnd  = FindNoCase(stHtml, _T(">"), nIdxMeta);
		nIdxHttp = FindNoCase(stHtml, _T("http-equiv"), nIdxMeta);
		if(nIdxHttp == -1) return;
		if(nIdxEnd < nIdxHttp) continue;
		nIdxHttp += 10;
		while(stHtml[nIdxHttp] <= 32 || stHtml[nIdxHttp] == _T('=') || stHtml[nIdxHttp] == _T('\"'))
			nIdxHttp++;
		if(nIdxHttp != FindNoCase(stHtml, _T("Content-Type"), nIdxHttp))
			continue;

		int nIdxCharset = FindNoCase(stHtml, _T("charset"), nIdxMeta);
		if(nIdxCharset > nIdxEnd) return;
		nIdxCharset += 7;
		while(stHtml[nIdxCharset] <= 32 || stHtml[nIdxCharset] == _T('='))
			nIdxCharset++;

		int nIdxCharsetEnd = -1;
		for(int n = nIdxCharset; nIdxCharsetEnd == -1 && stHtml[n]; n++) {
			switch(stHtml[n]) {
			case _T('\"'): case _T(';'): case _T('>'):
			case _T('<'):  case _T(' '): case _T('\t'):
				nIdxCharsetEnd = n;
				break;
			}
		}
		
		if(nIdxCharsetEnd == -1) return;
		int nLenCopy = min(nIdxCharsetEnd-nIdxCharset, nResLen-1);
		_tcsncpy(szRes, stHtml+nIdxCharset, nLenCopy);
		szRes[nLenCopy] = 0;
		
	}
}

static UINT GetCodepageFromName(LPCTSTR stCP)
{
	if (stCP == NULL || stCP[0] == 0)
		return 1252;

	for(int i = 0; i < SIZE(Codepages); i++)
	{
		if(_tcscmp(Codepages[i].stName, stCP) == 0)
			return Codepages[i].nCP;
	}

	return 0;
}

/*
inline static WCHAR ACharToWChar(CHAR chAnsi)
{
	WCHAR chwTrg;
	MultiByteToWideChar(1252, 0, &chAnsi, 1, &chwTrg, 1);
	return chwTrg;
}
*/

inline static CHAR WCharToAChar(WCHAR chUnicode)
{
	CHAR chTrg;
	CHAR defaultChar = ' ';
    //#define WC_NO_BEST_FIT_CHARS  0x00000400
	WideCharToMultiByte(CP_ACP, 0, &chUnicode, 1, &chTrg, 1, &defaultChar, NULL);
	return chTrg;
}

inline TCHAR lcase (TCHAR c)
{
	if (c >= _T('A') && c <= _T('Z'))
		return (TCHAR)(_T('a') + c - _T('A'));
	else
		return c;
}

int FindNoCase(LPCTSTR szSrc, LPCTSTR szFind, int nStart)
{
	if(szSrc == NULL || szFind == NULL || nStart < 0)
		return -1;
	
	LPCTSTR szStart = szSrc;
	
	TCHAR szFirst = lcase(*szFind);
	szSrc += nStart;
	while(*szSrc)
	{
		if(lcase(*szSrc) == szFirst)
		{
			LPCTSTR a = szSrc + 1;
			LPCTSTR b = szFind + 1;
			
			while(*b)
				if(lcase(*a++) != lcase(*b++)) goto Jump;

			return (szSrc - szStart); 
		}
Jump:	szSrc++;

	}
	return -1;
}


// inline static bool isAmp(LPCTSTR p) {
//	return (p[0] == '&' && p[1] == 'a' && p[2] == 'm' && p[3] == 'p' &&  p[4] == ';');
//}

inline static void FixURL(LPWSTR pURL) {
	LPCWSTR pRead = pURL;
	LPWSTR pWrite = pURL;
	while (*pRead) {
		if (*pRead == '&') {
			WCHAR charExt = 0;
			WCHAR c = EntityToChar(pRead, FALSE, charExt);
			pRead++;
			*pWrite++ = c;
			if (charExt != 0) {
				*pWrite++ = charExt;
			}
		}
		else {
			*pWrite++ = *pRead++;
		}
	}
	*pWrite = 0;
}
