////////////////////////////////////////////////////////////////
// 1998 Microsoft Systems Journal
// If this code works, it was written by Paul DiLascia.
// If not, I don't know who wrote it.
//
#ifndef __FIXTB_H
#define __FIXTB_H

//////////////////
// This class fixes the sizing bugs in MFC that calculate the
// size of toolbars incorrectly for modern toobars (comctl32 version >= 4.71)
//
class CFixMFCToolBar : public CToolBar {
public:
	CFixMFCToolBar();
	virtual ~CFixMFCToolBar();

	static int iVerComCtl32; // version of commctl32.dll (eg 471)

	// There is a bug in comctl32.dll, version 4.71+ that causes it to
	// draw vertical separators in addition to horizontal ones, when the
	// toolbar is vertical. Set this to FALSE to eliminate them--but then
	// you lose your dropdown arrows.
	//
	BOOL m_bShowDropdownArrowWhenVertical;

	virtual CSize CalcFixedLayout(BOOL bStretch, BOOL bHorz);
	virtual CSize CalcDynamicLayout(int nLength, DWORD nMode);

	CSize CalcLayout(DWORD nMode, int nLength = -1);
	CSize CalcSize(TBBUTTON* pData, int nCount);
	int WrapToolBar(TBBUTTON* pData, int nCount, int nWidth);
	void SizeToolBar(TBBUTTON* pData, int nCount, int nLength,
		BOOL bVert = FALSE);

	virtual CSize GetButtonSize(TBBUTTON* pData, int iButton);

	// MFC has versions of these are hidden--why?
	//
	void GetButton(int nIndex, TBBUTTON* pButton) const;
	void SetButton(int nIndex, TBBUTTON* pButton);

	DECLARE_DYNAMIC(CFixMFCToolBar)
};

#endif
