// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// FileDlgEx.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_FILEDLGEX_H_)
#define AFX_FILEDLGEX_H_

#if _MSC_VER > 1000
#pragma once
#endif 

#include <afxcoll.h>


class CFileDlgEx : public CObject  
{
public:
	CFileDlgEx(DWORD dwFlags = OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT);
	virtual ~CFileDlgEx();
	
	OPENFILENAME m_ofn;
	CStringArray m_Filters;

	BOOL GetSaveFileName(CString& stFileName, LPCTSTR szDefExt = NULL, DWORD filterIndex = 1);
	BOOL GetOpenFileName(CString& stFileName, LPCTSTR szDefExt = NULL);
	
	void AddFilter(LPCTSTR szCaption, LPCTSTR szFilter);
	void ClearFilters() { m_Filters.RemoveAll(); }


	static BOOL BrowseForFolder(CString& stFolder, LPCTSTR szTitle);
};

#endif 
