// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// FileDlgEx.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "FileDlgEx.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


CFileDlgEx::CFileDlgEx(DWORD dwFlags)
{
	memset(&m_ofn, 0, sizeof(m_ofn));
	m_ofn.lStructSize = sizeof(m_ofn);
	m_ofn.nMaxFile = MAX_PATH;
	m_ofn.Flags = dwFlags;
}

CFileDlgEx::~CFileDlgEx()
{

}


BOOL CFileDlgEx::GetSaveFileName(CString& stFileName, LPCTSTR szDefExt, DWORD filterIndex)
{
	TCHAR szFileName[MAX_PATH]; 
	_tcscpy(szFileName, stFileName);
	m_ofn.hwndOwner = ::GetActiveWindow();
	m_ofn.lpstrFile = szFileName;
	m_ofn.lpstrDefExt = szDefExt; 
	m_ofn.nFilterIndex = filterIndex;

	CString stFilter;
	for(int n = 0; n < m_Filters.GetSize(); n++) {
		stFilter += m_Filters[n];
	}
	stFilter.Replace(_T('\1'), _T('\0'));

	m_ofn.lpstrFilter = (LPCTSTR)stFilter;

	if(!::GetSaveFileName(&m_ofn))
		return FALSE;

	stFileName = szFileName;
	return TRUE;
}


BOOL CFileDlgEx::GetOpenFileName(CString& stFileName, LPCTSTR szDefExt)
{
	TCHAR szFileName[MAX_PATH]; 
	_tcscpy(szFileName, stFileName);
	m_ofn.hwndOwner = ::GetActiveWindow();
	m_ofn.lpstrFile = szFileName;
	m_ofn.lpstrDefExt = szDefExt; 
	
	CString stFilter;
	for(int n = 0; n < m_Filters.GetSize(); n++) {
		stFilter += m_Filters[n];
	}
	stFilter.Replace(_T('\1'), _T('\0'));

	m_ofn.lpstrFilter = (LPCTSTR)stFilter;

	if(!::GetOpenFileName(&m_ofn))
		return FALSE;

	stFileName = szFileName;
	return TRUE;
}

void CFileDlgEx::AddFilter(LPCTSTR szCaption, LPCTSTR szFilter)
{
	CString stFilter(szCaption);

	stFilter += _T('\1');
	stFilter += szFilter;
	stFilter += _T('\1');

	m_Filters.Add(stFilter);
}



BOOL CFileDlgEx::BrowseForFolder(CString& stFolder, LPCTSTR szTitle)
{
	BOOL bRes = FALSE;
	LPMALLOC pMalloc = NULL;

	if (::SHGetMalloc(&pMalloc) == NOERROR)
	{
		BROWSEINFO bi;
		TCHAR pszBuffer[MAX_PATH] = _T("");
		LPITEMIDLIST pidl = NULL;
		// Get help on BROWSEINFO struct - it's got all the bit settings.
		bi.hwndOwner = ::GetActiveWindow();
		bi.pidlRoot = NULL;
		bi.pszDisplayName = pszBuffer;
		bi.lpszTitle = szTitle;
		bi.ulFlags = BIF_RETURNFSANCESTORS | BIF_RETURNONLYFSDIRS;
		bi.lpfn = NULL;
		bi.lParam = 0;
		// This next call issues the dialog box.
		if ((pidl = ::SHBrowseForFolder(&bi)) != NULL)
		{
			if (::SHGetPathFromIDList(pidl, pszBuffer))
			{ 
				stFolder = pszBuffer;
				bRes = TRUE;
			}
			// Free the PIDL allocated by SHBrowseForFolder.
			pMalloc->Free(pidl);
		}
		// Release the shell's allocator.
		pMalloc->Release();
	}

	return bRes;
}
