// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ExtIcon.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "ExtIcon.h"
#include "RegKey.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


template <> UINT AFXAPI HashKey <CString&> ( CString& String )
{
	LPCTSTR key = String;
	UINT nHash = 0;
	while (*key)
		nHash = (nHash<<5) + nHash + *key++;
	return nHash;
}


CExtIcon::CExtIcon()
{
}

CExtIcon::~CExtIcon()
{
	POSITION pos = m_Map.GetStartPosition();
	while(pos)
	{
		CString stKey;
		HICON Icon = NULL;
		m_Map.GetNextAssoc(pos, stKey, Icon);
		if(Icon)
			DestroyIcon(Icon);
	}
}

HICON CExtIcon::GetIconFromExtension(LPCTSTR Extension)
{
	CString stExt = Extension;
	stExt.MakeLower();
	HICON Icon = NULL;

	if(m_Map.Lookup(stExt, Icon))
		return Icon;
	

	if(stExt == _T("exe") || stExt == _T("com") || stExt == _T("scr") || stExt == _T("pif"))
	{
		ExtractIconEx(_T("shell32.dll"), 2, NULL, &Icon, 1);
		if(Icon)
		{
			m_Map.SetAt(stExt, Icon);
			return Icon;
		}
	}

	CRegistryKey Reg;
	CString stKey(_T("."));	
	CString stValue;

	stKey += Extension;

	if(Reg.Open(HKEY_CLASSES_ROOT, stKey, KEY_QUERY_VALUE))
	{
		Reg.QueryValue(NULL, stKey);	
		Reg.Close();
		if(!stKey.IsEmpty())
		{
			stKey += _T("\\DefaultIcon");
			if(Reg.Open(HKEY_CLASSES_ROOT, stKey, KEY_QUERY_VALUE))
			{
				Reg.QueryValue(NULL, stValue);	
				Reg.Close();
			}
		}
	}
	
	if(!stValue.IsEmpty())
	{
		TCHAR szBuf[MAX_PATH+1] = _T("");
		ExpandEnvironmentStrings(stValue, szBuf, MAX_PATH);
		stValue = szBuf;

		CString stFile;
		int nIconIdx = 0;

		int Idx = stValue.ReverseFind(_T(','));
		if(Idx > -1)
		{
			stFile = stValue.Left(Idx);
			nIconIdx = _ttoi(stValue.Mid(Idx+1));
		
			ExtractIconEx(stFile, nIconIdx, NULL, &Icon, 1);

			if(Icon == (HICON)1)
				Icon = NULL;
		}
	}


	if(Icon == NULL)
	{
		ExtractIconEx(_T("shell32.dll"), 0, NULL, &Icon, 1);
	}


	if(Icon)
		m_Map.SetAt(stExt, Icon);


	return Icon;
}