// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// EditReadOnly.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "EditReadOnly.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEditReadOnly

CEditReadOnly::CEditReadOnly()
{
	m_bHideCaret = FALSE;
}

CEditReadOnly::~CEditReadOnly()
{
}

BEGIN_MESSAGE_MAP(CEditReadOnly, CEdit)
	//{{AFX_MSG_MAP(CEditReadOnly)
	ON_WM_SETFOCUS()
	ON_WM_CHAR()
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CEditReadOnly 


void CEditReadOnly::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// Zeichen nur durchlassen, wenn Ctrl gedrckt ist:
	
	if(GetKeyState(VK_CONTROL) < 0)	
		CEdit::OnChar(nChar, nRepCnt, nFlags);
}


void CEditReadOnly::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{	
	if(nChar == VK_DOWN)
	{
		int idxBottomLine = GetFirstVisibleLine() + GetVisibleLines() - 1;
		if(GetCaretLine() < idxBottomLine)
			SetCaretLine(idxBottomLine);
	}

	if(nChar == VK_UP)
	{
		if(GetCaretLine() > GetFirstVisibleLine())
			SetCaretLine(GetFirstVisibleLine());
	}
	
	// nur Entf-Taste ausblenden:
	if(nChar != 46)
		CEdit::OnKeyDown(nChar, nRepCnt, nFlags);
}



LRESULT CEditReadOnly::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	switch(message)
	{
	case WM_PASTE:
	case WM_CUT:
	case WM_CLEAR:
		return 0;
	}
	
	return CEdit::WindowProc(message, wParam, lParam);
}

void CEditReadOnly::OnSetFocus(CWnd* pOldWnd) 
{
	CEdit::OnSetFocus(pOldWnd);
	if(m_bHideCaret)
		HideCaret();
}


int CEditReadOnly::GetVisibleLines()
{
	RECT rect;
	GetClientRect(&rect);
	int nHeight = rect.bottom;

	CClientDC dc(this);
	TEXTMETRIC tm;

	dc.GetTextMetrics(&tm);

	int nLineHeight = tm.tmHeight + tm.tmExternalLeading;
	
	return nHeight / nLineHeight;
}


void CEditReadOnly::SetCaretLine(int nLine, BOOL bNoScroll)
{
	int nCrPos = LineIndex(nLine);
	SetSel(nCrPos, nCrPos, bNoScroll);
}
