// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// DlgSource.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "PopMan.h"
#include "DlgSource.h"
#include "StrFunctions.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


//  i18nComment("Source Dialog")

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CDlgSource 


CDlgSource::CDlgSource(CString stSubject, const CString& stSource, CWnd* pParent /*=NULL*/)
	: CDialog(CDlgSource::IDD, pParent)
{
	m_stSubject = stSubject;

	if(!AfxInitRichEdit())
	{
		AfxMessageBox(i18n("RichEdit control init failed."));
		return;
	}
	
	if(!Create(CDlgSource::IDD, pParent))
		return;

    ShowWindow(SW_SHOWMAXIMIZED);

	
	InitGUIText();
	
	
	CHARFORMAT cf = 
	{ 
	    sizeof(CHARFORMAT), 
		CFM_EFFECTS | CFM_PROTECTED | CFM_SIZE | CFM_OFFSET | CFM_COLOR | CFM_CHARSET | CFM_FACE, 
		CFE_AUTOCOLOR,	// effects 
		200,			// height, 	200 twips == 10 points
		0,				// offset 
		0,				// color (not used since CFE_AUTOCOLOR is specified) 
		ANSI_CHARSET, 
		FF_MODERN | FIXED_PITCH,	// pitch and family 
		_T("Courier New")	// kein UNICODE-String, wenn die RichEdit-Version < 2 ist!!!
	}; 

	
	m_RichEdit.SetDefaultCharFormat(cf);
	m_RichEdit.SetWindowText(stSource);

	//{{AFX_DATA_INIT(CDlgSource)
	//}}AFX_DATA_INIT
}


void CDlgSource::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgSource)
	DDX_Control(pDX, IDC_RICHEDIT_SOURCE, m_RichEdit);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgSource, CDialog)
	//{{AFX_MSG_MAP(CDlgSource)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_APP_UPDATE_GUI, InitGUIText)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////

void CDlgSource::PostNcDestroy() 
{
	CDialog::PostNcDestroy();
	delete this;
}

void CDlgSource::OnCancel() {
	DestroyWindow();
}

void CDlgSource::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	m_RichEdit.MoveWindow(0, 0, cx, cy);
}


void CDlgSource::InitGUIText()
{
	CString stTitle;
	stTitle = StrFormat(i18n("Source - \"{1}\""), _T("s"), (LPCTSTR)m_stSubject);
	SetWindowText(stTitle);
}
