// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// DlgSettings.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_DLGSETTINGS_H_)
#define AFX_DLGSETTINGS_H_

#if _MSC_VER > 1000
#pragma once
#endif 

#include <afxtempl.h>
#include "StaticLink.h"
#include "PopMan.h"

class CAccounts;
class CAccount;

/////////////////////////////////////////////////////////////////////////////
// CPropSheet_Settings
/////////////////////////////////////////////////////////////////////////////
class CPropSheet_Settings : public CPropertySheet
{
	DECLARE_DYNAMIC(CPropSheet_Settings)

public:
	CPropSheet_Settings(LPCTSTR pszCaption, CWnd* pParentWnd = NULL, UINT iSelectPage = 0);

	virtual ~CPropSheet_Settings();

public:
	//{{AFX_VIRTUAL(CPropSheet_Settings)
	public:
	virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

protected:
	LPCTSTR m_szTitle;

	void OnUpdateGUI();
	//{{AFX_MSG(CPropSheet_Settings)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CPropPage_Notification 
/////////////////////////////////////////////////////////////////////////////
class CPropPage_Notification : public CPropertyPage
{
	DECLARE_DYNCREATE(CPropPage_Notification)

public:
	CPropPage_Notification(LPCTSTR szTitle = NULL);
	~CPropPage_Notification();

	//{{AFX_DATA(CPropPage_Notification)
	enum { IDD = IDD_PROPPAGE_NOTIFICATION };
	CComboBox	m_cboKeyboard;
	CButton	m_chkKeyboard;
	CButton	m_chkBallon;
	CEdit	m_editSoundFile;
	CButton	m_chkSound;
	CString	m_stSoundFile;
	BOOL	m_bSoundNotification;
	BOOL	m_bBallonTip;
	BOOL	m_bNotifyProtectedOnly;
	//}}AFX_DATA
	
	enum NOTIFYSTATES 
	{
		Minimized   = 1,
		AutoChecked = 2,
		Always      = 3
	};

	NOTIFYSTATES  m_nNotify;	
	BOOL m_bShowBallonOption;
	BOOL m_bShowMainWnd;

	CButton	m_chkNewMailTip;

	BOOL	m_bShowNewMailTip;
	BOOL	m_bDetailedNewTip;

	enum KEYBOARDLIGHT
	{
		None = 0,
		ScrollLock = 1,
		NumLock = 2,
		CapsLock = 3,
	};

	KEYBOARDLIGHT m_KeyboardLight;

	//{{AFX_VIRTUAL(CPropPage_Notification)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);  
	//}}AFX_VIRTUAL

protected:
	void InitGUIText();
	
	struct KeyMap {
		LPCTSTR		  Caption;
		KEYBOARDLIGHT Value;
	};

	static KeyMap m_KeyMap[];

	//{{AFX_MSG(CPropPage_Notification)
	virtual BOOL OnInitDialog();
	afx_msg void OnSelectSoundFile();
	afx_msg void OnNotifySound_Click();
	afx_msg void OnPlaySound();
	afx_msg void OnNewMailTip();
	afx_msg void OnCheckNotifyKeyboard();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};



/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CPropPage_Layout 
/////////////////////////////////////////////////////////////////////////////
class CPropPage_Layout : public CPropertyPage
{
	DECLARE_DYNCREATE(CPropPage_Layout)

public:
	CPropPage_Layout(LPCTSTR szTitle = NULL);  
	~CPropPage_Layout(); 

	//{{AFX_DATA(CPropPage_Layout)
	enum { IDD = IDD_PROPPAGE_LAYOUT };
	CStatic	m_staticIcon;
	CButton	m_chkPreview;
	BOOL	m_bPreview;
	BOOL	m_bMarkUnread;
	//}}AFX_DATA
	
	enum PREVIEW_LAYOUT
	{
		layoutBelow = 0,
		layoutBeside = 1
	};

	PREVIEW_LAYOUT m_PreviewLayout;

	//{{AFX_VIRTUAL(CPropPage_Layout)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);   
	//}}AFX_VIRTUAL

protected:
	void InitGUIText();
	
	//{{AFX_MSG(CPropPage_Layout)
	afx_msg void OnShowPreview_Click();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};



/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CPropPage_Logging 
/////////////////////////////////////////////////////////////////////////////
class CPropPage_Logging : public CPropertyPage
{
	DECLARE_DYNCREATE(CPropPage_Logging)

public:
	CPropPage_Logging(LPCTSTR szTitle = NULL);
	~CPropPage_Logging();

	//{{AFX_DATA(CPropPage_Logging)
	enum { IDD = IDD_PROPPAGE_LOGGING };
	CSpinButtonCtrl	m_spinLogSize;
	CSpinButtonCtrl	m_spinLogSizeRules;
	CButton	m_chkLoggingRules;
	CStatic	m_staticIcon;
	CButton	m_chkLogging;
	BOOL	m_bLoggingEnabled;
	BOOL	m_bLoggingRules;
	int		m_nMaxLogSizeRules;
	int		m_nMaxLogSize;
	BOOL	m_bCompactLogging;
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CPropPage_Logging)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX); 
	//}}AFX_VIRTUAL

protected:
	void InitGUIText();

	CStaticLink m_LogDir;
	
	//{{AFX_MSG(CPropPage_Logging)
	afx_msg void OnCheckEnableLogging();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CPropPage_General 
/////////////////////////////////////////////////////////////////////////////
class CPropPage_General : public CPropertyPage
{
	DECLARE_DYNCREATE(CPropPage_General)

public:
	CPropPage_General(LPCTSTR szTitle = NULL);
	~CPropPage_General();

	//{{AFX_DATA(CPropPage_General)
	enum { IDD = IDD_PROPPAGE_GENERAL };
	CStatic	m_staticIcon;
	BOOL	m_bAutoStart;
	BOOL	m_bCheckMailOnStartup;
	BOOL	m_bUseDialUp;
	BOOL	m_bMarkDelete;
	//}}AFX_DATA
	UINT	m_nStartCheckDelay;
	CEdit	m_editStartCheckDelay;
	CSpinButtonCtrl	m_spinStartCheckDelay;
	CButton	m_chkCheckMailOnStartup;
	BOOL m_bXHide;
	BOOL m_bMinHide;

	BOOL m_bConfirmDeleteMain;
	BOOL m_bConfirmDeleteMsg;

	BOOL	m_bPasswordProtect;
	CString m_stPassword;


	//{{AFX_VIRTUAL(CPropPage_General)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
	//}}AFX_VIRTUAL

protected:
	void InitGUIText();
	
	//{{AFX_MSG(CPropPage_General)
	virtual BOOL OnInitDialog();
	afx_msg void OnCheckMailsOnStartup();
	//}}AFX_MSG
	afx_msg void OnCheckPassword();

	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CPropPage_AutoCheck 
/////////////////////////////////////////////////////////////////////////////
class CPropPage_AutoCheck : public CPropertyPage
{
	DECLARE_DYNCREATE(CPropPage_AutoCheck)

public:
	CPropPage_AutoCheck(LPCTSTR szTitle = NULL);
	~CPropPage_AutoCheck();

	//{{AFX_DATA(CPropPage_AutoCheck)
	enum { IDD = IDD_PROPPAGE_AUTOCHECK };
	CButton	m_chkEnableCustomAutoCheck;
	CListCtrl	m_listAutoAccs;
	CDateTimeCtrl	m_dtTo;
	CDateTimeCtrl	m_dtFrom;
	CButton	m_chkAutoCheckSuspend;
	CSpinButtonCtrl	m_spinUpdateInterval;
	CEdit	m_editUpdateInterval;
	BOOL	m_bAutoCheckMinimized;
	BOOL	m_bSuspendAutoCheck;
	UINT	m_nUpdateInterval;
	BOOL	m_bEnableCustomAutoCheck;
	//}}AFX_DATA

	UINT	m_nSuspendFrom;
	UINT	m_nSuspendTo;

	CAccounts* m_pAccounts;

	//{{AFX_VIRTUAL(CPropPage_AutoCheck)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
	//}}AFX_VIRTUAL

protected:
	void OnListClick(POINT point);
	void InitGUIText();
	void GetSubItemBounds(int nItem, int nSubItem, RECT& rcItem);
	int  GetItemFromPoint(CPoint point);

	struct AccInfo
	{
		CAccount*	pAcc;
		BOOL		bCustom;
		UINT		nInterval;
	};

	int m_nLabelEditIdx;
	//COleDateTime m_nLastEditTime;
	bool m_bFirstFocus;
	//{{AFX_MSG(CPropPage_AutoCheck)
	virtual BOOL OnInitDialog();
	afx_msg void OnAutocheckSuspend();
	afx_msg void OnDestroy();
	afx_msg void OnBeginlabeleditListAutocheckAccs(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnEndlabeleditListAutocheckAccs(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSetfocusListAutocheckAccs(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnClickListAutocheckAccs(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDblclkListAutocheckAccs(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCustomAutoCheck();
	//}}AFX_MSG
	afx_msg void OnCustomDraw(NMHDR* pNMHDR, LRESULT* pResult);

	DECLARE_MESSAGE_MAP()

};


/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CPropPage_EmailClient 
/////////////////////////////////////////////////////////////////////////////
class CPropPage_EmailClient : public CPropertyPage
{
	DECLARE_DYNCREATE(CPropPage_EmailClient)

public:
	CPropPage_EmailClient(LPCTSTR szTitle = NULL);
	~CPropPage_EmailClient();

	//{{AFX_DATA(CPropPage_EmailClient)
	enum { IDD = IDD_PROPPAGE_EMAIL_CLIENT };
	CComboBox	m_cbClient;
	BOOL		m_bHTMLReply;
	BOOL		m_bEnforceAddress;
	CString	m_stReplyParam;
	//}}AFX_DATA
	CComboBox m_cboLaunchAction;

	enum REPLYOPTIONS
	{
		Eml      =  1,
		MAPI     =  2,
		MailTo   =  3,
		CmdParam =  4
	};

	REPLYOPTIONS  m_nReplyOption;	
	CString m_stEmailClient;

	enum CLIENTLAUNCHACTION
	{
		NoAction	= 0,
		Quit		= 1,
		HideToTray	= 2
	};

	CLIENTLAUNCHACTION m_ClientLaunchAction;
	LPCTSTR m_szHideToTray;
	LPCTSTR m_szQuit;
	LPCTSTR m_szNothing;

	//{{AFX_VIRTUAL(CPropPage_EmailClient)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);   
	//}}AFX_VIRTUAL

protected:
	void InitGUIText();
	
	void UpdateMAPIOptions();
	//{{AFX_MSG(CPropPage_EmailClient)
	afx_msg void OnBrowseClient();
	afx_msg void OnClientLaunch();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:

	class MailClient
	{
	public:
		MailClient() {};
		MailClient(const CString& stName, const CString& stPath) { 
			m_stName = stName;
			m_stPath = stPath;
		};

		CString m_stName;
		CString m_stPath;
	};


	class CMailClients : public CArray<MailClient, MailClient&>
	{
	public:
		void LoadFromRegistry();
		int FindName(const CString& stName, int nPos = 0);
		int FindPath(const CString& stPath, int nPos = 0);
	};

	CMailClients m_MailClients;

};



/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CPropPage_TrayIcon 
/////////////////////////////////////////////////////////////////////////////
class CPropPage_TrayIcon : public CPropertyPage
{
	DECLARE_DYNCREATE(CPropPage_TrayIcon)

public:
	CPropPage_TrayIcon(LPCTSTR szTitle = NULL);
	~CPropPage_TrayIcon();

	//{{AFX_DATA(CPropPage_TrayIcon)
	enum { IDD = IDD_PROPPAGE_TRAY };
	CButton	m_chkRotate;
	CSpinButtonCtrl	m_spinRotationInterval;
	CButton	m_chkNumMails;
	BOOL	m_bNumMailsInTray;
	BOOL	m_bHighColorTray;
	UINT	m_nRotationInterval;
	BOOL	m_bRotateMailNum;
	BOOL	m_bAdvancedTrayInfo;
	//}}AFX_DATA

	BOOL m_bHighColorTrayEnabled;

	enum NUMMAILSTRAY
	{
		All    = 0,
		New    = 1,
		Unread = 2
	};

	NUMMAILSTRAY m_numMails;

	//{{AFX_VIRTUAL(CPropPage_TrayIcon)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
	//}}AFX_VIRTUAL

protected:
	void InitGUIText();
	
	//{{AFX_MSG(CPropPage_TrayIcon)
	virtual BOOL OnInitDialog();
	afx_msg void OnCheckNumMessages();
	afx_msg void OnRotateAccs();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};



/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CPropPage_MouseAction 
/////////////////////////////////////////////////////////////////////////////
class CPropPage_MouseAction : public CPropertyPage
{
	DECLARE_DYNCREATE(CPropPage_MouseAction)

public:
	CPropPage_MouseAction(LPCTSTR szTitle = NULL);
	~CPropPage_MouseAction();

	//{{AFX_DATA(CPropPage_MouseAction)
	enum { IDD = IDD_PROPPAGE_MOUSE_ACTION };
	CComboBox	m_cboRight;
	CComboBox	m_cboMiddle;
	CComboBox	m_cboLeft;
	CComboBox	m_cboDouble;
	BOOL	m_bDoubleClickDelay;
	//}}AFX_DATA
	
	enum TRAYACTIONS
	{
		Nothing			 = 0,
		ShowWindow		 = 1,
		CheckMail		 = 2,
		PopUpMenu		 = 3,
		RunEmailClient   = 4,
		CheckAndShow	 = 5,
		ToggleWindow     = 6,
		ToggleAutoCheck  = 7,
		ShowMailInfo     = 8,
	};

	TRAYACTIONS m_actionLeftClick;
	TRAYACTIONS m_actionMiddleClick;
	TRAYACTIONS m_actionRightClick;
	TRAYACTIONS m_actionDoubleClick;

private:
	struct TrayAction
	{
		TRAYACTIONS	Action;
		LPCTSTR		szName;
	};

	CArray<TrayAction, TrayAction&> m_ActionNameMap;
	//{{AFX_VIRTUAL(CPropPage_MouseAction)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);  
	//}}AFX_VIRTUAL

protected:
	void InitGUIText();
	
	void LoadActionMap();
	TRAYACTIONS GetAction(CComboBox& Combo);
	void SelectAction(CComboBox& Combo, TRAYACTIONS Action);
	void FillComboBox(CComboBox& Combo);
	//{{AFX_MSG(CPropPage_MouseAction)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};


/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CPropPage_Language 
/////////////////////////////////////////////////////////////////////////////
class CPropPage_Language : public CPropertyPage
{
	DECLARE_DYNCREATE(CPropPage_Language)

public:
	CPropPage_Language(LPCTSTR szTitle = NULL);
	~CPropPage_Language();

	//{{AFX_DATA(CPropPage_Language)
	enum { IDD = IDD_PROPPAGE_LANGUAGE };
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CPropPage_Language)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX); 
	//}}AFX_VIRTUAL

protected:
	CComboBox	m_cboLang;

	CLanguages m_Items;

	void ShowLangInfo(const LANGUAGE& Lang);
	void SortLanguages();

	void InitGUIText();

	CStaticLink	 m_LinkEmail;
	CStaticLink	 m_LinkWeb;

	afx_msg void OnSelectLanguage();

	//{{AFX_MSG(CPropPage_Language)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

//{{AFX_INSERT_LOCATION}}

#endif // AFX_DLGSETTINGS_H_

