// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// DlgSave.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "DlgSave.h"
#include "FileDlgEx.h"
#include "StrFunctions.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//  i18nComment("Save Dialog")

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CDlgSave 

CDlgSave::CDlgSave(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgSave::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgSave)
	m_stFolder = _T("");
	m_stTemplate = _T("");
	//}}AFX_DATA_INIT
	m_SaveAs = frmEmlFile;
}


void CDlgSave::DoDataExchange(CDataExchange* pDX)
{
	if(m_stFolder.GetLength() > 3 && m_stFolder.Right(1) == _T("\\"))
		m_stFolder.TrimRight(_T('\\'));

	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgSave)
	DDX_Text(pDX, IDC_EDIT_SAVE_FOLDER, m_stFolder);
	DDX_Text(pDX, IDC_EDIT_FILENAME_FORMAT, m_stTemplate);
	//}}AFX_DATA_MAP



	if(pDX->m_bSaveAndValidate)
	{
		if(m_stFolder.IsEmpty())
		{
			AfxMessageBox(i18n("Please specify where to save the emails."));
			pDX->PrepareEditCtrl(IDC_EDIT_SAVE_FOLDER);
			pDX->Fail();
			return;
		}

		if(m_stFolder.Right(1) == _T("\\"))
			m_stFolder.TrimRight(_T('\\'));

		CFileStatus Status;
		BOOL bValid = (CFile::GetStatus(m_stFolder, Status) == TRUE && (Status.m_attribute & CFile::Attribute::directory));

		if(!bValid)
		{
			AfxMessageBox(i18n("The specified folder does not exist!"));
			pDX->PrepareEditCtrl(IDC_EDIT_SAVE_FOLDER);
			pDX->Fail();
			return;
		}
	
		if(m_stTemplate.IsEmpty())
		{
			AfxMessageBox(i18n("Please specify a template for the file names."));
			pDX->PrepareEditCtrl(IDC_EDIT_FILENAME_FORMAT);
			pDX->Fail();
			return;
		}

		CString stInvalidChars; stInvalidChars.Format(IDS_INVALID_FILECHARS);
		if(-1 != m_stTemplate.FindOneOf(stInvalidChars))
		{
			CString stMsg = i18n("A file name must not contain any of the following characters:");
			stMsg += _T("\r\n");
			AfxMessageBox(stMsg + stInvalidChars);
			pDX->PrepareEditCtrl(IDC_EDIT_FILENAME_FORMAT);
			pDX->Fail();
			return;
		}


		if(!CheckTemplate())
		{
			CString stMsg = i18n("Invalid template! Use a combination of the following placeholders:");
			CString stFormat;
			stFormat.Format(_T("\r\n\r\n[%s]\r\n[%s]\r\n[%s]\r\n[%s]\r\n[%s]"), 
							i18n("Subject"),
							i18n("From"),
							i18n("To"),
							i18n("Date"),
							i18n("Time")
											);
			AfxMessageBox(stMsg + stFormat);
			pDX->PrepareEditCtrl(IDC_EDIT_FILENAME_FORMAT);
			pDX->Fail();
			return;
		}
	}

	
	if(pDX->m_bSaveAndValidate)
	{
		if(((CButton*)GetDlgItem(IDC_RADIO_EML))->GetCheck() == 1)
			m_SaveAs = frmEmlFile;
		else
			m_SaveAs = frmTxtFile;
	}
	else
	{
		if(m_SaveAs == frmEmlFile)
			((CButton*)GetDlgItem(IDC_RADIO_EML))->SetCheck(1);
		else
			((CButton*)GetDlgItem(IDC_RADIO_TXT))->SetCheck(1);
	}
}


BEGIN_MESSAGE_MAP(CDlgSave, CDialog)
	//{{AFX_MSG_MAP(CDlgSave)
	ON_BN_CLICKED(IDC_BUTTON_BROWSE, OnBrowse)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



void CDlgSave::OnBrowse() 
{
	CString stFolder;
	if(!CFileDlgEx::BrowseForFolder(stFolder, i18n("Please specify where to save the emails.")))
		return;

	GetDlgItem(IDC_EDIT_SAVE_FOLDER)->SetWindowText(stFolder);
}

void CDlgSave::InitGUIText()
{
	SetWindowText(i18n("Save As..."));
	SetDlgItemText(IDC_STATIC_DEST,			i18n("Destination"));
	SetDlgItemText(IDC_STATIC_FOLDER,		i18n("Folder:"));
	SetDlgItemText(IDC_BUTTON_BROWSE,		i18n("Browse..."));
	SetDlgItemText(IDC_STATIC_SAVE_FORMAT,	i18n("Save Format"));
	SetDlgItemText(IDC_STATIC_TEMPLATE,		i18n("Template For File Names"));
	SetDlgItemText(IDC_RADIO_EML,			i18n("Email File (*.eml)"));
	SetDlgItemText(IDC_RADIO_TXT,			i18n("Text File (*.txt)"));
	SetDlgItemText(IDOK,					i18n("OK"));
	SetDlgItemText(IDCANCEL,				i18n("Cancel"));

}

BOOL CDlgSave::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	InitGUIText();

	return TRUE; 
}

BOOL CDlgSave::CheckTemplate()
{
	CString stSubject = i18n("Subject"); stSubject.MakeLower();
	CString stFrom    = i18n("From");	 stFrom.MakeLower();
	CString stTo	  = i18n("To");		 stTo.MakeLower();
	CString stDate	  = i18n("Date");	 stDate.MakeLower();
	CString stTime    = i18n("Time");	 stTime.MakeLower();
	
	CString stItem;
	int nIdx = 0;
	
	while(nIdx > -1)
	{
		ParseConst(m_stTemplate, _T("["), nIdx);
		if(m_stTemplate.Find(_T(']'), nIdx) == -1) break;
		stItem = ParseConst(m_stTemplate, _T("]"), nIdx);
		if(stItem.IsEmpty()) continue;

		stItem.MakeLower();
		if(stItem == stSubject) continue;
		if(stItem == stFrom) continue;
		if(stItem == stTo) continue;
		if(stItem == stDate) continue;
		if(stItem == stTime) continue;

		return FALSE;
	}
	return TRUE;
}
