// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// DlgRulesItem.cpp
//
////////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "DlgRulesItem.h"
#include "DialogHelper.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//  i18nComment("Add item to Rules list Dialog")

CDlgRulesItem::CDlgRulesItem(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgRulesItem::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgRulesItem)
	m_nDestinationList = 0;
	m_stNewItem = _T("");
	//}}AFX_DATA_INIT
    m_ItemType = ItemType::typeWord;
}

BOOL CDlgRulesItem::OnInitDialog()
{
	CDialog::OnInitDialog();

    int i;
    for(i = 0; i < m_AvailableLists.GetSize(); ++i)
        m_cboLists.AddString(m_AvailableLists[i]);

    m_cboLists.SetCurSel(m_nDestinationList);

    for(i = 0; i < m_NewItemSuggestions.GetSize(); ++i)
        m_cboNewItem.AddString(m_NewItemSuggestions[i]);

    InitGUIText();

    OnSelchangeDestList();
	
	return TRUE;       
}

void CDlgRulesItem::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CDlgRulesItem)
	DDX_Control(pDX, IDC_COMBO_NEW_ITEM, m_cboNewItem);
	DDX_Control(pDX, IDC_COMBO_LISTS, m_cboLists);
	DDX_CBIndex(pDX, IDC_COMBO_LISTS, m_nDestinationList);
	DDX_CBString(pDX, IDC_COMBO_NEW_ITEM, m_stNewItem);
	//}}AFX_DATA_MAP 

    RadioMapping<ItemType> mapping[] = 
    {
        RadioMapping<ItemType>(IDC_RADIO_ITEM_TYPE_STRING, ItemType::typeString),
        RadioMapping<ItemType>(IDC_RADIO_ITEM_TYPE_REGEX,  ItemType::typeRegEx),
        RadioMapping<ItemType>(IDC_RADIO_ITEM_TYPE_WORD,   ItemType::typeWord)
    };
    DDX_MapRadio(pDX, m_ItemType, mapping, sizeof(mapping)/sizeof(mapping[0]));
}

BEGIN_MESSAGE_MAP(CDlgRulesItem, CDialog)
	//{{AFX_MSG_MAP(CDlgRulesItem)
	ON_CBN_SELCHANGE(IDC_COMBO_LISTS, OnSelchangeDestList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CDlgRulesItem::InitGUIText()
{
    SetWindowText(i18n("Add item to Rules list"));

	SetDlgItemText(IDOK,		i18n("OK"));
	SetDlgItemText(IDCANCEL,	i18n("Cancel"));

	SetDlgItemText(IDC_STATIC_LIST,	      i18n("Destination List"));
    SetDlgItemText(IDC_STATIC_NEW_ITEM,	  i18n("New Item"));
    SetDlgItemText(IDC_STATIC_ITEM_TYPE,  i18n("Item Type"));

    SetDlgItemText(IDC_RADIO_ITEM_TYPE_WORD,   i18n("Word"));
    SetDlgItemText(IDC_RADIO_ITEM_TYPE_STRING, i18n("String"));
    SetDlgItemText(IDC_RADIO_ITEM_TYPE_REGEX,  i18n("Regular Expression"));
}

void CDlgRulesItem::OnSelchangeDestList() 
{
    BOOL bEnabled = m_cboLists.GetCurSel() >= 0;
    ((CWnd*)GetDlgItem(IDOK))->EnableWindow(bEnabled);
}
