// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// DlgPass.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "DlgPass.h"
#include "PopMan.h"
#include "StrFunctions.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


//  i18nComment("Password Dialog")

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CDlgPass 


CDlgPass::CDlgPass(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgPass::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgPass)
	m_bRemember = FALSE;
	m_stPass = _T("");
	m_stUser = _T("");
	m_stAccount = _T("");
	//}}AFX_DATA_INIT
}


void CDlgPass::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgPass)
	DDX_Control(pDX, IDC_STATIC_ICON, m_staticIcon);
	DDX_Check(pDX, IDC_CHECK_REMEMBER_PASS, m_bRemember);
	DDX_Text(pDX, IDC_EDIT_PASSWORD, m_stPass);
	DDX_Text(pDX, IDC_STATIC_USER, m_stUser);
	DDX_Text(pDX, IDC_STATIC_ACCOUNT, m_stAccount);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgPass, CDialog)
	//{{AFX_MSG_MAP(CDlgPass)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL CDlgPass::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_staticIcon.SetIcon(CPopManApp::GetIcon(IDI_PASSWORD));

	InitGUIText();
	
	return TRUE;  
}

void CDlgPass::InitGUIText()
{
	CString stTitle = StrFormat(i18n("Password - {1}"), _T("s"), (LPCTSTR)m_stAccount);
	SetWindowText(stTitle);

	SetDlgItemText(IDC_STATIC_ENTER,		i18n("Enter the password of the following account."));
	SetDlgItemText(IDC_STATIC_ACCOUNT_NAME,	i18n("Account:"));
	SetDlgItemText(IDC_STATIC_USER_NAME,	i18n("User name:"));
	SetDlgItemText(IDC_STATIC_PASS,			i18n("Password:"));
	SetDlgItemText(IDC_CHECK_REMEMBER_PASS,	i18n("Remember password"));
	SetDlgItemText(IDOK,					i18n("OK"));
	SetDlgItemText(IDCANCEL,				i18n("Cancel"));
}


/////////////////////////////////////////////////////////////////////////////
//  CDlgAppPass 

CDlgAppPass::CDlgAppPass(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgAppPass::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgAppPass)
	//}}AFX_DATA_INIT
}

void CDlgAppPass::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgAppPass)
	DDX_Control(pDX, IDC_STATIC_ICON, m_staticIcon);
	//}}AFX_DATA_MAP
}


BOOL CDlgAppPass::OnInitDialog() 
{
	CDialog::OnInitDialog();
		
	m_staticIcon.SetIcon(CPopManApp::GetIcon(IDI_PASSWORD));

	InitGUIText();
	
	return TRUE; 
}


BEGIN_MESSAGE_MAP(CDlgAppPass, CDialog)
	//{{AFX_MSG_MAP(CDlgAppPass)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CDlgAppPass::OnOK() 
{
	CString stPass;
	GetDlgItemText(IDC_EDIT_PASSWORD, stPass);

	if(m_stPass != stPass || m_stPass.IsEmpty())
	{
		AfxMessageBox(i18n("Password incorrect! Please note that the password is case-sensitive."));
		SetDlgItemText(IDC_EDIT_PASSWORD, _T(""));
		GetDlgItem(IDC_EDIT_PASSWORD)->SetFocus();
		return;
	}

	CDialog::OnOK();
}

void CDlgAppPass::InitGUIText()
{
	SetDlgItemText(IDC_STATIC_ENTER_PASS,	i18n("Please enter the password."));
	SetDlgItemText(IDC_STATIC_PASS,			i18n("Password:"));
	SetDlgItemText(IDOK,					i18n("OK"));
	SetDlgItemText(IDCANCEL,				i18n("Cancel"));
}
