// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// DlgMailAddressList.h
//
////////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_DLGMAILADDRESSLIST_H_)
#define AFX_DLGMAILADDRESSLIST_H_

#if _MSC_VER > 1000
#pragma once
#endif 

#include "resource.h"


/////////////////////////////////////////////////////////////////////////////
// DlgMailAddressList 

class CDlgMailAddressList : public CDialog
{
public:

    enum MailAddListTypes {
        BlackList,
        WhiteList
    };

	CDlgMailAddressList(MailAddListTypes listType, CWnd* pParent = NULL);

	//{{AFX_DATA(CDlgMailAddressList)
	enum { IDD = IDD_MAILADDRESS_LIST };
	CListBox	m_listSender;
	//}}AFX_DATA


	//{{AFX_VIRTUAL(CDlgMailAddressList)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);   
	//}}AFX_VIRTUAL

   

private:
    MailAddListTypes m_ListType;

public:
	CStringArray m_Addresses;
	CStringArray m_Domains;

protected:
	//{{AFX_MSG(CDlgMailAddressList)
	virtual BOOL OnInitDialog();
	afx_msg void OnListRemove();
	afx_msg void OnListAdd();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()


	void InitGUIText();
	void EnableButtons();
};

//{{AFX_INSERT_LOCATION}}

#endif // AFX_DLGMAILADDRESSLIST_H_
