// PopMan - a Windows POP3 manager
//
// Copyright (C) 2002-2010 Christian Hbner (chuebner@ch-software.de)
// All Rights Reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// DlgMailAddressList.cpp
//
////////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "DlgMailAddressList.h"
#include "DlgInput.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// DlgMailAddressList 

//  i18nComment("BlackList/WhiteList Dialog")

CDlgMailAddressList::CDlgMailAddressList(MailAddListTypes listType, CWnd* pParent /*=NULL*/)
	: m_ListType(listType), CDialog(CDlgMailAddressList::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgMailAddressList)
	//}}AFX_DATA_INIT
}


BOOL CDlgMailAddressList::OnInitDialog() 
{
	CDialog::OnInitDialog();
	InitGUIText();	
	EnableButtons();
	return TRUE; 
}



void CDlgMailAddressList::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgMailAddressList)
	DDX_Control(pDX, IDC_MAILADDLIST, m_listSender);
	//}}AFX_DATA_MAP

	
	if(pDX->m_bSaveAndValidate)
	{
		m_Addresses.SetSize(m_listSender.GetCount());
		m_Domains.SetSize(m_listSender.GetCount());
		int nSenders = 0;
		int nDomains = 0;
		for(int i = 0; i < m_listSender.GetCount(); ++i)
		{
			CString buffer;
			m_listSender.GetText(i, buffer);
		
			if(buffer.Find(_T('@')) >= 0)
				m_Addresses[nSenders++] = buffer;
			else
				m_Domains[nDomains++] = buffer;
		}
		m_Addresses.SetSize(nSenders);
		m_Domains.SetSize(nDomains);

	}
	else
	{	
		for(int n = 0; n < m_Domains.GetSize(); ++n) 
			m_listSender.AddString(m_Domains[n]);
		for(int i = 0; i < m_Addresses.GetSize(); ++i) 
			m_listSender.AddString(m_Addresses[i]);
	}
}


void CDlgMailAddressList::EnableButtons() 
{
	BOOL bSelected = (m_listSender.GetCurSel() != LB_ERR);
	GetDlgItem(IDC_LIST_REMOVE)->EnableWindow(bSelected);
}

void CDlgMailAddressList::InitGUIText()
{
    switch(m_ListType)
    {
    case MailAddListTypes::BlackList:
    	SetWindowText(i18n("Black List"));
	    SetDlgItemText(IDC_STATIC_LIST,      i18n("Messages from senders in the list below will be deleted automatically from the server."));
        break;

    case MailAddListTypes::WhiteList:
    	SetWindowText(i18n("White List"));
	    SetDlgItemText(IDC_STATIC_LIST,      i18n("Messages from senders in the list below will never be deleted automatically."));
        break;
    }
	SetDlgItemText(IDC_LIST_ADD,		 i18n("&Add..."));
	SetDlgItemText(IDC_LIST_REMOVE,		 i18n("&Remove"));
	SetDlgItemText(IDOK,				 i18n("&Close"));
}

BEGIN_MESSAGE_MAP(CDlgMailAddressList, CDialog)
	//{{AFX_MSG_MAP(CDlgMailAddressList)
	ON_BN_CLICKED(IDC_LIST_REMOVE, OnListRemove)
	ON_BN_CLICKED(IDC_LIST_ADD, OnListAdd)
	//}}AFX_MSG_MAP
	ON_LBN_SELCHANGE(IDC_BLACKLIST, EnableButtons)
END_MESSAGE_MAP()

void CDlgMailAddressList::OnListRemove() 
{
	int iSel = m_listSender.GetCurSel();
	if(iSel == LB_ERR)
		return;

	m_listSender.DeleteString(iSel);

	m_listSender.SetCurSel(iSel);
	m_listSender.SetFocus();
	
	EnableButtons();
}

void CDlgMailAddressList::OnListAdd() 
{
	CDlgInput input(this);
	input.m_stHint = i18n("Address:");
	input.m_stMessage = i18n("Please enter the email address (e.g. somebody@somewhere.com) or the domain (e.g. somewhere.com):");
	input.m_stTitle = i18n("Enter address");
	input.m_bAcceptEmptyInput = FALSE;

	if(input.DoModal() == IDOK)
	{
		if(!input.m_stValue.IsEmpty())
			m_listSender.AddString(input.m_stValue);
	}
}
